/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.google.common.base.Strings;
import org.gradle.api.InvalidUserDataException;

public enum Stl {
    SYSTEM("system", "system", true),
    STLPORT_STATIC("stlport_static", "stlport", true),
    STLPORT_SHARED("stlport_shared", "stlport", false),
    GNUSTL_STATIC("gnustl_static", "gnustl", true),
    GNUSTL_SHARED("gnustl_shared", "gnustl", false),
    GABIPP_STATIC("gabi++_static", "gabi++", true),
    GABIPP_SHARED("gabi++_shared", "gabi++", false),
    CPP_STATIC("c++_static", "c++", true),
    CPP_SHARED("c++_shared", "c++", false);

    public static final Stl DEFAULT;
    private String id;
    private String name;
    private boolean istStatic;

    private Stl(String id, String name, boolean isStatic) {
        this.id = id;
        this.name = name;
        this.istStatic = isStatic;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.istStatic;
    }

    public static Stl getById(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return DEFAULT;
        }
        for (Stl stl : Stl.values()) {
            if (!stl.id.equals(id)) continue;
            return stl;
        }
        throw new InvalidUserDataException("Invalid STL: " + id);
    }

    public String toString() {
        return this.getId();
    }

    static {
        DEFAULT = SYSTEM;
    }
}

