/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00170\u0016H\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Ljava/io/File;", "fakeOutputDir", "getFakeOutputDir", "()Ljava/io/File;", "setFakeOutputDir", "(Ljava/io/File;)V", "featureTransitiveDeps", "Lorg/gradle/api/artifacts/ArtifactCollection;", "getFeatureTransitiveDepsFiles", "Lorg/gradle/api/file/FileCollection;", "taskAction", "", "updateLibraryMap", "", "file", "projectPath", "", "map", "", "", "ConfigAction", "gradle"})
public class CheckMultiApkLibrariesTask
extends AndroidVariantTask {
    private ArtifactCollection featureTransitiveDeps;
    @NotNull
    private File fakeOutputDir;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getFeatureTransitiveDepsFiles() {
        ArtifactCollection artifactCollection = this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"featureTransitiveDeps.artifactFiles");
        return fileCollection;
    }

    @OutputDirectory
    @NotNull
    public final File getFakeOutputDir() {
        File file = this.fakeOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fakeOutputDir");
        }
        return file;
    }

    private final void setFakeOutputDir(File file) {
        this.fakeOutputDir = file;
    }

    /*
     * Unable to fully structure code
     */
    @TaskAction
    public final void taskAction() {
        map = new LinkedHashMap<K, V>();
        found = false;
        v0 = this.featureTransitiveDeps;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
        }
        var4_3 = v0.iterator();
        while (var4_3.hasNext()) {
            v1 = artifact = (ResolvedArtifactResult)var4_3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"artifact");
            v2 = v1.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"artifact.id");
            if (!(v2.getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                v3 = new StringBuilder();
                v4 = artifact.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"artifact.id");
                v5 = v4.getComponentIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"artifact.id.componentIdentifier");
                throw (Throwable)new GradleException(v3.append(v5.getDisplayName()).append(" is not a Gradle project.").toString());
            }
            v6 = artifact.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"artifact.id");
            v7 = v6.getComponentIdentifier();
            if (v7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
            }
            projectPath = ((ProjectComponentIdentifier)v7).getProjectPath();
            v8 = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"artifact.file");
            if (!v8.isFile()) continue;
            if (found) ** GOTO lbl-1000
            v9 = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"artifact.file");
            v10 = projectPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"projectPath");
            if (this.updateLibraryMap(v9, v10, map)) lbl-1000:
            // 2 sources

            {
                v11 = true;
            } else {
                v11 = false;
            }
            found = v11;
        }
        if (found) {
            output = new StringBuilder();
            var6_6 = MapsKt.toSortedMap((Map)map);
            var5_5 = var6_6.entrySet().iterator();
            while (var5_5.hasNext()) {
                var8_8 = var4_3 = var5_5.next();
                library = (String)var8_8.getKey();
                var8_8 = var4_3;
                projectPaths = (List)var8_8.getValue();
                if (projectPaths.size() <= 1) continue;
                v12 = projectPaths;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"projectPaths");
                output.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)v12), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null)).append(" all package the same library [" + library + "].\n");
            }
            throw (Throwable)new GradleException(output.toString());
        }
    }

    private final boolean updateLibraryMap(File file, String projectPath, Map<String, List<String>> map) {
        boolean found = false;
        Iterator iterator = Files.readLines((File)file, (Charset)Charsets.UTF_8).iterator();
        while (iterator.hasNext()) {
            String library;
            String string = library = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"library");
            String libraryWithoutVariant = StringsKt.substringBeforeLast$default((String)string, (String)"::", null, (int)2, null);
            if (map.containsKey(libraryWithoutVariant)) {
                found = true;
                List<String> list = map.get(libraryWithoutVariant);
                if (list != null) {
                    list.add(projectPath);
                }
                continue;
            }
            Map<String, List<String>> map2 = map;
            List list = CollectionsKt.mutableListOf((Object[])new String[]{projectPath});
            map2.put(libraryWithoutVariant, list);
        }
        return found;
    }

    @NotNull
    public static final /* synthetic */ ArtifactCollection access$getFeatureTransitiveDeps$p(CheckMultiApkLibrariesTask $this) {
        ArtifactCollection artifactCollection = $this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
        }
        return artifactCollection;
    }

    @NotNull
    public static final /* synthetic */ File access$getFakeOutputDir$p(CheckMultiApkLibrariesTask $this) {
        File file = $this.fakeOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fakeOutputDir");
        }
        return file;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "getScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<CheckMultiApkLibrariesTask> {
        @NotNull
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("check", "Libraries");
        }

        @Override
        @NotNull
        public Class<CheckMultiApkLibrariesTask> getType() {
            return CheckMultiApkLibrariesTask.class;
        }

        @Override
        public void execute(@NotNull CheckMultiApkLibrariesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.scope.getFullVariantName());
            ArtifactCollection artifactCollection = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"scope.getArtifactCollect\u2026EPS\n                    )");
            task.featureTransitiveDeps = artifactCollection;
            GlobalScope globalScope = this.scope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
            File file = globalScope.getIntermediatesDir();
            String[] stringArray = new String[2];
            stringArray[0] = "check-libraries";
            GradleVariantConfiguration gradleVariantConfiguration = this.scope.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"scope.variantConfiguration");
            stringArray[1] = gradleVariantConfiguration.getDirName();
            File file2 = FileUtils.join((File)file, (String[])stringArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtils.join(\n        \u2026ame\n                    )");
            task.fakeOutputDir = file2;
        }

        @NotNull
        public final VariantScope getScope() {
            return this.scope;
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

