/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.testing.ConnectedDevice;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ddmlib.IDevice;
import com.android.instantapp.provision.ProvisionException;
import com.android.instantapp.provision.ProvisionListener;
import com.android.instantapp.provision.ProvisionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.logging.Logger;

public class InstantAppProvisioner {
    private final File instantAppSdk;
    private final DeviceProvider deviceProvider;
    private final Logger logger;
    private ProvisionRunner fakeProvisionRunner;

    InstantAppProvisioner(File instantAppSdk, DeviceProvider deviceProvider, Logger logger) {
        this.instantAppSdk = instantAppSdk;
        this.deviceProvider = deviceProvider;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void provisionDevices() throws ProvisionException, DeviceException {
        ProvisionListener listener = new ProvisionListener(){

            public void printMessage(String message) {
                InstantAppProvisioner.this.logger.info(message);
            }

            public void logMessage(String message, ProvisionException e) {
                if (e == null) {
                    InstantAppProvisioner.this.logger.debug(message);
                } else {
                    InstantAppProvisioner.this.logger.debug(message, (Throwable)e);
                    InstantAppProvisioner.this.logger.error(message, (Throwable)e);
                }
            }

            public void setProgress(double fraction) {
            }

            public boolean isCancelled() {
                return false;
            }
        };
        ProvisionRunner provisionRunner = this.fakeProvisionRunner == null ? new ProvisionRunner(this.instantAppSdk, listener) : this.fakeProvisionRunner;
        this.deviceProvider.init();
        try {
            List devices = this.deviceProvider.getDevices();
            ArrayList iDevices = Lists.newArrayList();
            for (DeviceConnector device : devices) {
                if (!(device instanceof ConnectedDevice)) continue;
                iDevices.add(((ConnectedDevice)device).getIDevice());
            }
            for (DeviceConnector device : iDevices) {
                provisionRunner.runProvision((IDevice)device);
            }
        }
        finally {
            this.deviceProvider.terminate();
        }
    }

    @VisibleForTesting
    void setFakeProvisionRunner(ProvisionRunner fakeProvisionRunner) {
        this.fakeProvisionRunner = fakeProvisionRunner;
    }
}

