/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.DeviceTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestResult;
import com.android.build.gradle.internal.test.report.TestResultModel;
import com.android.build.gradle.internal.test.report.VariantTestResults;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.tasks.testing.TestResult;

public abstract class CompositeTestResults
extends TestResultModel {
    private final CompositeTestResults parent;
    private int tests;
    private final Set<TestResult> failures = new TreeSet<TestResult>();
    private long duration;
    private final Map<String, DeviceTestResults> devices = new TreeMap<String, DeviceTestResults>();
    private final Map<String, VariantTestResults> variants = new TreeMap<String, VariantTestResults>();

    protected CompositeTestResults(CompositeTestResults parent) {
        this.parent = parent;
    }

    public String getFilename(ReportType reportType2) {
        return this.getName();
    }

    public abstract String getName();

    public int getTestCount() {
        return this.tests;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getFormattedDuration() {
        return this.getTestCount() == 0 ? "-" : super.getFormattedDuration();
    }

    public Set<TestResult> getFailures() {
        return this.failures;
    }

    Map<String, DeviceTestResults> getResultsPerDevices() {
        return this.devices;
    }

    Map<String, VariantTestResults> getResultsPerVariants() {
        return this.variants;
    }

    @Override
    public TestResult.ResultType getResultType() {
        return this.failures.isEmpty() ? TestResult.ResultType.SUCCESS : TestResult.ResultType.FAILURE;
    }

    public String getFormattedSuccessRate() {
        Number successRate = this.getSuccessRate();
        if (successRate == null) {
            return "-";
        }
        return successRate + "%";
    }

    public Number getSuccessRate() {
        if (this.getTestCount() == 0) {
            return null;
        }
        BigDecimal tests = BigDecimal.valueOf(this.getTestCount());
        BigDecimal successful = BigDecimal.valueOf(this.getTestCount() - this.getFailureCount());
        return successful.divide(tests, 2, 1).multiply(BigDecimal.valueOf(100L)).intValue();
    }

    protected void failed(TestResult failedTest, String deviceName, String projectName, String flavorName) {
        String key;
        VariantTestResults variantResults;
        DeviceTestResults deviceResults;
        this.failures.add(failedTest);
        if (this.parent != null) {
            this.parent.failed(failedTest, deviceName, projectName, flavorName);
        }
        if ((deviceResults = this.devices.get(deviceName)) != null) {
            deviceResults.failed(failedTest, deviceName, projectName, flavorName);
        }
        if ((variantResults = this.variants.get(key = CompositeTestResults.getVariantKey(projectName, flavorName))) != null) {
            variantResults.failed(failedTest, deviceName, projectName, flavorName);
        }
    }

    protected TestResult addTest(TestResult test) {
        ++this.tests;
        this.duration += test.getDuration();
        return test;
    }

    protected void addDevice(String deviceName, TestResult testResult) {
        DeviceTestResults deviceResults = this.devices.get(deviceName);
        if (deviceResults == null) {
            deviceResults = new DeviceTestResults(deviceName, null);
            this.devices.put(deviceName, deviceResults);
        }
        deviceResults.addTest(testResult);
    }

    protected void addVariant(String projectName, String flavorName, TestResult testResult) {
        String key = CompositeTestResults.getVariantKey(projectName, flavorName);
        VariantTestResults variantResults = this.variants.get(key);
        if (variantResults == null) {
            variantResults = new VariantTestResults(key, null);
            this.variants.put(key, variantResults);
        }
        variantResults.addTest(testResult);
    }

    private static String getVariantKey(String projectName, String flavorName) {
        if ("main".equalsIgnoreCase(flavorName)) {
            return projectName;
        }
        return projectName + ":" + flavorName;
    }
}

