/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;

public class InstantRunSliceSplitApkBuilder
extends InstantRunSplitApkBuilder {
    private final WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
    private final BuildableArtifact splitApkResources;

    public InstantRunSliceSplitApkBuilder(Logger logger, Project project, InstantRunBuildContext buildContext, AndroidBuilder androidBuilder, FileCollection aapt2FromMaven, Supplier<String> applicationIdSupplier, CoreSigningConfig signingConf, AaptGeneration aaptGeneration, AaptOptions aaptOptions, File outputDirectory, File supportDirectory, BuildableArtifact resources, BuildableArtifact resourcesWithMainManifest, BuildableArtifact apkList, BuildableArtifact splitApkResourceFiles, ApkInfo mainApk) {
        super(logger, project, buildContext, androidBuilder, aapt2FromMaven, applicationIdSupplier, signingConf, aaptGeneration, aaptOptions, outputDirectory, supportDirectory, resources, resourcesWithMainManifest, apkList, mainApk);
        this.splitApkResources = splitApkResourceFiles;
    }

    @Override
    public Collection<SecondaryFile> getSecondaryFiles() {
        ImmutableList.Builder list = ImmutableList.builder();
        list.addAll(super.getSecondaryFiles());
        list.add((Object)SecondaryFile.incremental((FileCollection)((FileCollection)this.splitApkResources.get())));
        return list.build();
    }

    public String getName() {
        return "instantRunSlicesApk";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        ArrayList<InstantRunSplitApkBuilder.DexFiles> splitsToBuild = new ArrayList<InstantRunSplitApkBuilder.DexFiles>();
        if (transformInvocation.isIncremental()) {
            for (TransformInput transformInput : transformInvocation.getInputs()) {
                for (JarInput jarInput : transformInput.getJarInputs()) {
                    this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
                }
                block6: for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                    Map sliceStatuses = directoryInput.getChangedFiles().entrySet().stream().collect(Collectors.groupingBy(fileStatus -> ((File)fileStatus.getKey()).getParentFile(), Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
                    for (Map.Entry slices : sliceStatuses.entrySet()) {
                        if (slices.getValue().equals(EnumSet.of(Status.REMOVED))) {
                            InstantRunSplitApkBuilder.DexFiles dexFile = new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)ImmutableSet.of(), slices.getKey().getName());
                            String outputFileName = dexFile.encodeName() + "_unaligned.apk";
                            FileUtils.deleteIfExists((File)new File(this.outputDirectory, outputFileName));
                            outputFileName = dexFile.encodeName() + ".apk";
                            FileUtils.deleteIfExists((File)new File(this.outputDirectory, outputFileName));
                            continue block6;
                        }
                        if (slices.getValue().equals(EnumSet.of(Status.NOTCHANGED))) continue;
                        File[] dexFiles = slices.getKey().listFiles();
                        if (dexFiles == null) continue block6;
                        try {
                            splitsToBuild.add(new InstantRunSplitApkBuilder.DexFiles(dexFiles, directoryInput.getName()));
                            continue block6;
                        }
                        catch (Exception e) {
                            throw new TransformException((Throwable)e);
                        }
                    }
                }
            }
        } else {
            FileUtils.cleanOutputDir((File)this.outputDirectory);
            for (TransformInput transformInput : transformInvocation.getInputs()) {
                for (JarInput jarInput : transformInput.getJarInputs()) {
                    this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
                }
                for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                    Object[] files = directoryInput.getFile().listFiles();
                    if (files == null) continue;
                    try {
                        splitsToBuild.add(new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)ImmutableSet.copyOf((Object[])files), directoryInput.getName()));
                    }
                    catch (Exception e) {
                        throw new TransformException((Throwable)e);
                    }
                }
            }
        }
        splitsToBuild.forEach(split -> {
            try {
                this.executor.execute(() -> {
                    String uniqueName = split.encodeName();
                    File alignedOutput = new File(this.outputDirectory, uniqueName + ".apk");
                    Files.createParentDirs((File)alignedOutput);
                    File splitApkResources = (File)Iterators.getOnlyElement(this.splitApkResources.getFiles().iterator());
                    File splitApkResource = new File(splitApkResources, uniqueName);
                    File resPackageFile = new File(splitApkResource, "resources_ap");
                    if (!resPackageFile.exists()) {
                        throw new FileNotFoundException(resPackageFile.getAbsolutePath());
                    }
                    this.generateSplitApk(uniqueName, resPackageFile, (InstantRunSplitApkBuilder.DexFiles)split, alignedOutput);
                    this.buildContext.addChangedFile(FileType.SPLIT, alignedOutput);
                    return alignedOutput;
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.executor.waitForTasksWithQuickFail(true);
    }

    void generateSplitApk(String uniqueName, File resPackageFile, InstantRunSplitApkBuilder.DexFiles split, File outputFile) throws TransformException, KeytoolException, IOException, PackagerException {
        File tempDir = new File(this.supportDirectory, "package_" + uniqueName);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new TransformException("Cannot create temporary folder " + tempDir.getAbsolutePath());
        }
        FileUtils.cleanOutputDir((File)tempDir);
        this.androidBuilder.packageCodeSplitApk(resPackageFile, split.getDexFiles(), (SigningConfig)this.signingConf, outputFile, tempDir, ApkCreatorFactories.fromProjectProperties(this.project, true));
    }
}

