/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.build.gradle.internal.transforms.MainDexListWriter;
import com.android.builder.dexing.RuntimeAnnotatedClassCollector;
import com.android.builder.dexing.RuntimeAnnotatedClassDetector;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.ProcessException;
import com.android.multidex.MainDexListBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.LoggingManager;
import org.jetbrains.annotations.NotNull;
import proguard.ParseException;

public class MainDexListTransform
extends BaseProguardAction
implements MainDexListWriter {
    private static final List<String> MAIN_DEX_LIST_FILTER = ImmutableList.of((Object)"**.class");
    private final BuildableArtifact manifestKeepListProguardFile;
    private final File userMainDexKeepProguard;
    private final File userMainDexKeepFile;
    private final VariantScope variantScope;
    private final boolean keepRuntimeAnnotatedClasses;
    private final File proguardComponentsJarFile;
    private final File configFileOut;
    private File mainDexListFile;

    public MainDexListTransform(VariantScope variantScope, DexOptions dexOptions) {
        super(variantScope);
        this.manifestKeepListProguardFile = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES);
        this.userMainDexKeepProguard = variantScope.getVariantConfiguration().getMultiDexKeepProguard();
        this.userMainDexKeepFile = variantScope.getVariantConfiguration().getMultiDexKeepFile();
        this.variantScope = variantScope;
        this.configFileOut = new File(variantScope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/multi-dex/" + variantScope.getVariantConfiguration().getDirName() + "/components.flags");
        this.keepRuntimeAnnotatedClasses = dexOptions.getKeepRuntimeAnnotatedClasses();
        this.proguardComponentsJarFile = variantScope.getProguardComponentsJarFile();
    }

    @Override
    public void setMainDexListOutputFile(@NotNull File mainDexListFile) {
        this.mainDexListFile = mainDexListFile;
    }

    public String getName() {
        return "multidexlist";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    @Override
    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.TESTED_CODE});
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)SecondaryFile.nonIncremental((Supplier)this.manifestKeepListProguardFile));
        if (this.userMainDexKeepFile != null) {
            builder.add((Object)SecondaryFile.nonIncremental((File)this.userMainDexKeepFile));
        }
        if (this.userMainDexKeepProguard != null) {
            builder.add((Object)SecondaryFile.nonIncremental((File)this.userMainDexKeepProguard));
        }
        return builder.build();
    }

    public Map<String, Object> getParameterInputs() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"keepRuntimeAnnotatedClasses", (Object)this.keepRuntimeAnnotatedClasses);
        params.put((Object)"implementationClass", (Object)"MainDexListTransform");
        TargetInfo targetInfo = this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo();
        if (targetInfo != null) {
            params.put((Object)"build_tools", (Object)targetInfo.getBuildTools().getRevision().toString());
        }
        return params.build();
    }

    public Collection<File> getSecondaryFileOutputs() {
        return Lists.newArrayList((Object[])new File[]{this.mainDexListFile, this.configFileOut});
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        LoggingManager loggingManager = invocation.getContext().getLogging();
        loggingManager.captureStandardOutput(LogLevel.INFO);
        loggingManager.captureStandardError(LogLevel.WARN);
        try {
            Map<ProguardInput, Set<File>> inputs = MainDexListTransform.getByInputType(invocation);
            this.shrinkWithProguard(inputs, this.proguardComponentsJarFile);
            ArrayList<File> allInputFiles = new ArrayList<File>(inputs.get((Object)ProguardInput.LIBRARY_JAR).size() + inputs.get((Object)ProguardInput.INPUT_JAR).size());
            allInputFiles.addAll((Collection)inputs.get((Object)ProguardInput.LIBRARY_JAR));
            allInputFiles.addAll((Collection)inputs.get((Object)ProguardInput.INPUT_JAR));
            ImmutableSet<String> classes = MainDexListTransform.computeList(allInputFiles, this.proguardComponentsJarFile, this.userMainDexKeepFile, this.keepRuntimeAnnotatedClasses);
            Files.write(this.mainDexListFile.toPath(), classes, new OpenOption[0]);
        }
        catch (ProcessException | ParseException e) {
            throw new TransformException(e);
        }
    }

    static List<String> getPlatformRules() {
        return ImmutableList.of((Object)"public class * extends android.app.Instrumentation {\n  <init>(); \n  void onCreate(...);\n  android.app.Application newApplication(...);\n  void callApplicationOnCreate(android.app.Application);\n  Z onException(java.lang.Object, java.lang.Throwable);\n}", (Object)"public class * extends android.app.Application {   <init>();\n  void attachBaseContext(android.content.Context);\n}", (Object)"public class * extends android.app.backup.BackupAgent { <init>(); }", (Object)"public class * implements java.lang.annotation.Annotation { *;}", (Object)"public class * extends android.test.InstrumentationTestCase { <init>(); }");
    }

    static Map<ProguardInput, Set<File>> getByInputType(TransformInvocation invocation) {
        HashMap grouped = Maps.newHashMap();
        ImmutableSet libraryScopes = Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROVIDED_ONLY, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.TESTED_CODE});
        for (TransformInput input : invocation.getReferencedInputs()) {
            for (QualifiedContent content2 : Iterables.concat((Iterable)input.getDirectoryInputs(), (Iterable)input.getJarInputs())) {
                ProguardInput type = Sets.difference((Set)content2.getScopes(), (Set)libraryScopes).isEmpty() ? ProguardInput.LIBRARY_JAR : ProguardInput.INPUT_JAR;
                Set current = grouped.getOrDefault((Object)type, new HashSet());
                current.add(content2.getFile());
                grouped.put(type, current);
            }
        }
        grouped.putIfAbsent(ProguardInput.INPUT_JAR, new HashSet());
        grouped.putIfAbsent(ProguardInput.LIBRARY_JAR, new HashSet());
        Sets.SetView librariesNotInput = Sets.difference((Set)((Set)grouped.get((Object)ProguardInput.LIBRARY_JAR)), (Set)((Set)grouped.get((Object)ProguardInput.INPUT_JAR)));
        grouped.put(ProguardInput.LIBRARY_JAR, librariesNotInput);
        return grouped;
    }

    private void shrinkWithProguard(Map<ProguardInput, Set<File>> inputs, File outJar) throws IOException, ParseException {
        this.configuration.obfuscate = false;
        this.configuration.optimize = false;
        this.configuration.preverify = false;
        this.dontwarn();
        this.dontnote();
        this.forceprocessing();
        this.applyConfigurationFile(BuildableArtifactUtil.singleFile(this.manifestKeepListProguardFile));
        if (this.userMainDexKeepProguard != null) {
            this.applyConfigurationFile(this.userMainDexKeepProguard);
        }
        MainDexListTransform.getPlatformRules().forEach(this::keep);
        this.libraryJar(this.findShrinkedAndroidJar());
        inputs.get((Object)ProguardInput.LIBRARY_JAR).forEach(this::libraryJar);
        inputs.get((Object)ProguardInput.INPUT_JAR).forEach(jar -> this.inJar((File)jar, MAIN_DEX_LIST_FILTER));
        this.outJar(outJar);
        this.printconfiguration(this.configFileOut);
        this.runProguard();
    }

    private File findShrinkedAndroidJar() {
        Preconditions.checkNotNull((Object)this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo());
        File shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "lib" + File.separatorChar + "shrinkedAndroid.jar");
        if (!shrinkedAndroid.isFile()) {
            shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "multidex" + File.separatorChar + "shrinkedAndroid.jar");
        }
        return shrinkedAndroid;
    }

    @VisibleForTesting
    static ImmutableSet<String> computeList(Collection<File> allClasses, File jarOfRoots, File userMainDexKeepFile, boolean keepRuntimeAnnotatedClasses) throws ProcessException, IOException, InterruptedException {
        ImmutableSet.Builder mainDexClasses = ImmutableSet.builder();
        mainDexClasses.addAll(MainDexListTransform.callDx(allClasses, jarOfRoots));
        if (userMainDexKeepFile != null) {
            mainDexClasses.addAll(Files.readAllLines(userMainDexKeepFile.toPath(), Charsets.UTF_8));
        }
        if (keepRuntimeAnnotatedClasses) {
            RuntimeAnnotatedClassCollector collector2 = new RuntimeAnnotatedClassCollector(RuntimeAnnotatedClassDetector::hasRuntimeAnnotations);
            mainDexClasses.addAll((Iterable)collector2.collectClasses((Collection)allClasses.stream().map(File::toPath).collect(Collectors.toList())));
        }
        return mainDexClasses.build();
    }

    private static ImmutableSet<String> callDx(Collection<File> allClasses, File jarOfRoots) throws IOException {
        String pathList = allClasses.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        MainDexListBuilder builder = new MainDexListBuilder(false, jarOfRoots.getAbsolutePath(), pathList);
        Set mainDexList = builder.getMainDexList().stream().map(input -> input.startsWith("/") ? input.substring(1) : input).collect(Collectors.toSet());
        return ImmutableSet.copyOf(mainDexList);
    }

    static enum ProguardInput {
        INPUT_JAR,
        LIBRARY_JAR;

    }
}

