/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker.parser;

import com.android.build.gradle.shrinker.parser.Matcher;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumSet;

public class ModifierSpecification
implements Matcher<MemberModifier> {
    private static final ImmutableMap<ModifierTarget, EnumSet<Modifier>> MODIFIERS_BY_TYPE = ImmutableMap.of((Object)((Object)ModifierTarget.FIELD), EnumSet.of(Modifier.STATIC, new Modifier[]{Modifier.FINAL, Modifier.TRANSIENT, Modifier.VOLATILE, Modifier.ENUM, Modifier.SYNTHETIC}), (Object)((Object)ModifierTarget.METHOD), EnumSet.of(Modifier.STATIC, new Modifier[]{Modifier.NATIVE, Modifier.ABSTRACT, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.BRIDGE, Modifier.SYNTHETIC, Modifier.STRICTFP, Modifier.VARARGS}), (Object)((Object)ModifierTarget.CLASS), EnumSet.of(Modifier.STATIC, new Modifier[]{Modifier.FINAL, Modifier.ENUM, Modifier.SYNTHETIC, Modifier.ABSTRACT, Modifier.INTERFACE, Modifier.ANNOTATION, Modifier.SUPER, Modifier.STRICTFP}));
    private final EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private final EnumSet<Modifier> modifiersWithNegator = EnumSet.noneOf(Modifier.class);
    private final EnumSet<AccessFlag> accessFlags = EnumSet.noneOf(AccessFlag.class);
    private final EnumSet<AccessFlag> accessFlagsWithNegator = EnumSet.noneOf(AccessFlag.class);

    public void addModifier(Modifier modifier, boolean hasNegator) {
        if (hasNegator) {
            this.modifiersWithNegator.add(modifier);
        } else {
            this.modifiers.add(modifier);
        }
    }

    public void addAccessFlag(AccessFlag accessFlag, boolean hasNegator) {
        if (hasNegator) {
            this.accessFlagsWithNegator.add(accessFlag);
        } else {
            this.accessFlags.add(accessFlag);
        }
    }

    private static AccessFlag getAccessFlag(int toConvert) {
        for (AccessFlag accFlags : AccessFlag.values()) {
            if ((accFlags.value & toConvert) == 0) continue;
            return accFlags;
        }
        return null;
    }

    private static EnumSet<Modifier> getModifiers(int bitmask, EnumSet<Modifier> modifiers) {
        EnumSet<Modifier> result = EnumSet.noneOf(Modifier.class);
        for (Modifier modifier : modifiers) {
            if ((modifier.value & bitmask) == 0) continue;
            result.add(modifier);
        }
        return result;
    }

    @Override
    public boolean matches(MemberModifier candidate) {
        AccessFlag candidateAccFlag = ModifierSpecification.getAccessFlag(candidate.modifier);
        if (!this.accessFlags.isEmpty() && !this.accessFlags.contains((Object)candidateAccFlag)) {
            return false;
        }
        if (this.accessFlagsWithNegator.contains((Object)candidateAccFlag)) {
            return false;
        }
        EnumSet<Modifier> candidateModifiers = ModifierSpecification.getModifiers(candidate.modifier, (EnumSet)MODIFIERS_BY_TYPE.get((Object)candidate.modifierTarget));
        return candidateModifiers.containsAll(this.modifiers) && Collections.disjoint(candidateModifiers, this.modifiersWithNegator);
    }

    public static enum Modifier {
        STATIC(8),
        FINAL(16),
        SUPER(32),
        SYNCHRONIZED(32),
        VOLATILE(64),
        BRIDGE(64),
        TRANSIENT(128),
        VARARGS(128),
        NATIVE(256),
        INTERFACE(512),
        ABSTRACT(1024),
        STRICTFP(2048),
        SYNTHETIC(4096),
        ANNOTATION(8192),
        ENUM(16384);

        private final int value;

        private Modifier(int value) {
            this.value = value;
        }
    }

    public static enum AccessFlag {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4);

        private final int value;

        private AccessFlag(int value) {
            this.value = value;
        }
    }

    public static class MemberModifier {
        public final int modifier;
        public final ModifierTarget modifierTarget;

        public MemberModifier(ModifierTarget modifierTarget, int modifier) {
            this.modifier = modifier;
            this.modifierTarget = modifierTarget;
        }
    }

    public static enum ModifierTarget {
        FIELD,
        METHOD,
        CLASS;

    }
}

