/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.dexing.DexSplitterTool;
import com.android.utils.FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u000bH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/transforms/DexSplitterTransform;", "Lcom/android/build/api/transform/Transform;", "outputDir", "Ljava/io/File;", "featureJars", "Lorg/gradle/api/file/FileCollection;", "baseJars", "Lcom/android/build/api/artifact/BuildableArtifact;", "mappingFileSrc", "(Ljava/io/File;Lorg/gradle/api/file/FileCollection;Lcom/android/build/api/artifact/BuildableArtifact;Lcom/android/build/api/artifact/BuildableArtifact;)V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getOutputTypes", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getSecondaryDirectoryOutputs", "", "getSecondaryFiles", "Lcom/android/build/api/transform/SecondaryFile;", "isIncremental", "", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class DexSplitterTransform
extends Transform {
    private final File outputDir;
    private final FileCollection featureJars;
    private final BuildableArtifact baseJars;
    private final BuildableArtifact mappingFileSrc;

    @NotNull
    public String getName() {
        return "dexSplitter";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_DEX;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CONTENT_DEX");
        return set;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getOutputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_DEX;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CONTENT_DEX");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set<QualifiedContent.ScopeType> set = TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES");
        return set;
    }

    public boolean isIncremental() {
        return false;
    }

    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        Collection secondaryFiles;
        block0: {
            BuildableArtifact buildableArtifact;
            secondaryFiles = new ArrayList();
            SecondaryFile secondaryFile = SecondaryFile.nonIncremental((FileCollection)this.featureJars);
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile, (String)"SecondaryFile.nonIncremental(featureJars)");
            secondaryFiles.add(secondaryFile);
            SecondaryFile secondaryFile2 = SecondaryFile.nonIncremental((Supplier)((Supplier)this.baseJars));
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile2, (String)"SecondaryFile.nonIncremental(baseJars)");
            secondaryFiles.add(secondaryFile2);
            BuildableArtifact buildableArtifact2 = this.mappingFileSrc;
            if (buildableArtifact2 == null) break block0;
            BuildableArtifact it = buildableArtifact = buildableArtifact2;
            SecondaryFile secondaryFile3 = SecondaryFile.nonIncremental((Supplier)((Supplier)it));
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile3, (String)"SecondaryFile.nonIncremental(it)");
            secondaryFiles.add(secondaryFile3);
        }
        return secondaryFiles;
    }

    @NotNull
    public Collection<File> getSecondaryDirectoryOutputs() {
        return CollectionsKt.mutableListOf((Object[])new File[]{this.outputDir});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        try {
            Object object;
            File transformOutputDir;
            Iterator<File> iterator;
            block9: {
                Object it;
                Object element$iv3;
                Object it2;
                Object object2 = this.mappingFileSrc;
                File mappingFile = object2 != null && (object2 = BuildableArtifactUtil.singleFile((BuildableArtifact)object2)) != null && ((File)object2).exists() && !BuildableArtifactUtil.singleFile(this.mappingFileSrc).isDirectory() ? BuildableArtifactUtil.singleFile(this.mappingFileSrc) : null;
                TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
                if (transformOutputProvider == null) {
                    String string = "No output provider set";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                TransformOutputProvider outputProvider = transformOutputProvider;
                outputProvider.deleteAll();
                FileUtils.deleteRecursivelyIfExists((File)this.outputDir);
                Path path = this.outputDir.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputDir.toPath()");
                File file = mappingFile;
                DexSplitterTool.Builder builder = new DexSplitterTool.Builder(path, file != null ? file.toPath() : null);
                for (File dirInput : TransformInputUtil.getDirectories(transformInvocation.getInputs())) {
                    Iterator $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Object object3 = dirInput.listFiles();
                    if (object3 == null || (object3 = ArraysKt.toList((Object[])object3)) == null) continue;
                    Iterable iterable = $receiver$iv = (Iterable)object3;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    Iterator iterator2 = $receiver$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object item$iv$iv = iterator2.next();
                        File file2 = (File)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Path path2 = ((File)it2).toPath();
                        collection.add(path2);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        Path it3;
                        Object element$iv2 = $receiver$iv$iv.next();
                        Path path3 = it3 = (Path)element$iv2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"it");
                        builder.addInputArchive(path3);
                    }
                }
                Set set = this.featureJars.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureJars.files");
                Iterable $receiver$iv = set;
                for (Object element$iv3 : $receiver$iv) {
                    File file3 = element$iv3;
                    Path path4 = file3.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"file.toPath()");
                    File file4 = file3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file");
                    builder.addFeatureJar(path4, FilesKt.getNameWithoutExtension((File)file4));
                    Files.createDirectories(new File(this.outputDir, FilesKt.getNameWithoutExtension((File)file3)).toPath(), new FileAttribute[0]);
                }
                $receiver$iv = this.baseJars.getFiles();
                iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    it = element$iv3 = iterator.next();
                    Path path5 = ((File)it).toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"it.toPath()");
                    builder.addBaseJar(path5);
                }
                builder.build().run();
                transformOutputDir = outputProvider.getContentLocation("splitDexFiles", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                Files.createDirectories(transformOutputDir.toPath(), new FileAttribute[0]);
                File[] fileArray = this.outputDir.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"outputDir.listFiles()");
                iterator = fileArray;
                it = element$iv3 = iterator;
                int n = ((Object)it).length;
                for (int i = 0; i < n; ++i) {
                    Object object4;
                    Object object5 = it2 = (object4 = it[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"it");
                    if (!Intrinsics.areEqual((Object)((File)object5).getName(), (Object)"base")) continue;
                    object = object4;
                    break block9;
                }
                object = null;
            }
            if (object == null) return;
            Iterator<File> it = iterator = object;
            FileUtils.copyDirectory(it, (File)transformOutputDir);
            FileUtils.deleteRecursivelyIfExists(it);
            return;
        }
        catch (Exception e) {
            throw (Throwable)new TransformException((Throwable)e);
        }
    }

    public DexSplitterTransform(@NotNull File outputDir, @NotNull FileCollection featureJars, @NotNull BuildableArtifact baseJars, @Nullable BuildableArtifact mappingFileSrc) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)featureJars, (String)"featureJars");
        Intrinsics.checkParameterIsNotNull((Object)baseJars, (String)"baseJars");
        this.outputDir = outputDir;
        this.featureJars = featureJars;
        this.baseJars = baseJars;
        this.mappingFileSrc = mappingFileSrc;
    }
}

