/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class IncrementalFileMergerTransformUtils {
    private IncrementalFileMergerTransformUtils() {
    }

    public static IncrementalFileMergerInput toIncrementalInput(JarInput jarInput, FileCacheByPath zipCache, List<Runnable> cacheUpdate, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        File jarFile = jarInput.getFile();
        if (jarFile.isFile()) {
            cacheUpdate.add(IOExceptionRunnable.asRunnable(() -> zipCache.add(jarFile)));
        } else {
            cacheUpdate.add(IOExceptionRunnable.asRunnable(() -> zipCache.remove(jarFile)));
        }
        LazyIncrementalFileMergerInput input = new LazyIncrementalFileMergerInput(jarFile.getAbsolutePath(), new CachedSupplier(() -> IncrementalFileMergerTransformUtils.computeUpdates(jarInput, zipCache)), new CachedSupplier(() -> IncrementalFileMergerTransformUtils.computeFiles(jarInput)));
        if (contentMap != null) {
            contentMap.put((IncrementalFileMergerInput)input, (QualifiedContent)jarInput);
        }
        return input;
    }

    public static IncrementalFileMergerInput toIncrementalInput(DirectoryInput directoryInput, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        LazyIncrementalFileMergerInput input = new LazyIncrementalFileMergerInput(directoryInput.getFile().getAbsolutePath(), new CachedSupplier(() -> IncrementalFileMergerTransformUtils.computeUpdates(directoryInput)), new CachedSupplier(() -> IncrementalFileMergerTransformUtils.computeFiles(directoryInput)));
        if (contentMap != null) {
            contentMap.put((IncrementalFileMergerInput)input, (QualifiedContent)directoryInput);
        }
        return input;
    }

    public static IncrementalFileMergerInput toNonIncrementalInput(JarInput jarInput, FileCacheByPath zipCache, List<Runnable> cacheUpdate, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        File jarFile = jarInput.getFile();
        if (!jarFile.isFile()) {
            return null;
        }
        cacheUpdate.add(IOExceptionRunnable.asRunnable(() -> zipCache.add(jarFile)));
        LazyIncrementalFileMergerInput input = LazyIncrementalFileMergerInputs.fromNew((String)jarFile.getAbsolutePath(), (Set)ImmutableSet.of((Object)jarFile));
        if (contentMap != null) {
            contentMap.put((IncrementalFileMergerInput)input, (QualifiedContent)jarInput);
        }
        return input;
    }

    public static IncrementalFileMergerInput toNonIncrementalInput(DirectoryInput directoryInput, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        File dirFile = directoryInput.getFile();
        if (!dirFile.isDirectory()) {
            return null;
        }
        LazyIncrementalFileMergerInput input = LazyIncrementalFileMergerInputs.fromNew((String)dirFile.getAbsolutePath(), (Set)ImmutableSet.of((Object)dirFile));
        if (contentMap != null) {
            contentMap.put((IncrementalFileMergerInput)input, (QualifiedContent)directoryInput);
        }
        return input;
    }

    private static ImmutableMap<RelativeFile, FileStatus> computeUpdates(JarInput jarInput, FileCacheByPath zipCache) {
        try {
            switch (jarInput.getStatus()) {
                case ADDED: {
                    return IncrementalRelativeFileSets.fromZip((File)jarInput.getFile(), (FileStatus)FileStatus.NEW);
                }
                case REMOVED: {
                    File cached = zipCache.get(jarInput.getFile());
                    if (cached == null) {
                        throw new RuntimeException("File '" + jarInput.getFile() + "' was deleted, but previous version not found in cache");
                    }
                    return IncrementalRelativeFileSets.fromZip((File)cached, (FileStatus)FileStatus.REMOVED);
                }
                case CHANGED: {
                    return IncrementalRelativeFileSets.fromZip((File)jarInput.getFile(), (FileCacheByPath)zipCache, new HashSet());
                }
                case NOTCHANGED: {
                    return ImmutableMap.of();
                }
            }
            throw new AssertionError();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ImmutableSet<RelativeFile> computeFiles(JarInput jarInput) {
        File jar = jarInput.getFile();
        assert (jar.isFile());
        try {
            return RelativeFiles.fromZip((File)jar);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ImmutableMap<RelativeFile, FileStatus> computeUpdates(DirectoryInput directoryInput) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map changedFiles = directoryInput.getChangedFiles();
        for (Map.Entry changedFile : changedFiles.entrySet()) {
            RelativeFile rf = new RelativeFile(directoryInput.getFile(), (File)changedFile.getKey());
            FileStatus status = IncrementalFileMergerTransformUtils.mapStatus((Status)changedFile.getValue());
            if (status == null || new File(rf.getBase(), rf.getRelativePath()).isDirectory()) continue;
            builder.put((Object)rf, (Object)status);
        }
        return builder.build();
    }

    private static ImmutableSet<RelativeFile> computeFiles(DirectoryInput directoryInput) {
        File dir = directoryInput.getFile();
        assert (dir.isDirectory());
        return RelativeFiles.fromDirectory((File)dir);
    }

    public static ImmutableList<IncrementalFileMergerInput> toIncrementalInput(TransformInput transformInput, FileCacheByPath zipCache, List<Runnable> cacheUpdates, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JarInput jarInput : transformInput.getJarInputs()) {
            builder.add((Object)IncrementalFileMergerTransformUtils.toIncrementalInput(jarInput, zipCache, cacheUpdates, contentMap));
        }
        for (DirectoryInput dirInput : transformInput.getDirectoryInputs()) {
            builder.add((Object)IncrementalFileMergerTransformUtils.toIncrementalInput(dirInput, contentMap));
        }
        return builder.build();
    }

    public static ImmutableList<IncrementalFileMergerInput> toNonIncrementalInput(TransformInput transformInput, FileCacheByPath zipCache, List<Runnable> cacheUpdates, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        IncrementalFileMergerInput mergeInput;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JarInput jarInput : transformInput.getJarInputs()) {
            mergeInput = IncrementalFileMergerTransformUtils.toNonIncrementalInput(jarInput, zipCache, cacheUpdates, contentMap);
            if (mergeInput == null) continue;
            builder.add((Object)mergeInput);
        }
        for (DirectoryInput dirInput : transformInput.getDirectoryInputs()) {
            mergeInput = IncrementalFileMergerTransformUtils.toNonIncrementalInput(dirInput, contentMap);
            if (mergeInput == null) continue;
            builder.add((Object)mergeInput);
        }
        return builder.build();
    }

    public static ImmutableList<IncrementalFileMergerInput> toInput(TransformInvocation transformInvocation, FileCacheByPath zipCache, List<Runnable> cacheUpdates, boolean full, Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        if (!full) {
            Preconditions.checkArgument((boolean)transformInvocation.isIncremental());
        }
        if (full) {
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> ((FileCacheByPath)zipCache).clear()));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TransformInput input : transformInvocation.getInputs()) {
            if (full) {
                builder.addAll(IncrementalFileMergerTransformUtils.toNonIncrementalInput(input, zipCache, cacheUpdates, contentMap));
                continue;
            }
            builder.addAll(IncrementalFileMergerTransformUtils.toIncrementalInput(input, zipCache, cacheUpdates, contentMap));
        }
        return builder.build();
    }

    private static FileStatus mapStatus(Status status) {
        switch (status) {
            case ADDED: {
                return FileStatus.NEW;
            }
            case CHANGED: {
                return FileStatus.CHANGED;
            }
            case NOTCHANGED: {
                return null;
            }
            case REMOVED: {
                return FileStatus.REMOVED;
            }
        }
        throw new AssertionError();
    }
}

