/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0002Jj\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001a\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002JR\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u001e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u000eJl\u0010!\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u00072\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u00122\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u00122\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012J \u0010$\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "", "ndkRoot", "Ljava/io/File;", "(Ljava/io/File;)V", "platformNameAliases", "", "", "", "sensibleDefaultPlatformApiVersionForErrorCase", "veryHighPlatformApiVersion", "clamp", "minSdkVersion", "displayVersion", "Lcom/android/sdklib/AndroidVersion;", "min", "max", "error", "Lkotlin/Function1;", "", "computeMinSdkVersion", "abiName", "androidVersionOrNull", "info", "warn", "displayVersionString", "findPlatformConfiguratorLegacy", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "platformDir", "findSuitablePlatformVersion", "variantName", "androidVersion", "findSuitablePlatformVersionLogged", "ndkMetaPlatforms", "Lcom/android/build/gradle/internal/cxx/configure/NdkMetaPlatforms;", "getLinkerSysrootPath", "platformVersion", "gradle"})
public final class PlatformConfigurator {
    private final int sensibleDefaultPlatformApiVersionForErrorCase = 22;
    private final int veryHighPlatformApiVersion = Integer.MAX_VALUE;
    private final Map<String, Integer> platformNameAliases;
    private final File ndkRoot;

    public final int findSuitablePlatformVersionLogged(@NotNull String abiName, @Nullable AndroidVersion androidVersionOrNull, @Nullable NdkMetaPlatforms ndkMetaPlatforms, @NotNull String variantName, @NotNull Function1<? super String, Unit> error2, @NotNull Function1<? super String, Unit> warn, @NotNull Function1<? super String, Unit> info) {
        Intrinsics.checkParameterIsNotNull((Object)abiName, (String)"abiName");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        Intrinsics.checkParameterIsNotNull(warn, (String)"warn");
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        Abi abi = Abi.getByName(abiName);
        if (abi == null) {
            PlatformConfigurator platformConfigurator;
            PlatformConfigurator $receiver = platformConfigurator = this;
            error2.invoke((Object)("Specified abi='" + abiName + "' is not recognized."));
            return $receiver.sensibleDefaultPlatformApiVersionForErrorCase;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)abi), (String)"Abi.getByName(abiName) ?\u2026ionForErrorCase\n        }");
        Abi abi2 = abi;
        if (ndkMetaPlatforms == null) {
            File platformDir;
            File file = platformDir = FileUtils.join((File)this.ndkRoot, (String[])new String[]{"platforms"});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"platformDir");
            if (!file.isDirectory()) {
                error2.invoke((Object)("NDK folder '" + this.ndkRoot + "' specified does not contain 'platforms'."));
                return this.sensibleDefaultPlatformApiVersionForErrorCase;
            }
            int minSdkVersion = this.computeMinSdkVersion(abiName, androidVersionOrNull, this.platformNameAliases, error2, info, warn);
            return this.findPlatformConfiguratorLegacy(abi2, minSdkVersion, androidVersionOrNull, platformDir, error2, info);
        }
        int minSdkVersion = this.computeMinSdkVersion(abiName, androidVersionOrNull, ndkMetaPlatforms.getAliases(), error2, info, warn);
        return this.clamp(minSdkVersion, androidVersionOrNull, ndkMetaPlatforms.getMin(), ndkMetaPlatforms.getMax(), error2);
    }

    public static /* synthetic */ int findSuitablePlatformVersionLogged$default(PlatformConfigurator platformConfigurator, String string, AndroidVersion androidVersion, NdkMetaPlatforms ndkMetaPlatforms, String string2, Function1 function1, Function1 function12, Function1 function13, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = (Function1)new Function1<String, Unit>(string2, string){
                final /* synthetic */ String $variantName;
                final /* synthetic */ String $abiName;

                public final void invoke(@NotNull String message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Logging.getLogger((String)"findSuitablePlatformVersionLogged").error(message + " [" + this.$variantName + '-' + this.$abiName + ']');
                }
                {
                    this.$variantName = string;
                    this.$abiName = string2;
                    super(1);
                }
            };
        }
        if ((n & 0x20) != 0) {
            function12 = (Function1)new Function1<String, Unit>(string2, string){
                final /* synthetic */ String $variantName;
                final /* synthetic */ String $abiName;

                public final void invoke(@NotNull String message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Logging.getLogger((String)"findSuitablePlatformVersionLogged").warn(message + " [" + this.$variantName + '-' + this.$abiName + ']');
                }
                {
                    this.$variantName = string;
                    this.$abiName = string2;
                    super(1);
                }
            };
        }
        if ((n & 0x40) != 0) {
            function13 = (Function1)new Function1<String, Unit>(string2, string){
                final /* synthetic */ String $variantName;
                final /* synthetic */ String $abiName;

                public final void invoke(@NotNull String message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Logging.getLogger((String)"findSuitablePlatformVersionLogged").info(message + " [" + this.$variantName + '-' + this.$abiName + ']');
                }
                {
                    this.$variantName = string;
                    this.$abiName = string2;
                    super(1);
                }
            };
        }
        return platformConfigurator.findSuitablePlatformVersionLogged(string, androidVersion, ndkMetaPlatforms, string2, (Function1<? super String, Unit>)function1, (Function1<? super String, Unit>)function12, (Function1<? super String, Unit>)function13);
    }

    private final int computeMinSdkVersion(String abiName, AndroidVersion androidVersionOrNull, Map<String, Integer> platformNameAliases, Function1<? super String, Unit> error2, Function1<? super String, Unit> info, Function1<? super String, Unit> warn) {
        Integer n;
        boolean minSdkVersionIsDefault;
        Integer n2;
        CharSequence charSequence;
        String codeNameOrNull;
        AndroidVersion androidVersion = androidVersionOrNull;
        Integer minSdkVersionOrNull = androidVersion != null ? Integer.valueOf(androidVersion.getApiLevel()) : null;
        AndroidVersion androidVersion2 = androidVersionOrNull;
        String string = codeNameOrNull = androidVersion2 != null ? androidVersion2.getCodename() : null;
        if (codeNameOrNull == null || (charSequence = (CharSequence)codeNameOrNull).length() == 0) {
            n2 = null;
        } else {
            int n3;
            Integer lookup = platformNameAliases.get(codeNameOrNull);
            if (lookup != null) {
                info.invoke((Object)("Version minSdkVersion='" + codeNameOrNull + "' is mapped to '" + lookup + "'."));
                n3 = lookup;
            } else {
                error2.invoke((Object)("API codeName '" + codeNameOrNull + "' is not recognized."));
                n3 = this.veryHighPlatformApiVersion;
            }
            n2 = n3;
        }
        Integer minSdkVersionFromCodeName = n2;
        Integer n4 = minSdkVersionOrNull;
        AndroidVersion androidVersion3 = AndroidVersion.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion3, (String)"AndroidVersion.DEFAULT");
        int n5 = androidVersion3.getApiLevel();
        boolean bl = minSdkVersionIsDefault = n4 != null && n4 == n5;
        if (minSdkVersionIsDefault && minSdkVersionFromCodeName == null) {
            info.invoke((Object)("Neither codeName nor minSdkVersion specified. Using minimum platform " + "version for '" + abiName + "'."));
            n = 0;
        } else if (!minSdkVersionIsDefault && minSdkVersionFromCodeName != null) {
            Integer n6 = minSdkVersionOrNull;
            if (Intrinsics.areEqual((Object)n6, minSdkVersionFromCodeName)) {
                warn.invoke((Object)"Both codeName and minSdkVersion specified. They agree but only one should be specified.");
                n = minSdkVersionOrNull;
            } else {
                error2.invoke((Object)("Disagreement between codeName='" + codeNameOrNull + "' " + "and minSdkVersion='" + minSdkVersionOrNull + "'. Only one " + "should be specified."));
                n = minSdkVersionOrNull;
            }
        } else if (minSdkVersionIsDefault) {
            n = minSdkVersionFromCodeName;
        } else {
            Integer lookup = platformNameAliases.get(String.valueOf(minSdkVersionOrNull));
            if (lookup != null) {
                StringBuilder stringBuilder = new StringBuilder().append("Version minSdkVersion='");
                Integer n7 = minSdkVersionOrNull;
                if (n7 == null) {
                    Intrinsics.throwNpe();
                }
                info.invoke((Object)stringBuilder.append(this.displayVersionString(n7, androidVersionOrNull)).append("' is mapped to '").append(lookup).append("'.").toString());
                return lookup;
            }
            n = minSdkVersionOrNull;
        }
        return n != null ? n : 22;
    }

    private final int findPlatformConfiguratorLegacy(Abi abi, int minSdkVersion, AndroidVersion displayVersion, File platformDir, Function1<? super String, Unit> error2, Function1<? super String, Unit> info) {
        int max;
        int clamped;
        File it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        File[] platformSubDirs2;
        File[] $receiver$iv2;
        String linkerSysrootPath = this.getLinkerSysrootPath(this.ndkRoot, abi, "android-" + minSdkVersion);
        if (new File(linkerSysrootPath).isDirectory()) {
            return minSdkVersion;
        }
        File[] fileArray = $receiver$iv2 = platformDir.listFiles(findPlatformConfiguratorLegacy.platformSubDirs.1.INSTANCE);
        if ($receiver$iv2 == null) {
            fileArray = new File[]{};
        }
        File[] $i$f$emptyArray = platformSubDirs2 = fileArray;
        void $i$f$orEmpty = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = element$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            if (!StringsKt.startsWith$default((String)string, (String)"android-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it2 = (File)element$iv$iv;
            File file = FileUtils.join((File)it2, (String[])new String[]{"arch-" + abi.getArchitecture()});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(it, \"arch-\" + abi.architecture)");
            if (!file.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer n;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            File file = it = (File)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)file.getName(), (String)"it.name");
            int n2 = "android-".length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            Integer version = StringsKt.toIntOrNull((String)string3);
            if (version == null) {
                info.invoke((Object)("Found non-numeric platform folder '" + it.getName() + "'. Ignoring."));
            }
            if (version == null) continue;
            Integer it$iv$iv = n;
            destination$iv$iv.add(it$iv$iv);
        }
        List versions = (List)destination$iv$iv;
        if (versions.isEmpty()) {
            error2.invoke((Object)("Abi '" + (Object)((Object)abi) + "' is not recognized in '" + this.ndkRoot + "'."));
            return this.sensibleDefaultPlatformApiVersionForErrorCase;
        }
        Comparable comparable = CollectionsKt.min((Iterable)versions);
        if (comparable == null) {
            Intrinsics.throwNpe();
        }
        int min = ((Number)((Object)comparable)).intValue();
        Comparable comparable2 = CollectionsKt.max((Iterable)versions);
        if (comparable2 == null) {
            Intrinsics.throwNpe();
        }
        if (!versions.contains(clamped = this.clamp(minSdkVersion, displayVersion, min, max = ((Number)((Object)comparable2)).intValue(), error2))) {
            error2.invoke((Object)("Expected platform folder platforms/android-" + clamped + ", " + "using platform API " + min + " instead."));
            return min;
        }
        return clamped;
    }

    private final int clamp(int minSdkVersion, AndroidVersion displayVersion, int min, int max, Function1<? super String, Unit> error2) {
        int n;
        if (minSdkVersion < min) {
            n = min;
        } else if (minSdkVersion > max) {
            if (minSdkVersion < this.veryHighPlatformApiVersion) {
                error2.invoke((Object)("Platform version '" + this.displayVersionString(minSdkVersion, displayVersion) + "' is beyond '" + max + "', the maximum API level supported by this NDK."));
            }
            n = max;
        } else {
            n = minSdkVersion;
        }
        return n;
    }

    private final String displayVersionString(int minSdkVersion, AndroidVersion displayVersion) {
        String string;
        if (displayVersion == null) {
            string = String.valueOf(minSdkVersion);
        } else {
            int n = displayVersion.getApiLevel();
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"AndroidVersion.DEFAULT");
            String string2 = n == androidVersion.getApiLevel() ? displayVersion.getApiString() : String.valueOf(displayVersion.getApiLevel());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (displayVersion.apiLe\u2026.toString()\n            }");
        }
        return string;
    }

    public final int findSuitablePlatformVersion(@NotNull String abiName, @NotNull String variantName, @Nullable AndroidVersion androidVersion) {
        Intrinsics.checkParameterIsNotNull((Object)abiName, (String)"abiName");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        File ndkMetaPlatformsFile = NdkMetaPlatforms.Companion.jsonFile(this.ndkRoot);
        NdkMetaPlatforms ndkMetaPlatforms = ndkMetaPlatformsFile.isFile() ? NdkMetaPlatforms.Companion.fromReader(new FileReader(ndkMetaPlatformsFile)) : null;
        return PlatformConfigurator.findSuitablePlatformVersionLogged$default(this, abiName, androidVersion, ndkMetaPlatforms, variantName, null, null, null, 112, null);
    }

    private final String getLinkerSysrootPath(File ndkRoot, Abi abi, String platformVersion) {
        String string = FileUtils.join((String[])new String[]{ndkRoot.getPath(), "platforms", platformVersion, "arch-" + abi.getArchitecture()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtils.join(\n        \u2026bi.architecture\n        )");
        return string;
    }

    public PlatformConfigurator(@NotNull File ndkRoot) {
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        this.ndkRoot = ndkRoot;
        this.sensibleDefaultPlatformApiVersionForErrorCase = 22;
        this.veryHighPlatformApiVersion = Integer.MAX_VALUE;
        this.platformNameAliases = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"20", (Object)19), TuplesKt.to((Object)"25", (Object)24), TuplesKt.to((Object)"J", (Object)16), TuplesKt.to((Object)"J-MR1", (Object)17), TuplesKt.to((Object)"J-MR2", (Object)18), TuplesKt.to((Object)"K", (Object)19), TuplesKt.to((Object)"L", (Object)21), TuplesKt.to((Object)"L-MR1", (Object)22), TuplesKt.to((Object)"M", (Object)23), TuplesKt.to((Object)"N", (Object)24), TuplesKt.to((Object)"N-MR1", (Object)24), TuplesKt.to((Object)"O", (Object)26), TuplesKt.to((Object)"O-MR1", (Object)27), TuplesKt.to((Object)"P", (Object)28)});
    }
}

