/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.process;

import android.databinding.tool.util.StringUtils;
import com.android.SdkConstants;
import com.android.build.gradle.internal.process.JarSigner;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/process/OpenJDKJarSigner;", "", "()V", "getJarSigner", "Ljava/io/File;", "parentDir", "locatedJarSigner", "sign", "", "toBeSigned", "signature", "Lcom/android/build/gradle/internal/process/JarSigner$Signature;", "start", "Ljava/lang/Process;", "processBuilder", "Ljava/lang/ProcessBuilder;", "Companion", "gradle"})
public class OpenJDKJarSigner {
    @NotNull
    private static final String jarSignerExecutable;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    public final void sign(@NotNull File toBeSigned, @NotNull JarSigner.Signature signature) {
        block8: {
            Process process;
            Intrinsics.checkParameterIsNotNull((Object)toBeSigned, (String)"toBeSigned");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            if (!toBeSigned.exists()) {
                throw (Throwable)new FileNotFoundException("Signing target " + toBeSigned.getAbsolutePath() + " not found");
            }
            File jarSigner = this.locatedJarSigner();
            Object[] objectArray = new String[1];
            String string = jarSigner != null ? jarSigner.getAbsolutePath() : jarSignerExecutable;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (jarSigner!=null) jar\u2026 else jarSignerExecutable");
            objectArray[0] = string;
            List args = CollectionsKt.mutableListOf((Object[])objectArray);
            args.add("-keystore");
            String string2 = signature.getKeystoreFile().getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"signature.keystoreFile.absolutePath");
            args.add(string2);
            File keyStorePasswordFile = null;
            File aliasPasswordFile = null;
            if (signature.getKeystorePassword() != null) {
                keyStorePasswordFile = File.createTempFile("store", "prv");
                FileUtils.writeToFile((File)keyStorePasswordFile, (String)signature.getKeystorePassword());
                args.add("-storepass:file");
                File file = keyStorePasswordFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"keyStorePasswordFile");
                String string3 = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"keyStorePasswordFile.absolutePath");
                args.add(string3);
            }
            if (signature.getKeyPassword() != null) {
                aliasPasswordFile = File.createTempFile("alias", "prv");
                FileUtils.writeToFile((File)aliasPasswordFile, (String)signature.getKeyPassword());
                args.add("--keypass:file");
                File file = aliasPasswordFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"aliasPasswordFile");
                String string4 = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"aliasPasswordFile.absolutePath");
                args.add(string4);
            }
            String string5 = toBeSigned.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"toBeSigned.absolutePath");
            args.add(string5);
            if (signature.getKeyAlias() != null) {
                args.add(signature.getKeyAlias());
            }
            File errorLog = File.createTempFile("error", ".log");
            File outputLog = File.createTempFile("output", ".log");
            logger.fine("Invoking " + Joiner.on((String)" ").join((Iterable)args));
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(args).redirectError(errorLog).redirectOutput(outputLog);
                Intrinsics.checkExpressionValueIsNotNull((Object)processBuilder, (String)"ProcessBuilder(args).red\u2026redirectOutput(outputLog)");
                process = this.start(processBuilder);
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException("Cannot start \"" + jarSignerExecutable + "\" process, please add it " + "to the PATH", e);
            }
            Process process2 = process;
            int exitCode = process2.waitFor();
            if (exitCode != 0) {
                String errors = FileUtils.loadFileWithUnixLineSeparators((File)errorLog);
                String output2 = FileUtils.loadFileWithUnixLineSeparators((File)outputLog);
                throw (Throwable)new RuntimeException(jarSignerExecutable + "failed with exit code " + exitCode + " :\n" + (StringUtils.isNotBlank((CharSequence)errors) ? errors : output2));
            }
            File file = keyStorePasswordFile;
            if (file != null) {
                file.delete();
            }
            File file2 = aliasPasswordFile;
            if (file2 == null) break block8;
            file2.delete();
        }
    }

    @NotNull
    public Process start(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)processBuilder, (String)"processBuilder");
        Process process = processBuilder.start();
        if (process == null) {
            Intrinsics.throwNpe();
        }
        return process;
    }

    @Nullable
    public File locatedJarSigner() {
        File javaHome = new File(System.getProperty("java.home"));
        File jarSigner = this.getJarSigner(javaHome);
        if (jarSigner.exists()) {
            return jarSigner;
        }
        File file = javaHome.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"javaHome.parentFile");
        jarSigner = this.getJarSigner(file);
        return jarSigner.exists() ? jarSigner : null;
    }

    private final File getJarSigner(File parentDir) {
        return new File(new File(parentDir, "bin"), jarSignerExecutable);
    }

    static {
        Companion = new Companion(null);
        jarSignerExecutable = SdkConstants.currentPlatform() == 2 ? "jarsigner.exe" : "jarsigner";
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(OpenJDKJarSigner::javaClass.name)");
        OpenJDKJarSigner.logger = logger;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/process/OpenJDKJarSigner$Companion;", "", "()V", "jarSignerExecutable", "", "getJarSignerExecutable", "()Ljava/lang/String;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "gradle"})
    public static final class Companion {
        @NotNull
        public final String getJarSignerExecutable() {
            return jarSignerExecutable;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

