/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.test

import com.android.build.api.artifact.BuildableArtifact
import com.android.build.gradle.internal.tasks.getApkFiles
import com.android.build.gradle.internal.utils.toImmutableList
import com.android.build.gradle.internal.variant.TestVariantData
import com.android.builder.testing.TestData
import com.android.builder.testing.api.DeviceConfigProvider
import com.android.ide.common.process.ProcessExecutor
import com.android.utils.ILogger
import com.google.common.collect.ImmutableList
import org.gradle.api.file.FileCollection
import java.io.File

/**
 * Implementation of [TestData] for tests that run against
 * the bundle APKs.
 *
 * For the moment, that is only dynamic feature modules.
 */
class BundleTestDataImpl(
    private val testVariantData: TestVariantData,
    testApkDir: BuildableArtifact,
    private val moduleName: String?,
    private val apkBundle: FileCollection
) : AbstractTestDataImpl(testVariantData.variantConfiguration, testApkDir, null) {

    override fun loadFromMetadataFile(metadataFile: File) {
        // do nothing, there is nothing in the metadata file we cannot get from the tested scope.
    }

    override fun getApplicationId(): String = testVariantData.applicationId

    override fun getTestedApplicationId(): String? =
        testVariantData.variantConfiguration.testedApplicationId

    override fun isLibrary(): Boolean =
        testVariantData.testedVariantData.variantConfiguration.type.isAar

    override fun getTestedApks(
        processExecutor: ProcessExecutor,
        splitSelectExe: File?,
        deviceConfigProvider: DeviceConfigProvider,
        logger: ILogger
    ): ImmutableList<File> {
        return getApkFiles(apkBundle.singleFile.toPath(), deviceConfigProvider, moduleName).map{it.toFile()}.toImmutableList()
    }

    override fun getTestedApksFromBundle(): FileCollection? = apkBundle
}
