/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.BuildableArtifact;
import com.google.common.collect.Iterators;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\b\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\b\u00a8\u0006\f"}, d2={"forNameInFolder", "Ljava/io/File;", "files", "", "name", "", "([Ljava/io/File;Ljava/lang/String;)Ljava/io/File;", "forName", "Lcom/android/build/api/artifact/BuildableArtifact;", "singleFile", "singlePath", "Ljava/nio/file/Path;", "gradle"})
@JvmName(name="BuildableArtifactUtil")
public final class BuildableArtifactUtil {
    @Nullable
    public static final File forName(@NotNull BuildableArtifact $receiver, @NotNull String name) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Collection collection = $receiver$iv = (Collection)$receiver.getFiles();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        if (fileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return BuildableArtifactUtil.forNameInFolder(fileArray, name);
    }

    private static final File forNameInFolder(File[] files2, String name) {
        Object object;
        block4: {
            int n;
            Object it;
            Object element$iv$iv;
            Object $receiver$iv$iv;
            Object $receiver$iv;
            Object object2 = $receiver$iv = files2;
            Collection destination$iv$iv = new ArrayList();
            Object object3 = $receiver$iv$iv;
            int n2 = ((void)object3).length;
            for (int i = 0; i < n2; ++i) {
                it = element$iv$iv = object3[i];
                boolean bl = false;
                if (!((File)it).isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv.iterator();
            while ($receiver$iv$iv.hasNext()) {
                Object element$iv = $receiver$iv$iv.next();
                File it2 = (File)element$iv;
                n = 0;
                File[] fileArray = it2.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"it.listFiles()");
                File file = BuildableArtifactUtil.forNameInFolder(fileArray, name);
                if (file == null) continue;
                return file;
            }
            $receiver$iv$iv = $receiver$iv = files2;
            destination$iv$iv = new ArrayList();
            object3 = $receiver$iv$iv;
            n = ((Object)object3).length;
            for (int file = 0; file < n; ++file) {
                it = element$iv$iv = object3[file];
                boolean bl = false;
                if (!((File)it).isFile()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            object2 = iterable;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                File it3 = (File)object3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)name)) continue;
                object = object3;
                break block4;
            }
            object = null;
        }
        return (File)object;
    }

    @NotNull
    public static final File singleFile(@NotNull BuildableArtifact $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = Iterators.getOnlyElement((Iterator)$receiver.iterator());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Iterators.getOnlyElement(iterator())");
        return (File)object;
    }

    @NotNull
    public static final Path singlePath(@NotNull BuildableArtifact $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Path path = ((File)Iterators.getOnlyElement((Iterator)$receiver.iterator())).toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Iterators.getOnlyElement(iterator()).toPath()");
        return path;
    }
}

