/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AarTransformUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class AarCompileClassesTransform
extends ArtifactTransform {
    private final boolean autoNamespaceDependencies;

    @Inject
    public AarCompileClassesTransform(boolean autoNamespaceDependencies) {
        this.autoNamespaceDependencies = autoNamespaceDependencies;
    }

    public List<File> transform(File input2) {
        if (AarTransformUtil.shouldBeAutoNamespaced(input2, this.autoNamespaceDependencies)) {
            return Collections.emptyList();
        }
        File apiJar = new File(input2, "api.jar");
        if (apiJar.exists()) {
            return Collections.singletonList(apiJar);
        }
        return AarTransformUtil.getJars(input2);
    }
}

