/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class FeatureSplitDeclarationWriterTask
extends AndroidVariantTask {
    String uniqueIdentifier;
    Supplier<String> originalApplicationIdSupplier;
    File outputDirectory;

    @Input
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @Input
    public String getApplicationId() {
        return this.originalApplicationIdSupplier.get();
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void fullTaskAction() throws IOException {
        FeatureSplitDeclaration declaration = new FeatureSplitDeclaration(this.uniqueIdentifier, this.getApplicationId());
        declaration.save(this.outputDirectory);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<FeatureSplitDeclarationWriterTask> {
        private File outputDirectory;

        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("feature", "Writer");
        }

        @Override
        public Class<FeatureSplitDeclarationWriterTask> getType() {
            return FeatureSplitDeclarationWriterTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.outputDirectory = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.METADATA_FEATURE_DECLARATION, taskName, "out");
        }

        @Override
        public void configure(FeatureSplitDeclarationWriterTask task) {
            super.configure(task);
            task.uniqueIdentifier = this.getVariantScope().getGlobalScope().getProject().getPath();
            task.originalApplicationIdSupplier = this.getVariantScope().getVariantConfiguration()::getOriginalApplicationId;
            task.outputDirectory = this.outputDirectory;
        }
    }
}

