/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.dsl.SplitOptions;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DensitySplitOptions
extends SplitOptions {
    private boolean strict = true;
    private Set<String> compatibleScreens;

    @Override
    protected Set<String> getDefaultValues() {
        Set values = Density.getRecommendedValuesForDevice();
        HashSet fullList = Sets.newHashSetWithExpectedSize((int)values.size());
        for (Density value : values) {
            fullList.add(value.getResourceValue());
        }
        return fullList;
    }

    @Override
    protected ImmutableSet<String> getAllowedValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Density value : Density.values()) {
            if (value == Density.NODPI || value == Density.ANYDPI) continue;
            builder.add((Object)value.getResourceValue());
        }
        return builder.build();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setCompatibleScreens(List<String> sizes) {
        this.compatibleScreens = Sets.newHashSet(sizes);
    }

    public void compatibleScreens(String ... sizes) {
        if (this.compatibleScreens == null) {
            this.compatibleScreens = Sets.newHashSet((Object[])sizes);
            return;
        }
        this.compatibleScreens.addAll(Arrays.asList(sizes));
    }

    public Set<String> getCompatibleScreens() {
        if (this.compatibleScreens == null) {
            return Collections.emptySet();
        }
        return this.compatibleScreens;
    }

    @Deprecated
    public void setAuto(boolean auto) {
        throw new RuntimeException("DensitySplitOptions.auto is not supported anymore.");
    }
}

