/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.dexing.DexSplitterTool;
import com.android.utils.FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\fH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/transforms/DexSplitterTransform;", "Lcom/android/build/api/transform/Transform;", "outputDir", "Ljava/io/File;", "featureJars", "Lorg/gradle/api/file/FileCollection;", "baseJars", "Lcom/android/build/api/artifact/BuildableArtifact;", "mappingFileSrc", "mainDexList", "(Ljava/io/File;Lorg/gradle/api/file/FileCollection;Lcom/android/build/api/artifact/BuildableArtifact;Lcom/android/build/api/artifact/BuildableArtifact;Lcom/android/build/api/artifact/BuildableArtifact;)V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getOutputTypes", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getSecondaryDirectoryOutputs", "", "getSecondaryFiles", "Lcom/android/build/api/transform/SecondaryFile;", "isIncremental", "", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class DexSplitterTransform
extends Transform {
    private final File outputDir;
    private final FileCollection featureJars;
    private final BuildableArtifact baseJars;
    private final BuildableArtifact mappingFileSrc;
    private final BuildableArtifact mainDexList;

    @NotNull
    public String getName() {
        return "dexSplitter";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_DEX;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CONTENT_DEX");
        return set;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getOutputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_DEX;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CONTENT_DEX");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set<QualifiedContent.ScopeType> set = TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES");
        return set;
    }

    public boolean isIncremental() {
        return false;
    }

    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        Collection secondaryFiles;
        block1: {
            BuildableArtifact it;
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            secondaryFiles = new ArrayList();
            SecondaryFile secondaryFile = SecondaryFile.nonIncremental((FileCollection)this.featureJars);
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile, (String)"SecondaryFile.nonIncremental(featureJars)");
            secondaryFiles.add(secondaryFile);
            SecondaryFile secondaryFile2 = SecondaryFile.nonIncremental((Supplier)((Supplier)this.baseJars));
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile2, (String)"SecondaryFile.nonIncremental(baseJars)");
            secondaryFiles.add(secondaryFile2);
            BuildableArtifact buildableArtifact = this.mappingFileSrc;
            if (buildableArtifact != null) {
                BuildableArtifact buildableArtifact2 = buildableArtifact;
                bl2 = false;
                bl = false;
                it = buildableArtifact2;
                boolean bl4 = false;
                SecondaryFile secondaryFile3 = SecondaryFile.nonIncremental((Supplier)((Supplier)it));
                Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile3, (String)"SecondaryFile.nonIncremental(it)");
                secondaryFiles.add(secondaryFile3);
            }
            BuildableArtifact buildableArtifact3 = this.mainDexList;
            if (buildableArtifact3 == null) break block1;
            BuildableArtifact buildableArtifact4 = buildableArtifact3;
            bl2 = false;
            bl = false;
            it = buildableArtifact4;
            boolean bl5 = false;
            SecondaryFile secondaryFile4 = SecondaryFile.nonIncremental((Supplier)((Supplier)it));
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile4, (String)"SecondaryFile.nonIncremental(it)");
            secondaryFiles.add(secondaryFile4);
        }
        return secondaryFiles;
    }

    @NotNull
    public Collection<File> getSecondaryDirectoryOutputs() {
        return CollectionsKt.mutableListOf((Object[])new File[]{this.outputDir});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        try {
            File file;
            boolean bl;
            File[] fileArray;
            File transformOutputDir;
            block9: {
                File it;
                Object object;
                Object object2 = this.mappingFileSrc;
                File mappingFile = object2 != null && (object2 = BuildableArtifactUtil.singleFile((BuildableArtifact)object2)) != null && ((File)object2).exists() && !BuildableArtifactUtil.singleFile(this.mappingFileSrc).isDirectory() ? BuildableArtifactUtil.singleFile(this.mappingFileSrc) : null;
                TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
                boolean bl2 = false;
                boolean bl3 = false;
                if (transformOutputProvider == null) {
                    boolean bl4 = false;
                    String string = "No output provider set";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                TransformOutputProvider outputProvider = transformOutputProvider;
                outputProvider.deleteAll();
                FileUtils.deleteRecursivelyIfExists((File)this.outputDir);
                Path path = this.outputDir.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputDir.toPath()");
                File file2 = mappingFile;
                DexSplitterTool.Builder builder = new DexSplitterTool.Builder(path, file2 != null ? file2.toPath() : null, (object = this.mainDexList) != null && (object = BuildableArtifactUtil.singleFile((BuildableArtifact)object)) != null ? ((File)object).toPath() : null);
                for (File dirInput : TransformInputUtil.getDirectories(transformInvocation.getInputs())) {
                    Iterator $this$mapTo$iv$iv;
                    Object object3 = dirInput.listFiles();
                    if (object3 == null || (object3 = ArraysKt.toList((Object[])object3)) == null) continue;
                    Iterable $this$map$iv = (Iterable)object3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        File file3 = (File)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        Path path2 = it.toPath();
                        collection.add(path2);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    $this$mapTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        Path it2 = (Path)element$iv;
                        boolean bl6 = false;
                        Path path3 = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"it");
                        builder.addInputArchive(path3);
                    }
                }
                Set set = this.featureJars.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureJars.files");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file4 = (File)element$iv;
                    boolean bl7 = false;
                    Path path4 = file4.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"file.toPath()");
                    File file5 = file4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"file");
                    builder.addFeatureJar(path4, FilesKt.getNameWithoutExtension((File)file5));
                    Files.createDirectories(new File(this.outputDir, FilesKt.getNameWithoutExtension((File)file4)).toPath(), new FileAttribute[0]);
                }
                $this$forEach$iv = this.baseJars.getFiles();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it3 = (File)element$iv;
                    boolean bl8 = false;
                    Path path5 = it3.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"it.toPath()");
                    builder.addBaseJar(path5);
                }
                builder.build().run();
                transformOutputDir = outputProvider.getContentLocation("splitDexFiles", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                Files.createDirectories(transformOutputDir.toPath(), new FileAttribute[0]);
                File[] fileArray2 = this.outputDir.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray2, (String)"outputDir.listFiles()");
                fileArray = fileArray2;
                bl = false;
                File[] fileArray3 = fileArray;
                boolean it3 = false;
                File[] bl8 = fileArray3;
                int n = bl8.length;
                for (int j = 0; j < n; ++j) {
                    File file6;
                    it = file6 = bl8[j];
                    boolean bl9 = false;
                    File file7 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"it");
                    if (!Intrinsics.areEqual((Object)file7.getName(), (Object)"base")) continue;
                    file = file6;
                    break block9;
                }
                file = null;
            }
            if (file == null) return;
            fileArray = file;
            bl = false;
            boolean bl10 = false;
            File[] it = fileArray;
            boolean bl11 = false;
            FileUtils.copyDirectory((File)it, (File)transformOutputDir);
            FileUtils.deleteRecursivelyIfExists((File)it);
            return;
        }
        catch (Exception e) {
            throw (Throwable)new TransformException((Throwable)e);
        }
    }

    public DexSplitterTransform(@NotNull File outputDir, @NotNull FileCollection featureJars, @NotNull BuildableArtifact baseJars, @Nullable BuildableArtifact mappingFileSrc, @Nullable BuildableArtifact mainDexList) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)featureJars, (String)"featureJars");
        Intrinsics.checkParameterIsNotNull((Object)baseJars, (String)"baseJars");
        this.outputDir = outputDir;
        this.featureJars = featureJars;
        this.baseJars = baseJars;
        this.mappingFileSrc = mappingFileSrc;
        this.mainDexList = mainDexList;
    }
}

