/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant2;

import com.android.build.api.dsl.variant.Variant;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0019J\u0019\u0010\u001a\u001a\u00020\u00002\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b!J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000bH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c2\u0003JM\u0010'\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/android/build/gradle/internal/variant2/VariantPredicate;", "", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "name", "", "theClass", "Ljava/lang/Class;", "buildTypeName", "flavorNames", "", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;Ljava/util/List;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "getBuildTypeName", "()Ljava/lang/String;", "getFlavorNames", "()Ljava/util/List;", "getName", "getTheClass", "()Ljava/lang/Class;", "accept", "", "variant", "Lcom/android/build/api/dsl/variant/Variant;", "cloneWithBuildType", "cloneWithBuildType$gradle", "cloneWithClass", "variantClass", "cloneWithClass$gradle", "cloneWithFlavor", "flavorName", "cloneWithFlavor$gradle", "cloneWithName", "cloneWithName$gradle", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "gradle"})
public final class VariantPredicate {
    @Nullable
    private final String name;
    @Nullable
    private final Class<?> theClass;
    @Nullable
    private final String buildTypeName;
    @Nullable
    private final List<String> flavorNames;
    private final DslScope dslScope;

    public final boolean accept(@NotNull Variant variant) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        if (this.name != null && Intrinsics.areEqual((Object)variant.getName(), (Object)this.name) ^ true) {
            return false;
        }
        if (this.theClass != null && !this.theClass.isInstance(variant)) {
            return false;
        }
        if (this.buildTypeName != null && Intrinsics.areEqual((Object)variant.getBuildTypeName(), (Object)this.buildTypeName) ^ true) {
            return false;
        }
        if (this.flavorNames != null) {
            Collection collection = this.flavorNames;
            boolean bl = false;
            if (!collection.isEmpty() && !variant.getFlavorNames().containsAll((Collection)this.flavorNames)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final VariantPredicate cloneWithName$gradle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.name != null) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Already filtered on variant name", null, null, 6, null));
        }
        return new VariantPredicate(name, this.theClass, this.buildTypeName, this.flavorNames, this.dslScope);
    }

    @NotNull
    public final VariantPredicate cloneWithClass$gradle(@NotNull Class<?> variantClass) {
        Intrinsics.checkParameterIsNotNull(variantClass, (String)"variantClass");
        if (this.theClass != null) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Already filtered on variant type", null, null, 6, null));
        }
        return new VariantPredicate(this.name, variantClass, this.buildTypeName, this.flavorNames, this.dslScope);
    }

    @NotNull
    public final VariantPredicate cloneWithBuildType$gradle(@NotNull String buildTypeName) {
        Intrinsics.checkParameterIsNotNull((Object)buildTypeName, (String)"buildTypeName");
        if (this.buildTypeName != null) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Already filtered on build type name", null, null, 6, null));
        }
        return new VariantPredicate(this.name, this.theClass, buildTypeName, this.flavorNames, this.dslScope);
    }

    @NotNull
    public final VariantPredicate cloneWithFlavor$gradle(@NotNull String flavorName) {
        Intrinsics.checkParameterIsNotNull((Object)flavorName, (String)"flavorName");
        if (this.flavorNames == null || this.flavorNames.isEmpty()) {
            return new VariantPredicate(this.name, this.theClass, this.buildTypeName, CollectionsKt.listOf((Object)flavorName), this.dslScope);
        }
        ArrayList<String> flavors = new ArrayList<String>((Collection)this.flavorNames);
        flavors.add(flavorName);
        return new VariantPredicate(this.name, this.theClass, this.buildTypeName, (List<String>)flavors, this.dslScope);
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Class<?> getTheClass() {
        return this.theClass;
    }

    @Nullable
    public final String getBuildTypeName() {
        return this.buildTypeName;
    }

    @Nullable
    public final List<String> getFlavorNames() {
        return this.flavorNames;
    }

    public VariantPredicate(@Nullable String name, @Nullable Class<?> theClass, @Nullable String buildTypeName, @Nullable List<String> flavorNames, @NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.name = name;
        this.theClass = theClass;
        this.buildTypeName = buildTypeName;
        this.flavorNames = flavorNames;
        this.dslScope = dslScope;
    }

    public VariantPredicate(@NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this(null, null, null, null, dslScope);
    }

    @Nullable
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final Class<?> component2() {
        return this.theClass;
    }

    @Nullable
    public final String component3() {
        return this.buildTypeName;
    }

    @Nullable
    public final List<String> component4() {
        return this.flavorNames;
    }

    private final DslScope component5() {
        return this.dslScope;
    }

    @NotNull
    public final VariantPredicate copy(@Nullable String name, @Nullable Class<?> theClass, @Nullable String buildTypeName, @Nullable List<String> flavorNames, @NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        return new VariantPredicate(name, theClass, buildTypeName, flavorNames, dslScope);
    }

    public static /* synthetic */ VariantPredicate copy$default(VariantPredicate variantPredicate, String string, Class clazz, String string2, List list, DslScope dslScope, int n, Object object) {
        if ((n & 1) != 0) {
            string = variantPredicate.name;
        }
        if ((n & 2) != 0) {
            clazz = variantPredicate.theClass;
        }
        if ((n & 4) != 0) {
            string2 = variantPredicate.buildTypeName;
        }
        if ((n & 8) != 0) {
            list = variantPredicate.flavorNames;
        }
        if ((n & 0x10) != 0) {
            dslScope = variantPredicate.dslScope;
        }
        return variantPredicate.copy(string, clazz, string2, list, dslScope);
    }

    @NotNull
    public String toString() {
        return "VariantPredicate(name=" + this.name + ", theClass=" + this.theClass + ", buildTypeName=" + this.buildTypeName + ", flavorNames=" + this.flavorNames + ", dslScope=" + this.dslScope + ")";
    }

    public int hashCode() {
        String string = this.name;
        Class<?> clazz = this.theClass;
        String string2 = this.buildTypeName;
        List<String> list = this.flavorNames;
        DslScope dslScope = this.dslScope;
        return ((((string != null ? string.hashCode() : 0) * 31 + (clazz != null ? clazz.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (dslScope != null ? dslScope.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof VariantPredicate)) break block3;
                VariantPredicate variantPredicate = (VariantPredicate)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)variantPredicate.name) || !Intrinsics.areEqual(this.theClass, variantPredicate.theClass) || !Intrinsics.areEqual((Object)this.buildTypeName, (Object)variantPredicate.buildTypeName) || !Intrinsics.areEqual(this.flavorNames, variantPredicate.flavorNames) || !Intrinsics.areEqual((Object)this.dslScope, (Object)variantPredicate.dslScope)) break block3;
            }
            return true;
        }
        return false;
    }
}

