/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.builder.model.TestOptions;
import com.android.builder.model.Version;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.TestSupportLibraries;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.TestLibraries;
import com.google.wireless.android.sdk.stats.TestRun;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\n\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u001a0\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"gatherTestLibraries", "Lcom/google/wireless/android/sdk/stats/TestLibraries;", "dependencies", "Lorg/gradle/api/artifacts/Configuration;", "recordCrashedTestRun", "", "execution", "Lcom/android/builder/model/TestOptions$Execution;", "coverageEnabled", "", "recordOkTestRun", "testCount", "", "recordTestRun", "infrastructureCrashed", "gradle"})
@JvmName(name="InstrumentationTestAnalytics")
public final class InstrumentationTestAnalytics {
    public static final void recordOkTestRun(@NotNull Configuration dependencies, @NotNull TestOptions.Execution execution, boolean coverageEnabled, int testCount) {
        Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        InstrumentationTestAnalytics.recordTestRun(dependencies, execution, coverageEnabled, testCount, false);
    }

    public static final void recordCrashedTestRun(@NotNull Configuration dependencies, @NotNull TestOptions.Execution execution, boolean coverageEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        InstrumentationTestAnalytics.recordTestRun(dependencies, execution, coverageEnabled, 0, true);
    }

    private static final void recordTestRun(Configuration dependencies, TestOptions.Execution execution, boolean coverageEnabled, int testCount, boolean infrastructureCrashed) {
        TestRun.Builder builder = TestRun.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TestRun.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.setTestInvocationType(TestRun.TestInvocationType.GRADLE_TEST);
        $this$apply.setNumberOfTestsExecuted(testCount);
        $this$apply.setTestKind(TestRun.TestKind.INSTRUMENTATION_TEST);
        $this$apply.setCrashed(infrastructureCrashed);
        $this$apply.setGradleVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION);
        $this$apply.setCodeCoverageEnabled(coverageEnabled);
        $this$apply.setTestLibraries(InstrumentationTestAnalytics.gatherTestLibraries(dependencies));
        $this$apply.setTestExecution(AnalyticsUtil.toProto(execution));
        TestRun run2 = builder.build();
        builder = AndroidStudioEvent.newBuilder();
        ProcessProfileWriter processProfileWriter = ProcessProfileWriter.get();
        bl = false;
        bl2 = false;
        $this$apply = builder;
        boolean bl4 = false;
        $this$apply.setCategory(AndroidStudioEvent.EventCategory.TESTS);
        $this$apply.setKind(AndroidStudioEvent.EventKind.TEST_RUN);
        $this$apply.setTestRun(run2);
        $this$apply.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$apply.setJvmDetails(CommonMetricsData.getJvmDetails());
        $this$apply.setProductDetails(AnalyticsUtil.getProductDetails());
        TestRun.Builder builder2 = builder;
        processProfileWriter.recordEvent((AndroidStudioEvent.Builder)builder2);
    }

    private static final TestLibraries gatherTestLibraries(Configuration dependencies) {
        TestLibraries.Builder builder = TestLibraries.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TestLibraries.Builder testLibraries = builder;
        boolean bl3 = false;
        ResolvableDependencies resolvableDependencies = dependencies.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"dependencies.incoming");
        resolvableDependencies.getResolutionResult().allComponents((Action)new Action<ResolvedComponentResult>(testLibraries){
            final /* synthetic */ TestLibraries.Builder $testLibraries;

            public final void execute(ResolvedComponentResult resolvedComponentResult) {
                ResolvedComponentResult resolvedComponentResult2 = resolvedComponentResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult2, (String)"resolvedComponentResult");
                ComponentIdentifier id = resolvedComponentResult2.getId();
                if (id instanceof ModuleComponentIdentifier) {
                    TestLibraries.Builder builder = this.$testLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"testLibraries");
                    String string = ((ModuleComponentIdentifier)id).getGroup();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.group");
                    String string2 = ((ModuleComponentIdentifier)id).getModule();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id.module");
                    String string3 = ((ModuleComponentIdentifier)id).getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"id.version");
                    TestSupportLibraries.recordTestLibrary((TestLibraries.Builder)builder, (String)string, (String)string2, (String)string3);
                }
            }
            {
                this.$testLibraries = builder;
            }
        });
        TestLibraries testLibraries2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)testLibraries2, (String)"TestLibraries.newBuilder\u2026}\n        }\n    }.build()");
        return testLibraries2;
    }
}

