/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TestApplicationTestData
extends AbstractTestDataImpl {
    private final Supplier<String> testApplicationId;
    private final Map<String, String> testedProperties;
    private final GradleVariantConfiguration variantConfiguration;

    public TestApplicationTestData(GradleVariantConfiguration variantConfiguration, Supplier<String> testApplicationId, BuildableArtifact testApkDir, BuildableArtifact testedApksDir) {
        super(variantConfiguration, testApkDir, testedApksDir);
        this.variantConfiguration = variantConfiguration;
        this.testedProperties = new HashMap<String, String>();
        this.testApplicationId = testApplicationId;
    }

    public void loadFromMetadataFile(File metadataFile) {
        BuildElements testedManifests = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, metadataFile.getParentFile());
        Optional<BuildOutput> splitOutput = testedManifests.stream().findFirst();
        if (!splitOutput.isPresent()) {
            throw new RuntimeException("No merged manifest metadata at " + metadataFile.getAbsolutePath());
        }
        this.testedProperties.putAll(splitOutput.get().getProperties());
    }

    public String getApplicationId() {
        return this.testApplicationId.get();
    }

    public String getTestedApplicationId() {
        return this.testedProperties.get("packageId");
    }

    public boolean isLibrary() {
        return false;
    }

    public ImmutableList<File> getTestedApks(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        ImmutableList.Builder selectedApks = ImmutableList.builder();
        BuildElements testedApkFiles = ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, this.testedApksDir);
        if (testedApkFiles.size() > 1 && splitSelectExe != null) {
            List<String> testedSplitApksPath = TestApplicationTestData.getSplitApks(testedApkFiles);
            selectedApks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)deviceConfigProvider, (File)TestApplicationTestData.getMainApk(testedApkFiles), testedSplitApksPath));
        } else {
            if (testedApkFiles.size() > 1) {
                logger.warning("split-select tool unavailable, all split APKs will be installed", new Object[0]);
            }
            selectedApks.addAll((Iterable)testedApkFiles.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()));
        }
        return selectedApks.build();
    }

    private static List<String> getSplitApks(BuildElements builtArtifacts) {
        return builtArtifacts.stream().filter(splitOutput -> splitOutput.getApkData().getType() == VariantOutput.OutputType.SPLIT).map(splitOutput -> splitOutput.getOutputFile().getAbsolutePath()).collect(Collectors.toList());
    }

    private static File getMainApk(BuildElements builtArtifacts) {
        Optional<File> mainApk = builtArtifacts.stream().filter(splitOutput -> splitOutput.getApkData().getType() != VariantOutput.OutputType.SPLIT).map(BuildOutput::getOutputFile).findFirst();
        if (mainApk.isPresent()) {
            return mainApk.get();
        }
        throw new RuntimeException("Cannot retrieve main APK");
    }
}

