/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;

public class CheckManifest
extends NonIncrementalTask {
    private File manifest;
    private Boolean isOptional;
    private File fakeOutputDir;

    @Optional
    @Input
    public File getManifest() {
        return this.manifest;
    }

    @Input
    public boolean getManifestPresence() {
        return this.manifest != null && this.manifest.isFile();
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    @Input
    public Boolean getOptional() {
        return this.isOptional;
    }

    public void setOptional(Boolean optional) {
        this.isOptional = optional;
    }

    @OutputDirectory
    public File getFakeOutputDir() {
        return this.fakeOutputDir;
    }

    @Override
    protected void doTaskAction() {
        if (!this.isOptional.booleanValue() && this.manifest != null && !this.manifest.isFile()) {
            throw new IllegalArgumentException(String.format("Main Manifest missing for variant %1$s. Expected path: %2$s", this.getVariantName(), this.getManifest().getAbsolutePath()));
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CheckManifest> {
        private final boolean isManifestOptional;
        private File output;

        public CreationAction(VariantScope scope, boolean isManifestOptional) {
            super(scope);
            this.isManifestOptional = isManifestOptional;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("check", "Manifest");
        }

        @Override
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends CheckManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setCheckManifestTask(taskProvider);
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.output = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.CHECK_MANIFEST_RESULT, taskName, "out");
        }

        @Override
        public void configure(CheckManifest task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setOptional(this.isManifestOptional);
            task.manifest = scope.getVariantConfiguration().getMainManifest();
            task.fakeOutputDir = this.output;
        }
    }
}

