/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.JacocoTaskDelegate;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.dexing.DexerTool;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class JacocoTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    private FileCollection jacocoAntTaskConfiguration;
    private BuildableArtifact inputClasses;
    private File output;
    private Provider<Directory> outputJars;
    private JacocoTaskDelegate delegate;
    private WorkerExecutorFacade.IsolationMode isolationMode;

    @Inject
    public JacocoTask(WorkerExecutor workers) {
        this.workers = Workers.INSTANCE.preferWorkers(this.getProject().getName(), this.getPath(), workers);
    }

    @InputFiles
    public FileCollection getJacocoAntTaskConfiguration() {
        return this.jacocoAntTaskConfiguration;
    }

    @InputFiles
    public BuildableArtifact getInputClasses() {
        return this.inputClasses;
    }

    @Input
    public WorkerExecutorFacade.IsolationMode getIsolationMode() {
        return this.isolationMode;
    }

    @OutputDirectory
    public File getOutput() {
        return this.output;
    }

    @OutputDirectory
    public Provider<Directory> getOutputJars() {
        return this.outputJars;
    }

    public static String getJacocoVersion(VariantScope scope) {
        if (scope.getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return scope.getGlobalScope().getExtension().getJacoco().getVersion();
    }

    @TaskAction
    public void run(IncrementalTaskInputs inputs) {
        this.recordTaskAction((Function0<Unit>)((Function0)() -> {
            try {
                this.delegate.run(this.workers, inputs);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.workers.close();
            }
            return null;
        }));
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoTask> {
        private File output;
        private Provider<Directory> outputJars;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("jacoco");
        }

        @Override
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.output = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES, taskName, "out");
            this.outputJars = this.getVariantScope().getArtifacts().createDirectory((ArtifactType)InternalArtifactType.JACOCO_INSTRUMENTED_JARS, BuildArtifactsHolder.OperationType.INITIAL, taskName, "out");
        }

        @Override
        public void configure(JacocoTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.inputClasses = scope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES);
            task.jacocoAntTaskConfiguration = (FileCollection)JacocoConfigurations.getJacocoAntTaskConfiguration(scope.getGlobalScope().getProject(), JacocoTask.getJacocoVersion(scope));
            task.output = this.output;
            task.outputJars = this.outputJars;
            task.isolationMode = scope.getGlobalScope().getProjectOptions().get(BooleanOption.FORCE_JACOCO_OUT_OF_PROCESS) ? WorkerExecutorFacade.IsolationMode.PROCESS : WorkerExecutorFacade.IsolationMode.CLASSLOADER;
            task.delegate = new JacocoTaskDelegate(task.jacocoAntTaskConfiguration, task.output, (Provider<Directory>)task.outputJars, task.inputClasses, task.isolationMode);
        }
    }
}

