/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SourceProviderContainerImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.builder.core.VariantType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class ProductFlavorContainerImpl
implements ProductFlavorContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ProductFlavor productFlavor;
    private final SourceProvider sourceProvider;
    private final Collection<SourceProviderContainer> extraSourceProviders;

    static ProductFlavorContainer createProductFlavorContainer(ProductFlavorData productFlavorData, Collection<SourceProviderContainer> sourceProviderContainers) {
        List<SourceProviderContainer> clonedContainers = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        for (VariantType variantType : VariantType.Companion.getTestComponents()) {
            DefaultAndroidSourceSet sourceSet = productFlavorData.getTestSourceSet(variantType);
            if (sourceSet == null) continue;
            clonedContainers.add(SourceProviderContainerImpl.create(variantType.getArtifactName(), sourceSet));
        }
        return new ProductFlavorContainerImpl(new ProductFlavorImpl((ProductFlavor)productFlavorData.getProductFlavor()), new SourceProviderImpl(productFlavorData.getSourceSet()), clonedContainers);
    }

    private ProductFlavorContainerImpl(ProductFlavorImpl productFlavor, SourceProviderImpl sourceProvider, Collection<SourceProviderContainer> extraSourceProviders) {
        this.productFlavor = productFlavor;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    public ProductFlavor getProductFlavor() {
        return this.productFlavor;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductFlavorContainerImpl that = (ProductFlavorContainerImpl)o;
        return Objects.equals(this.productFlavor, that.productFlavor) && Objects.equals(this.sourceProvider, that.sourceProvider) && Objects.equals(this.extraSourceProviders, that.extraSourceProviders);
    }

    public int hashCode() {
        return Objects.hash(this.productFlavor, this.sourceProvider, this.extraSourceProviders);
    }
}

