/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.feature.BundleAllClasses;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ApkZipPackagingTask;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.BundleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckMultiApkLibrariesTask;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.SdkDependencyDataGeneratorTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureApplicationIdsTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureNameWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.PackagedDependenciesWriterTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.VariantType;
import com.android.builder.errors.IssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, DataBindingBuilder dataBindingBuilder, BaseExtension extension, VariantFactory variantFactory, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project2, projectOptions, dataBindingBuilder, extension, variantFactory, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope, List<VariantScope> variantScopesForLint) {
        this.createAnchorTasks(variantScope);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(variantScope));
        this.handleMicroApp(variantScope);
        this.createDependencyStreams(variantScope);
        this.createApplicationIdWriterTask(variantScope);
        this.createBuildArtifactReportTask(variantScope);
        this.taskFactory.register(new CheckManifest.CreationAction(variantScope));
        this.createMergeApkManifestsTask(variantScope);
        this.createGenerateResValuesTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTasks(variantScope);
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createApkProcessResTask(variantScope);
        this.registerRClassTransformStream(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        this.createExternalNativeBuildJsonGenerators(variantScope);
        this.createExternalNativeBuildTasks(variantScope);
        this.createMergeJniLibFoldersTasks(variantScope);
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.register(new FeatureSetMetadataWriterTask.CreationAction(variantScope));
            this.createValidateSigningTask(variantScope);
            this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variantScope));
            if (!((BaseAppModuleExtension)this.extension).getAssetPacks().isEmpty()) {
                this.createAssetPackTasks(variantScope);
            }
            if (this.globalScope.getBuildFeatures().getDataBinding()) {
                this.taskFactory.register(new DataBindingExportFeatureApplicationIdsTask.CreationAction(variantScope));
            }
        } else {
            this.taskFactory.register(new FeatureSplitDeclarationWriterTask.CreationAction(variantScope));
            if (this.globalScope.getBuildFeatures().getDataBinding()) {
                this.taskFactory.register(new DataBindingExportFeatureInfoTask.CreationAction(variantScope));
            }
            this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(variantScope));
            this.taskFactory.register(new FeatureNameWriterTask.CreationAction(variantScope));
        }
        this.createDataBindingTasksIfNecessary(variantScope);
        this.createCompileTask(variantScope);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(variantScope));
        this.createPackagingTask(variantScope);
        this.maybeCreateLintVitalTask((ApkVariantData)variantScope.getVariantData(), variantScopesForLint);
        this.createLintTasks(variantScope, variantScopesForLint);
        this.taskFactory.register(new PackagedDependenciesWriterTask.CreationAction(variantScope));
        this.createDynamicBundleTask(variantScope);
        this.taskFactory.register(new ApkZipPackagingTask.CreationAction(variantScope));
        if (!variantScope.getGlobalScope().hasDynamicFeatures()) {
            this.createSoftwareComponent(variantScope, "_apk", AndroidArtifacts.PublishedConfigType.APK_PUBLICATION);
        }
        this.createSoftwareComponent(variantScope, "_aab", AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION);
    }

    private void createSoftwareComponent(VariantScope variantScope, String suffix, AndroidArtifacts.PublishedConfigType publication) {
        AdhocComponentWithVariants component = this.globalScope.getComponentFactory().adhoc(variantScope.getName() + suffix);
        Configuration config2 = variantScope.getVariantDependencies().getElements(publication);
        component.addVariantsFromConfiguration(config2, details -> {});
        this.project.getComponents().add((Object)component);
    }

    @Override
    protected void createInstallTask(VariantScope variantScope) {
        VariantType variantType = variantScope.getType();
        if (variantType.isDynamicFeature()) {
            return;
        }
        if (variantType.isForTesting() || !(this.extension instanceof BaseAppModuleExtension) || ((BaseAppModuleExtension)this.extension).getDynamicFeatures().isEmpty()) {
            super.createInstallTask(variantScope);
        } else {
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(variantScope));
        }
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        Provider javacOutput = scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC.INSTANCE);
        FileCollection preJavacGeneratedBytecode = scope.getVariantData().getAllPreJavacGeneratedBytecode();
        FileCollection postJavacGeneratedBytecode = scope.getVariantData().getAllPostJavacGeneratedBytecode();
        this.taskFactory.register(new BundleAllClasses.CreationAction(scope));
        ConfigurableFileCollection files = scope.getGlobalScope().getProject().files(new Object[]{javacOutput, preJavacGeneratedBytecode, postJavacGeneratedBytecode});
        scope.getArtifacts().appendToAllClasses((FileCollection)files);
    }

    @Override
    protected void createVariantPreBuildTask(VariantScope scope) {
        VariantType variantType = scope.getVariantDslInfo().getVariantType();
        if (variantType.isApk()) {
            Object task;
            boolean useDependencyConstraints = scope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS);
            if (variantType.isTestComponent()) {
                task = this.taskFactory.register(new TestPreBuildTask.CreationAction(scope));
                if (useDependencyConstraints) {
                    task.configure(t -> t.setEnabled(false));
                }
            } else {
                task = this.taskFactory.register(AppPreBuildTask.getCreationAction(scope));
            }
            if (!useDependencyConstraints) {
                TaskProvider<AppClasspathCheckTask> classpathCheck = this.taskFactory.register(new AppClasspathCheckTask.CreationAction(scope));
                TaskFactoryUtils.dependsOn(task, classpathCheck);
            }
            if (variantType.isBaseModule() && this.globalScope.hasDynamicFeatures()) {
                TaskProvider<CheckMultiApkLibrariesTask> checkMultiApkLibrariesTask = this.taskFactory.register(new CheckMultiApkLibrariesTask.CreationAction(scope));
                TaskFactoryUtils.dependsOn(task, checkMultiApkLibrariesTask);
            }
            return;
        }
        super.createVariantPreBuildTask(scope);
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(VariantScope variantScope, QualifiedContent.ContentType contentType) {
        if (variantScope.consumesFeatureJars() && contentType == QualifiedContent.DefaultContentType.RESOURCES) {
            return TransformManager.SCOPE_FULL_WITH_FEATURES;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        VariantDslInfo variantDslInfo = variantData.getVariantDslInfo();
        VariantType variantType = scope.getType();
        if (variantType.isBaseModule()) {
            Boolean unbundledWearApp = variantDslInfo.isWearAppUnbundled();
            if (!Boolean.TRUE.equals(unbundledWearApp) && variantDslInfo.isEmbedMicroApp()) {
                Configuration wearApp = variantData.getVariantDependency().getWearAppConfiguration();
                assert (wearApp != null) : "Wear app with no wearApp configuration";
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType());
                    FileCollection files = wearApp.getIncoming().artifactView(config2 -> {
                        ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(setApkArtifact);
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(scope, files);
                }
            } else if (Boolean.TRUE.equals(unbundledWearApp)) {
                this.createGenerateMicroApkDataTask(scope, null);
            }
        }
    }

    private void createApplicationIdWriterTask(VariantScope variantScope) {
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.register(new ModuleMetadataWriterTask.CreationAction(variantScope.getVariantData().getPublicVariantPropertiesApi()));
        }
        TaskProvider<ApplicationIdWriterTask> applicationIdWriterTask = this.taskFactory.register(new ApplicationIdWriterTask.CreationAction(variantScope.getVariantData().getPublicVariantPropertiesApi()));
        TextResourceFactory resources = this.project.getResources().getText();
        variantScope.getVariantData().applicationIdTextResource = resources.fromFile(applicationIdWriterTask);
    }

    private static File getIncrementalFolder(VariantScope variantScope, String taskName) {
        return new File(variantScope.getIncrementalDir(taskName), variantScope.getDirName());
    }

    private void createDynamicBundleTask(VariantScope scope) {
        boolean includeInBundle;
        if (scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(scope, ApplicationTaskManager.packagesCustomClassDependencies(scope, this.projectOptions)));
        boolean debuggable = scope.getVariantDslInfo().isDebuggable();
        boolean includeInApk = this.extension instanceof BaseAppModuleExtension && ((BaseAppModuleExtension)this.extension).getDependenciesInfo().getIncludeInApk();
        boolean bl = includeInBundle = this.extension instanceof BaseAppModuleExtension && ((BaseAppModuleExtension)this.extension).getDependenciesInfo().getIncludeInBundle();
        if (!debuggable) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(scope));
        }
        if (scope.getType().isBaseModule()) {
            this.taskFactory.register(new ParseIntegrityConfigTask.CreationAction(scope));
            this.taskFactory.register(new PackageBundleTask.CreationAction(scope));
            this.taskFactory.register(new FinalizeBundleTask.CreationAction(scope));
            if (!debuggable) {
                if (includeInBundle) {
                    this.taskFactory.register(new BundleReportDependenciesTask.CreationAction(scope));
                }
                if (includeInApk && scope.getGlobalScope().getProjectOptions().get(BooleanOption.INCLUDE_DEPENDENCY_INFO_IN_APKS)) {
                    this.taskFactory.register(new SdkDependencyDataGeneratorTask.CreationAction(scope));
                }
            }
            this.taskFactory.register(new BundleToApkTask.CreationAction(scope));
            this.taskFactory.register(new BundleToStandaloneApkTask.CreationAction(scope));
            this.taskFactory.register(new ExtractApksTask.CreationAction(scope));
        }
    }

    private void createMergeResourcesTasks(VariantScope variantScope) {
        this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]));
        if (this.projectOptions.get(BooleanOption.ENABLE_APP_COMPILE_TIME_R_CLASS) && !variantScope.getType().isForTesting() && !variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            this.basicCreateMergeResourcesTask(variantScope, TaskManager.MergeType.PACKAGE, variantScope.getIntermediateDir(InternalArtifactType.PACKAGED_RES.INSTANCE), false, false, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of(), null);
        }
    }

    private void createAssetPackTasks(VariantScope variantScope) {
        DependencyHandler depHandler = this.project.getDependencies();
        ArrayList<String> notFound = new ArrayList<String>();
        Configuration assetPackFilesConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackManifest");
        boolean needToRegisterAssetPackTasks = false;
        Set<String> assetPacks = ((BaseAppModuleExtension)this.extension).getAssetPacks();
        for (String assetPack : assetPacks) {
            if (this.project.findProject(assetPack) != null) {
                ImmutableMap filesDependency = ImmutableMap.of((Object)"path", (Object)assetPack, (Object)"configuration", (Object)"packElements");
                depHandler.add("assetPackFiles", (Object)depHandler.project((Map)filesDependency));
                ImmutableMap manifestDependency = ImmutableMap.of((Object)"path", (Object)assetPack, (Object)"configuration", (Object)"manifestElements");
                depHandler.add("assetPackManifest", (Object)depHandler.project((Map)manifestDependency));
                needToRegisterAssetPackTasks = true;
                continue;
            }
            notFound.add(assetPack);
        }
        if (needToRegisterAssetPackTasks) {
            FileCollection assetPackManifest = assetPackManifestConfiguration.getIncoming().getFiles();
            FileCollection assetFiles = assetPackFilesConfiguration.getIncoming().getFiles();
            this.taskFactory.register(new ProcessAssetPackManifestTask.CreationAction(variantScope.getVariantData().getPublicVariantPropertiesApi(), assetPackManifest, assetPacks.stream().map(assetPackName -> assetPackName.replace(":", File.separator)).collect(Collectors.toSet())));
            this.taskFactory.register(new LinkManifestForAssetPackTask.CreationAction(variantScope));
            this.taskFactory.register(new AssetPackPreBundleTask.CreationAction(variantScope, assetFiles));
        }
        if (!notFound.isEmpty()) {
            this.globalScope.getDslScope().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Unable to find matching projects for Asset Packs: " + notFound);
        }
    }
}

