/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.api.artifact.BuildArtifactSpec;
import com.android.build.gradle.internal.core.VariantBuilder;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dependency.AndroidXDependencySubstitution;
import com.android.build.gradle.internal.dependency.DesugarLibConfiguration;
import com.android.build.gradle.internal.dependency.DexingArtifactConfiguration;
import com.android.build.gradle.internal.dependency.DexingOutputSplitTransformKt;
import com.android.build.gradle.internal.dependency.DexingTransformKt;
import com.android.build.gradle.internal.dependency.FilterShrinkerRulesTransform;
import com.android.build.gradle.internal.dependency.L8DexDesugarLibTransformKt;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dependency.VersionedCodeShrinker;
import com.android.build.gradle.internal.dsl.ActionableVariantObjectOperationsExecutor;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.SingleArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.scope.VariantScopeImpl;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.build.gradle.internal.variant.DimensionCombinator;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SigningOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.CodeShrinker;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public class VariantManager {
    private static final String MULTIDEX_VERSION = "1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.2";
    protected static final String ANDROIDX_MULTIDEX_MULTIDEX = AndroidXDependencySubstitution.getAndroidXMappings().get("com.android.support:multidex");
    protected static final String ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION = AndroidXDependencySubstitution.getAndroidXMappings().get("com.android.support:multidex-instrumentation");
    private final Project project;
    private final ProjectOptions projectOptions;
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final VariantInputModel variantInputModel;
    private final TaskManager taskManager;
    private final SourceSetManager sourceSetManager;
    private final Recorder recorder;
    private final VariantFilter variantFilter;
    private final List<VariantScope> variantScopes;
    private final Map<File, ManifestAttributeSupplier> manifestParserMap;
    protected final GlobalScope globalScope;
    private final SigningConfig signingOverride;
    private boolean hasCreatedTasks = false;
    public static final Attribute<String> SHRINKER_ATTR = Attribute.of((String)"codeShrinker", String.class);

    public VariantManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, BaseExtension extension, VariantFactory variantFactory, VariantInputModel variantInputModel, TaskManager taskManager, SourceSetManager sourceSetManager, Recorder recorder) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.project = project2;
        this.projectOptions = projectOptions;
        this.variantFactory = variantFactory;
        this.variantInputModel = variantInputModel;
        this.taskManager = taskManager;
        this.sourceSetManager = sourceSetManager;
        this.recorder = recorder;
        this.signingOverride = this.createSigningOverride();
        this.variantFilter = new VariantFilter(new ReadOnlyObjectProvider());
        this.variantScopes = Lists.newArrayList();
        this.manifestParserMap = Maps.newHashMap();
    }

    private void addVariant(BaseVariantData variantData) {
        this.variantScopes.add(variantData.getScope());
    }

    public List<VariantScope> getVariantScopes() {
        return this.variantScopes;
    }

    public List<VariantScope> createVariantsAndTasks() {
        this.variantFactory.validateModel(this.variantInputModel);
        this.variantFactory.preVariantWork(this.project);
        if (this.variantScopes.isEmpty()) {
            this.computeVariants();
        }
        this.taskManager.createTopLevelTestTasks(!this.variantInputModel.getProductFlavors().isEmpty());
        for (VariantScope variantScope : this.variantScopes) {
            this.createTasksForVariant(variantScope);
        }
        this.taskManager.createReportTasks(this.variantScopes);
        return this.variantScopes;
    }

    private void createTasksForVariant(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType variantType = variantData.getType();
        VariantDslInfo variantDslInfo = variantScope.getVariantDslInfo();
        VariantSources variantSources = variantScope.getVariantSources();
        this.taskManager.createAssembleTask(variantData);
        if (variantType.isBaseModule()) {
            this.taskManager.createBundleTask(variantData);
        }
        if (variantType.isTestComponent()) {
            BuildTypeData buildTypeData;
            DefaultAndroidSourceSet buildTypeConfigurationProvider;
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            List<ProductFlavor> testProductFlavors = variantDslInfo.getProductFlavorList();
            ArrayList testVariantSourceSets = Lists.newArrayListWithExpectedSize((int)(4 + testProductFlavors.size()));
            if (!testProductFlavors.isEmpty()) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantSources.getVariantSourceProvider());
            }
            if ((buildTypeConfigurationProvider = (buildTypeData = this.variantInputModel.getBuildTypes().get(variantDslInfo.getComponentIdentity().getBuildType())).getTestSourceSet(variantType)) != null) {
                testVariantSourceSets.add(buildTypeConfigurationProvider);
            }
            if (testProductFlavors.size() > 1) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantSources.getMultiFlavorSourceProvider());
            }
            for (ProductFlavor productFlavor : testProductFlavors) {
                testVariantSourceSets.add(this.variantInputModel.getProductFlavors().get(productFlavor.getName()).getTestSourceSet(variantType));
            }
            testVariantSourceSets.add(this.variantInputModel.getDefaultConfig().getTestSourceSet(variantType));
            VariantDependencies.Builder builder = VariantDependencies.builder(this.project, variantScope.getGlobalScope().getDslScope().getIssueReporter(), variantDslInfo).addSourceSets(testVariantSourceSets).setFlavorSelection(this.getFlavorSelection(variantDslInfo)).setTestedVariantScope(testedVariantData.getScope());
            VariantDependencies variantDep = builder.build(variantScope);
            variantData.setVariantDependency(variantDep);
            if (testedVariantData.getVariantDslInfo().getRenderscriptSupportModeEnabled()) {
                this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()}));
            }
            if (variantType.isApk()) {
                if (variantDslInfo.isLegacyMultiDexMode()) {
                    String multiDexInstrumentationDep = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION : COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION;
                    this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)multiDexInstrumentationDep);
                    this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)multiDexInstrumentationDep);
                }
                this.taskManager.createAndroidTestVariantTasks((TestVariantData)variantData, this.variantScopes.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList()));
            } else {
                this.taskManager.createUnitTestVariantTasks((TestVariantData)variantData);
            }
        } else {
            this.taskManager.createTasksForVariantScope(variantScope, this.variantScopes.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList()));
        }
    }

    public void publishBuildArtifacts(VariantScope variantScope) {
        BuildArtifactsHolder buildArtifactsHolder = variantScope.getArtifacts();
        for (PublishingSpecs.OutputSpec outputSpec : variantScope.getPublishingSpec().getOutputs()) {
            SingleArtifactType<? extends FileSystemLocation> buildArtifactType = outputSpec.getOutputType();
            if (BuildArtifactSpec.Companion.has(buildArtifactType) && BuildArtifactSpec.Companion.get(buildArtifactType).getAppendable()) {
                throw new RuntimeException(String.format("Appendable ArtifactType '%1s' cannot be published.", buildArtifactType.name()));
            }
            if (buildArtifactsHolder.hasFinalProduct(buildArtifactType)) {
                Provider artifact = buildArtifactsHolder.getFinalProduct(buildArtifactType);
                variantScope.publishIntermediateArtifact(artifact, outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
                continue;
            }
            if (buildArtifactType != InternalArtifactType.ALL_CLASSES.INSTANCE) continue;
            Provider<FileCollection> allClasses = buildArtifactsHolder.getFinalProductAsFileCollection(InternalArtifactType.ALL_CLASSES.INSTANCE);
            Provider file = allClasses.map(FileCollection::getSingleFile);
            variantScope.publishIntermediateArtifact((Provider<?>)file, outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
        }
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorSelection(VariantDslInfo variantDslInfo) {
        ObjectFactory factory2 = this.project.getObjects();
        return variantDslInfo.getMissingDimensionStrategies().entrySet().stream().collect(Collectors.toMap(entry -> Attribute.of((String)((String)entry.getKey()), ProductFlavorAttr.class), entry -> (ProductFlavorAttr)factory2.named(ProductFlavorAttr.class, ((AbstractProductFlavor.DimensionRequest)entry.getValue()).getRequested())));
    }

    private void configureVariantArtifactTransforms(Collection<VariantScope> variantScopes) {
        DependencyHandler dependencies = this.project.getDependencies();
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DEXING_ARTIFACT_TRANSFORM)) {
            for (DexingArtifactConfiguration dexingArtifactConfiguration : DexingTransformKt.getDexingArtifactConfigurations(variantScopes)) {
                dexingArtifactConfiguration.registerTransform(this.globalScope.getProject().getName(), dependencies, this.globalScope.getBootClasspath(), DesugarLibUtils.getDesugarLibConfig(this.globalScope.getProject()), SyncOptions.getErrorFormatMode(this.globalScope.getProjectOptions()), this.projectOptions.get(BooleanOption.ENABLE_INCREMENTAL_DEXING_V2));
            }
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_PROGUARD_RULES_EXTRACTION)) {
            Set shrinkers = variantScopes.stream().map(VariantScope::getCodeShrinker).filter(Objects::nonNull).collect(Collectors.toSet());
            for (CodeShrinker shrinker : shrinkers) {
                dependencies.registerTransform(FilterShrinkerRulesTransform.class, reg -> {
                    reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES.getType());
                    reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.FILTERED_PROGUARD_RULES.getType());
                    reg.getFrom().attribute(SHRINKER_ATTR, (Object)shrinker.toString());
                    reg.getTo().attribute(SHRINKER_ATTR, (Object)shrinker.toString());
                    reg.parameters(params -> {
                        params.getShrinker().set((Object)VersionedCodeShrinker.of(shrinker));
                        params.getProjectName().set((Object)this.project.getName());
                    });
                });
            }
        }
        for (DesugarLibConfiguration desugarLibConfiguration : L8DexDesugarLibTransformKt.getDesugarLibConfigurations(variantScopes)) {
            desugarLibConfiguration.registerTransform(dependencies);
        }
        DexingOutputSplitTransformKt.registerDexingOutputSplitTransform(dependencies);
    }

    public static String getModifiedName(String name2) {
        return "____" + name2;
    }

    @VisibleForTesting
    public void computeVariants() {
        List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
        DimensionCombinator computer = new DimensionCombinator(this.variantInputModel, this.globalScope.getDslScope().getIssueReporter(), this.variantFactory.getVariantType(), flavorDimensionList);
        List<DimensionCombination> variants = computer.computeVariants();
        BuildTypeData testBuildTypeData = this.getTestBuildTypeData();
        for (DimensionCombination variant2 : variants) {
            this.createVariantsFromConfiguration(variant2, testBuildTypeData);
        }
        this.configureVariantArtifactTransforms(this.variantScopes);
    }

    private BuildTypeData getTestBuildTypeData() {
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig) {
            TestedAndroidConfig testedExtension = (TestedAndroidConfig)((Object)this.extension);
            testBuildTypeData = this.variantInputModel.getBuildTypes().get(testedExtension.getTestBuildType());
            if (testBuildTypeData == null) {
                throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
            }
        }
        return testBuildTypeData;
    }

    private BaseVariantData createVariant(DimensionCombination dimensionCombination, BuildTypeData buildTypeData, List<ProductFlavorData<ProductFlavor>> productFlavorDataList, VariantType variantType) {
        ProductFlavorData<DefaultConfig> defaultConfig = this.variantInputModel.getDefaultConfig();
        DefaultAndroidSourceSet defaultConfigSourceProvider = defaultConfig.getSourceSet();
        VariantBuilder variantBuilder = VariantBuilder.getBuilder(dimensionCombination, variantType, defaultConfig.getProductFlavor(), defaultConfigSourceProvider, buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.signingOverride, this.getParser(defaultConfigSourceProvider.getManifestFile(), variantType.getRequiresManifest()), this.globalScope.getProjectOptions(), this.globalScope.getDslScope().getIssueReporter(), this::canParseManifest);
        for (ProductFlavorData<ProductFlavor> productFlavorData : productFlavorDataList) {
            variantBuilder.addProductFlavor(productFlavorData.getProductFlavor(), productFlavorData.getSourceSet());
        }
        VariantDslInfoImpl variantDslInfo = variantBuilder.createVariantDslInfo();
        VariantImpl variant2 = this.variantFactory.createVariantObject(variantDslInfo.getComponentIdentity(), variantDslInfo);
        ActionableVariantObjectOperationsExecutor commonExtension = (ActionableVariantObjectOperationsExecutor)((Object)this.extension);
        commonExtension.executeVariantOperations(variant2);
        if (!variant2.getEnabled()) {
            return null;
        }
        VariantManager.createCompoundSourceSets(productFlavorDataList, variantBuilder, this.sourceSetManager);
        VariantSources variantSources = variantBuilder.createVariantSources();
        if (!buildTypeData.getBuildType().isDebuggable() && variantType.isApk() && !variantDslInfo.getVariantType().isForTesting()) {
            ProcessProfileWriter.get().recordApplicationId(variantDslInfo::getApplicationId);
        }
        ArrayList variantSourceSets = Lists.newArrayListWithExpectedSize((int)(productFlavorDataList.size() + 4));
        if (!productFlavorDataList.isEmpty()) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantSources.getVariantSourceProvider());
        }
        variantSourceSets.add(buildTypeData.getSourceSet());
        if (productFlavorDataList.size() > 1) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantSources.getMultiFlavorSourceProvider());
        }
        for (ProductFlavorData<ProductFlavor> productFlavor : productFlavorDataList) {
            variantSourceSets.add(productFlavor.getSourceSet());
        }
        variantSourceSets.add(this.variantInputModel.getDefaultConfig().getSourceSet());
        Project project2 = this.globalScope.getProject();
        VariantScopeImpl variantScope = new VariantScopeImpl(this.globalScope, new TransformManager(this.globalScope.getProject(), this.globalScope.getDslScope().getIssueReporter(), this.recorder), variantDslInfo, variantType);
        VariantPropertiesImpl variantProperties = this.variantFactory.createVariantPropertiesObject(variantDslInfo.getComponentIdentity(), variantScope);
        BaseVariantData variantData = this.variantFactory.createVariantData(variantScope, variantDslInfo, variant2, variantProperties, variantSources, this.taskManager);
        variantScope.setVariantData(variantData);
        VariantDependencies.Builder builder = VariantDependencies.builder(project2, variantScope.getGlobalScope().getDslScope().getIssueReporter(), variantDslInfo).setFlavorSelection(this.getFlavorSelection(variantDslInfo)).addSourceSets(variantSourceSets);
        if (this.extension instanceof BaseAppModuleExtension) {
            builder.setFeatureList(((BaseAppModuleExtension)this.extension).getDynamicFeatures());
        }
        VariantDependencies variantDep = builder.build(variantScope);
        variantData.setVariantDependency(variantDep);
        if (variantDslInfo.isLegacyMultiDexMode() && variantDslInfo.getVariantType().isApk()) {
            String multiDexDependency = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX : COM_ANDROID_SUPPORT_MULTIDEX;
            project2.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)multiDexDependency);
            project2.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)multiDexDependency);
        }
        if (variantDslInfo.getRenderscriptSupportModeEnabled()) {
            ConfigurableFileCollection fileCollection2 = project2.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()});
            project2.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)fileCollection2);
            if (variantType.isApk() && !variantType.isForTesting()) {
                project2.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)fileCollection2);
            }
        }
        commonExtension.executeVariantPropertiesOperations(variantProperties);
        variant2.executePropertiesActions(variantProperties);
        return variantData;
    }

    private static void createCompoundSourceSets(List<ProductFlavorData<ProductFlavor>> productFlavorList, VariantBuilder variantBuilder, SourceSetManager sourceSetManager) {
        VariantType variantType = variantBuilder.getVariantType();
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantBuilder.computeSourceSetName(variantBuilder.getName(), variantType), variantType.isTestComponent());
            variantBuilder.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantBuilder.computeSourceSetName(variantBuilder.getFlavorName(), variantType), variantType.isTestComponent());
            variantBuilder.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    public TestVariantData createTestComponents(DimensionCombination dimensionCombination, BuildTypeData buildTypeData, List<ProductFlavorData<ProductFlavor>> productFlavorDataList, BaseVariantData testedVariantData, VariantType type) {
        ComponentPropertiesImpl componentProperties;
        ComponentImpl component;
        DefaultAndroidSourceSet testSourceSet = this.variantInputModel.getDefaultConfig().getTestSourceSet(type);
        VariantBuilder variantBuilder = VariantBuilder.getBuilder(dimensionCombination, type, this.variantInputModel.getDefaultConfig().getProductFlavor(), testSourceSet, buildTypeData.getBuildType(), buildTypeData.getTestSourceSet(type), this.signingOverride, testSourceSet != null ? this.getParser(testSourceSet.getManifestFile(), type.getRequiresManifest()) : null, this.globalScope.getProjectOptions(), this.globalScope.getDslScope().getIssueReporter(), this::canParseManifest);
        VariantDslInfoImpl testedVariantDslInfo = (VariantDslInfoImpl)testedVariantData.getVariantDslInfo();
        variantBuilder.setTestedVariant(testedVariantDslInfo);
        List<ProductFlavor> productFlavorList = testedVariantDslInfo.getProductFlavorList();
        Map<String, ProductFlavorData<ProductFlavor>> productFlavors = this.variantInputModel.getProductFlavors();
        for (ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<ProductFlavor> data = productFlavors.get(productFlavor.getName());
            variantBuilder.addProductFlavor(data.getProductFlavor(), data.getTestSourceSet(type));
        }
        VariantDslInfoImpl variantDslInfo = variantBuilder.createVariantDslInfo();
        VariantImpl testedVariant = (VariantImpl)testedVariantData.getPublicVariantApi();
        if (type.isApk()) {
            AndroidTestImpl androidTestVariant = this.variantFactory.createAndroidTestObject(variantDslInfo.getComponentIdentity(), variantDslInfo);
            testedVariant.executeAndroidTestActions(androidTestVariant);
            component = androidTestVariant;
        } else {
            UnitTestImpl unitTestVariant = this.variantFactory.createUnitTestObject(variantDslInfo.getComponentIdentity(), variantDslInfo);
            testedVariant.executeUnitTestActions(unitTestVariant);
            component = unitTestVariant;
        }
        if (!component.getEnabled()) {
            return null;
        }
        VariantManager.createCompoundSourceSets(productFlavorDataList, variantBuilder, this.sourceSetManager);
        VariantScopeImpl variantScope = new VariantScopeImpl(this.globalScope, new TransformManager(this.globalScope.getProject(), this.globalScope.getDslScope().getIssueReporter(), this.recorder), variantDslInfo, type);
        if (type.isApk()) {
            AndroidTestPropertiesImpl androidTestProperties = this.variantFactory.createAndroidTestProperties(variantDslInfo.getComponentIdentity(), variantScope);
            component.executePropertiesActions(androidTestProperties);
            componentProperties = androidTestProperties;
        } else {
            UnitTestPropertiesImpl unitTestProperties = this.variantFactory.createUnitTestProperties(variantDslInfo.getComponentIdentity(), variantScope);
            component.executePropertiesActions(unitTestProperties);
            componentProperties = unitTestProperties;
        }
        TestVariantData testVariantData = new TestVariantData(this.globalScope, this.taskManager, variantScope, variantDslInfo, component, componentProperties, variantBuilder.createVariantSources(), (TestedVariantData)((Object)testedVariantData));
        variantScope.setVariantData(testVariantData);
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantsFromConfiguration(DimensionCombination dimensionCombination, BuildTypeData testBuildTypeData) {
        BaseVariantData variantData;
        VariantType variantType = this.variantFactory.getVariantType();
        Action<com.android.build.api.variant.VariantFilter> variantFilterAction = this.extension.getVariantFilter();
        DefaultConfig defaultConfig = this.variantInputModel.getDefaultConfig().getProductFlavor();
        BuildTypeData buildTypeData = this.variantInputModel.getBuildTypes().get(dimensionCombination.getBuildType());
        BuildType buildType = buildTypeData.getBuildType();
        List<ProductFlavorData<ProductFlavor>> productFlavorDataList = dimensionCombination.getProductFlavors().stream().map(it -> this.variantInputModel.getProductFlavors().get(it.getSecond())).collect(Collectors.toList());
        List productFlavorList = productFlavorDataList.stream().map(ProductFlavorData::getProductFlavor).collect(Collectors.toList());
        boolean ignore = false;
        if (variantFilterAction != null) {
            this.variantFilter.reset(dimensionCombination, defaultConfig, buildType, variantType, productFlavorList);
            try {
                variantFilterAction.execute((Object)this.variantFilter);
            }
            catch (Throwable t) {
                throw new ExternalApiUsageException(t);
            }
            ignore = this.variantFilter.getIgnore();
        }
        if (!ignore && (variantData = this.createVariant(dimensionCombination, buildTypeData, productFlavorDataList, variantType)) != null) {
            VariantScope.Java8LangSupport supportType;
            this.addVariant(variantData);
            VariantDslInfo variantDslInfo = variantData.getVariantDslInfo();
            VariantScope variantScope = variantData.getScope();
            int minSdkVersion = variantDslInfo.getMinSdkVersion().getApiLevel();
            int targetSdkVersion = variantDslInfo.getTargetSdkVersion().getApiLevel();
            if (minSdkVersion > 0 && targetSdkVersion > 0 && minSdkVersion > targetSdkVersion) {
                this.globalScope.getDslScope().getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, String.format(Locale.US, "minSdkVersion (%d) is greater than targetSdkVersion (%d) for variant \"%s\". Please change the values such that minSdkVersion is less than or equal to targetSdkVersion.", minSdkVersion, targetSdkVersion, variantData.getName()));
            }
            GradleBuildVariant.Builder profileBuilder = ProcessProfileWriter.getOrCreateVariant((String)this.project.getPath(), (String)variantData.getName()).setIsDebug(buildType.isDebuggable()).setMinSdkVersion(AnalyticsUtil.toProto(variantDslInfo.getMinSdkVersion())).setMinifyEnabled(variantScope.getCodeShrinker() != null).setUseMultidex(variantDslInfo.isMultiDexEnabled()).setUseLegacyMultidex(variantDslInfo.isLegacyMultiDexMode()).setVariantType(variantData.getType().getAnalyticsVariantType()).setDexBuilder(AnalyticsUtil.toProto(variantScope.getDexer())).setDexMerger(AnalyticsUtil.toProto(variantScope.getDexMerger())).setCoreLibraryDesugaringEnabled(variantScope.isCoreLibraryDesugaringEnabled()).setTestExecution(AnalyticsUtil.toProto(this.globalScope.getExtension().getTestOptions().getExecutionEnum()));
            if (variantScope.getCodeShrinker() != null) {
                profileBuilder.setCodeShrinker(AnalyticsUtil.toProto(variantScope.getCodeShrinker()));
            }
            if (variantDslInfo.getTargetSdkVersion().getApiLevel() > 0) {
                profileBuilder.setTargetSdkVersion(AnalyticsUtil.toProto(variantDslInfo.getTargetSdkVersion()));
            }
            if (variantDslInfo.getMaxSdkVersion() != null) {
                profileBuilder.setMaxSdkVersion(ApiVersion.newBuilder().setApiLevel((long)variantDslInfo.getMaxSdkVersion().intValue()));
            }
            if ((supportType = variantData.getScope().getJava8LangSupportType()) != VariantScope.Java8LangSupport.INVALID && supportType != VariantScope.Java8LangSupport.UNUSED) {
                profileBuilder.setJava8LangSupport(AnalyticsUtil.toProto(supportType));
            }
            if (this.variantFactory.hasTestScope()) {
                TestVariantData unitTestVariantData;
                TestVariantData androidTestVariantData;
                if (buildTypeData == testBuildTypeData && (androidTestVariantData = this.createTestComponents(dimensionCombination, buildTypeData, productFlavorDataList, variantData, (VariantType)VariantTypeImpl.ANDROID_TEST)) != null) {
                    this.addVariant(androidTestVariantData);
                }
                if ((unitTestVariantData = this.createTestComponents(dimensionCombination, buildTypeData, productFlavorDataList, variantData, (VariantType)VariantTypeImpl.UNIT_TEST)) != null) {
                    this.addVariant(unitTestVariantData);
                }
            }
        }
    }

    private SigningConfig createSigningOverride() {
        SigningOptions signingOptions = SigningOptions.readSigningOptions(this.projectOptions);
        if (signingOptions != null) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            signingConfigDsl.setStoreFile(new File(signingOptions.getStoreFile()));
            signingConfigDsl.setStorePassword(signingOptions.getStorePassword());
            signingConfigDsl.setKeyAlias(signingOptions.getKeyAlias());
            signingConfigDsl.setKeyPassword(signingOptions.getKeyPassword());
            if (signingOptions.getStoreType() != null) {
                signingConfigDsl.setStoreType(signingOptions.getStoreType());
            }
            if (signingOptions.getV1Enabled() != null) {
                signingConfigDsl.setV1SigningEnabled(signingOptions.getV1Enabled());
            }
            if (signingOptions.getV2Enabled() != null) {
                signingConfigDsl.setV2SigningEnabled(signingOptions.getV2Enabled());
            }
            return signingConfigDsl;
        }
        return null;
    }

    private ManifestAttributeSupplier getParser(File file, boolean isManifestFileRequired) {
        return this.manifestParserMap.computeIfAbsent(file, f -> new DefaultManifestParser(f, this::canParseManifest, isManifestFileRequired, this.globalScope.getDslScope().getIssueReporter()));
    }

    private boolean canParseManifest() {
        return this.hasCreatedTasks || !this.projectOptions.get(BooleanOption.DISABLE_EARLY_MANIFEST_PARSING);
    }

    public void setHasCreatedTasks(boolean hasCreatedTasks) {
        this.hasCreatedTasks = hasCreatedTasks;
    }
}

