/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo$WhenMappings;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020 2\u0006\u0010$\u001a\u00020\tH\u0016J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tH\u0016J\u0010\u0010.\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0014J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\tH\u0002J\u0010\u00100\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\tH\u0002J\n\u00101\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fRN\u0010\u000f\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00118DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\"\u0010\u001d\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\f\u00a8\u00062"}, d2={"Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "rootDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "abiInfoList", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "default32BitsAbis", "Lcom/android/build/gradle/internal/core/Abi;", "kotlin.jvm.PlatformType", "getDefault32BitsAbis", "()Ljava/util/List;", "defaultAbis", "getDefaultAbis", "defaultToolchainVersions", "Ljava/util/HashMap;", "", "hostTag", "getHostTag", "()Ljava/lang/String;", "hostTag$delegate", "Lkotlin/Lazy;", "platformConfigurator", "Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "getRootDirectory", "()Ljava/io/File;", "supported32BitsAbis", "getSupported32BitsAbis", "supportedAbis", "getSupportedAbis", "supportedStls", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "findSuitablePlatformVersion", "", "abi", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getDefaultToolchainVersion", "getStlSharedObjectFile", "stl", "getStripExecutable", "getToolchainAbi", "getToolchainPath", "getToolchainPrefix", "validate", "gradle"})
public class DefaultNdkInfo
implements NdkInfo {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final PlatformConfigurator platformConfigurator;
    private final List<AbiInfo> abiInfoList;
    private final HashMap<Abi, String> defaultToolchainVersions;
    @NotNull
    private final Lazy hostTag$delegate;
    @NotNull
    private final List<Stl> supportedStls;
    @NotNull
    private final File rootDirectory;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DefaultNdkInfo.class), "hostTag", "getHostTag()Ljava/lang/String;"))};
    }

    @Override
    public int findSuitablePlatformVersion(@NotNull String abi, @Nullable AndroidVersion androidVersion) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        return this.platformConfigurator.findSuitablePlatformVersion(abi, androidVersion);
    }

    private final String getToolchainPrefix(Abi abi) {
        String string = abi.getGccToolchainPrefix();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.gccToolchainPrefix");
        return string;
    }

    @NotNull
    protected final String getHostTag() {
        Lazy lazy = this.hostTag$delegate;
        DefaultNdkInfo defaultNdkInfo = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final File getToolchainPath(Abi abi) {
        Abi toolchainAbi = this.getToolchainAbi(abi);
        String string = this.getDefaultToolchainVersion(toolchainAbi);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String version = charSequence.length() == 0 ? "" : '-' + it;
        File prebuiltFolder = FilesKt.resolve((File)this.rootDirectory, (String)("toolchains/" + this.getToolchainPrefix(toolchainAbi) + version + "/prebuilt/" + this.getHostTag()));
        if (!prebuiltFolder.isDirectory()) {
            throw (Throwable)new InvalidUserDataException("Toolchain directory does not exist: " + prebuiltFolder);
        }
        return prebuiltFolder;
    }

    @NotNull
    protected Abi getToolchainAbi(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        return abi;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        Abi toolchainAbi = this.getToolchainAbi(abi);
        File file = FileUtils.join((File)this.getToolchainPath(toolchainAbi), (String[])new String[]{"bin", toolchainAbi.getGccExecutablePrefix() + "-strip"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026efix + \"-strip\"\n        )");
        return file;
    }

    private final String getDefaultToolchainVersion(Abi abi) {
        File[] toolchainsForAbi2;
        String toolchainPrefix;
        Abi toolchainAbi;
        block10: {
            block9: {
                toolchainAbi = this.getToolchainAbi(abi);
                String defaultVersion = this.defaultToolchainVersions.get((Object)toolchainAbi);
                if (defaultVersion != null) {
                    return defaultVersion;
                }
                File toolchains = new File(this.rootDirectory, "toolchains");
                toolchainPrefix = this.getToolchainPrefix(toolchainAbi);
                toolchainsForAbi2 = toolchains.listFiles(new FilenameFilter(toolchainPrefix){
                    final /* synthetic */ String $toolchainPrefix;

                    public final boolean accept(File $noName_0, String filename) {
                        String string = filename;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filename");
                        return StringsKt.startsWith$default((String)string, (String)this.$toolchainPrefix, (boolean)false, (int)2, null);
                    }
                    {
                        this.$toolchainPrefix = string;
                    }
                });
                if (toolchainsForAbi2 == null) break block9;
                File[] fileArray = toolchainsForAbi2;
                boolean bl = false;
                if (!(fileArray.length == 0)) break block10;
            }
            throw (Throwable)new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        File[] fileArray = toolchainsForAbi2;
        int n = fileArray.length;
        for (int j = 0; j < n; ++j) {
            File toolchainFolder;
            File file = toolchainFolder = fileArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toolchainFolder");
            String folderName = file.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    String string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)folderName, (String)"folderName");
                    int n2 = toolchainPrefix.length() + 1;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    versionString = string3;
                    Revision revision2 = Revision.parseRevision((String)versionString);
                    Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"Revision.parseRevision(versionString)");
                    revision = revision2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        HashMap<Abi, String> hashMap = this.defaultToolchainVersions;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"defaultToolchainVersions");
        ((Map)hashMap).put(toolchainAbi, bestVersionString);
        return bestVersionString;
    }

    @NotNull
    public List<Abi> getDefault32BitsAbis() {
        Stream stream = this.abiInfoList.stream().filter(default32BitsAbis.1.INSTANCE).map(default32BitsAbis.2.INSTANCE).filter(default32BitsAbis.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026> !abi.supports64Bits() }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Abi> getDefaultAbis() {
        Stream stream = this.abiInfoList.stream().filter(defaultAbis.1.INSTANCE).map(defaultAbis.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026      .map<Abi>{ it.abi }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Abi> getSupported32BitsAbis() {
        Stream stream = this.abiInfoList.stream().map(supported32BitsAbis.1.INSTANCE).filter(supported32BitsAbis.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026> !abi.supports64Bits() }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Abi> getSupportedAbis() {
        Stream stream = this.abiInfoList.stream().map(supportedAbis.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"abiInfoList\n            \u2026           .map{ it.abi }");
        return StreamsKt.toList(stream);
    }

    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem2) {
        Stl stl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)buildSystem2), (String)"buildSystem");
        switch (DefaultNdkInfo$WhenMappings.$EnumSwitchMapping$0[buildSystem2.ordinal()]) {
            case 1: {
                stl = Stl.GNUSTL_STATIC;
                break;
            }
            case 2: {
                stl = Stl.SYSTEM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stl;
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl, @NotNull Abi abi) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)stl), (String)"stl");
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        switch (DefaultNdkInfo$WhenMappings.$EnumSwitchMapping$1[stl.ordinal()]) {
            case 1: {
                string = "sources/cxx-stl/llvm-libc++";
                break;
            }
            case 2: {
                string = "sources/cxx-stl/gnu-libstdc++/4.9";
                break;
            }
            case 3: {
                string = "sources/cxx-stl/stlport";
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected STL for packaging: " + (Object)((Object)stl));
            }
        }
        File stlBasePath = FilesKt.resolve((File)this.rootDirectory, (String)string);
        File file = FilesKt.resolve((File)stlBasePath, (String)("libs/" + abi.getTag() + '/' + stl.getLibraryName()));
        Preconditions.checkState((boolean)file.isFile(), (String)("Expected NDK STL shared object file at " + file), (Object[])new Object[0]);
        return file;
    }

    @Override
    @Nullable
    public String validate() {
        File platformsDir = FilesKt.resolve((File)this.rootDirectory, (String)"platforms");
        if (!platformsDir.isDirectory()) {
            return platformsDir + " is not a directory.";
        }
        File toolchainsDir = FilesKt.resolve((File)this.rootDirectory, (String)"toolchains");
        if (!toolchainsDir.isDirectory()) {
            return toolchainsDir + " is not a directory.";
        }
        return null;
    }

    @NotNull
    protected final File getRootDirectory() {
        return this.rootDirectory;
    }

    public DefaultNdkInfo(@NotNull File rootDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.platformConfigurator = new PlatformConfigurator(this.rootDirectory);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(this.rootDirectory)).getAbiInfoList();
        this.defaultToolchainVersions = Maps.newHashMap();
        this.hostTag$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultNdkInfo this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                Iterator<T> iterator;
                List checkDirs;
                block5: {
                    void $this$mapTo$iv$iv;
                    String string = System.getProperty("os.name");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
                    String string2 = string;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                    Locale locale2 = locale;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase(locale2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                    String osName = string4;
                    String osType = StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null) ? "windows" : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) ? "darwin" : "linux");
                    List checkTags = CollectionsKt.mutableListOf((Object[])new String[]{osType + "-x86_64"});
                    if (Intrinsics.areEqual((Object)osType, (Object)"windows")) {
                        checkTags.add("windows");
                    }
                    File prebuiltBase = FilesKt.resolve((File)this.this$0.getRootDirectory(), (String)"prebuilt");
                    Iterable $this$map$iv = checkTags;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string5 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        File file = FilesKt.resolve((File)prebuiltBase, (String)it);
                        collection.add(file);
                    }
                    checkDirs = (List)destination$iv$iv;
                    Iterable iterable2 = checkTags;
                    boolean bl3 = false;
                    iterable = iterable2;
                    boolean bl4 = false;
                    for (Iterator<T> iterator2 : iterable) {
                        String it = (String)((Object)iterator2);
                        boolean bl5 = false;
                        if (!FilesKt.resolve((File)prebuiltBase, (String)it).isDirectory()) continue;
                        iterator = iterator2;
                        break block5;
                    }
                    iterator = null;
                }
                String string = (String)((Object)iterator);
                if (string == null) {
                    throw (Throwable)new InvalidUserDataException("Could not determine NDK host architecture. None of the following directories " + "exist: " + CollectionsKt.joinToString$default((Iterable)checkDirs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                }
                return string;
            }
            {
                this.this$0 = defaultNdkInfo;
                super(0);
            }
        }));
        this.supportedStls = ArraysKt.toList((Object[])Stl.values());
    }

    @Override
    @NotNull
    public Map<Abi, File> getStlSharedObjectFiles(@NotNull Stl stl, @NotNull Collection<? extends Abi> abis) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stl), (String)"stl");
        Intrinsics.checkParameterIsNotNull(abis, (String)"abis");
        return NdkInfo.DefaultImpls.getStlSharedObjectFiles(this, stl, abis);
    }
}

