/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import android.databinding.tool.DataBindingBuilder;
import com.android.Version;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.impl.GradleProperty;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.ApiObjectFactory;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.BuildCacheUtils;
import com.android.build.gradle.internal.ClasspathVerifier;
import com.android.build.gradle.internal.DependencyConfigurator;
import com.android.build.gradle.internal.DependencyResolutionChecks;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NonFinalPluginExpiry;
import com.android.build.gradle.internal.PluginInitializer;
import com.android.build.gradle.internal.SdkComponents;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.attribution.AttributionListenerInitializer;
import com.android.build.gradle.internal.crash.CrashReporting;
import com.android.build.gradle.internal.dependency.ConstraintHandler;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.BuildTypeFactory;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.DslVariableFactory;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavorFactory;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfigFactory;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.NativeModelBuilder;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.plugins.DynamicFeaturePlugin;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProfileAgent;
import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.internal.scope.BuildFeatureValuesImpl;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Workers;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantInputModelImpl;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.internal.variant.VariantModelImpl;
import com.android.build.gradle.internal.variant2.DslScopeImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.builder.errors.IssueReporter;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.Main;
import com.android.sdklib.AndroidTargetHash;
import com.android.tools.lint.gradle.api.ToolingRegistryProvider;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.slf4j.Logger;

public abstract class BasePlugin
implements Plugin<Project>,
ToolingRegistryProvider {
    private BaseExtension extension;
    private VariantManager variantManager;
    private VariantInputModelImpl variantInputModel;
    protected TaskManager taskManager;
    protected Project project;
    protected ProjectOptions projectOptions;
    GlobalScope globalScope;
    protected SyncIssueReporterImpl syncIssueHandler;
    private DataBindingBuilder dataBindingBuilder;
    private VariantFactory variantFactory;
    private SourceSetManager sourceSetManager;
    private final ToolingModelBuilderRegistry registry;
    private final SoftwareComponentFactory componentFactory;
    private LoggerWrapper loggerWrapper;
    protected ExtraModelInfo extraModelInfo;
    private String creator;
    private Recorder threadRecorder;
    private boolean hasCreatedTasks = false;

    public BasePlugin(ToolingModelBuilderRegistry registry, SoftwareComponentFactory componentFactory) {
        ClasspathVerifier.checkClasspathSanity();
        this.registry = registry;
        this.componentFactory = componentFactory;
        this.creator = "Android Gradle " + Version.ANDROID_GRADLE_PLUGIN_VERSION;
        NonFinalPluginExpiry.verifyRetirementAge();
    }

    protected abstract BaseExtension createExtension(DslScope var1, ProjectOptions var2, GlobalScope var3, NamedDomainObjectContainer<BuildType> var4, DefaultConfig var5, NamedDomainObjectContainer<ProductFlavor> var6, NamedDomainObjectContainer<SigningConfig> var7, NamedDomainObjectContainer<BaseVariantOutput> var8, SourceSetManager var9, ExtraModelInfo var10);

    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected abstract VariantFactory createVariantFactory(GlobalScope var1);

    protected abstract TaskManager createTaskManager(GlobalScope var1, Project var2, ProjectOptions var3, DataBindingBuilder var4, BaseExtension var5, VariantFactory var6, ToolingModelBuilderRegistry var7, Recorder var8);

    protected abstract int getProjectType();

    @VisibleForTesting
    public VariantManager getVariantManager() {
        return this.variantManager;
    }

    @VisibleForTesting
    public VariantInputModel getVariantInputModel() {
        return this.variantInputModel;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    private ILogger getLogger() {
        if (this.loggerWrapper == null) {
            this.loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    public final void apply(Project project2) {
        CrashReporting.runAction(() -> {
            this.basePluginApply(project2);
            this.pluginSpecificApply(project2);
        });
    }

    private void basePluginApply(Project project2) {
        System.setProperty("java.awt.headless", "true");
        this.project = project2;
        this.projectOptions = new ProjectOptions(project2);
        DependencyResolutionChecks.registerDependencyCheck(project2, this.projectOptions);
        project2.getPluginManager().apply(AndroidBasePlugin.class);
        this.checkPathForErrors();
        this.checkModulesForErrors();
        AttributionListenerInitializer.INSTANCE.init(project2, this.projectOptions.get(StringOption.IDE_ATTRIBUTION_FILE_LOCATION));
        PluginInitializer.initialize(project2);
        RecordingBuildListener buildListener = ProfilerInitializer.init(project2, this.projectOptions);
        ProfileAgent.INSTANCE.register(project2.getName(), buildListener);
        this.threadRecorder = ThreadRecorder.get();
        Aapt2Workers.registerAapt2WorkersBuildService(project2, this.projectOptions);
        Aapt2Daemon.registerAapt2DaemonBuildService(project2);
        ProcessProfileWriter.getProject((String)project2.getPath()).setAndroidPluginVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST).setOptions(AnalyticsUtil.toProto(this.projectOptions));
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, project2.getPath(), null, this::configureProject);
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, project2.getPath(), null, this::configureExtension);
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, project2.getPath(), null, this::createTasks);
    }

    protected abstract void pluginSpecificApply(Project var1);

    private void configureProject() {
        Gradle gradle = this.project.getGradle();
        ObjectFactory objectFactory = this.project.getObjects();
        org.gradle.api.logging.Logger logger = this.project.getLogger();
        final String projectPath = this.project.getPath();
        this.syncIssueHandler = new SyncIssueReporterImpl(SyncOptions.getModelQueryMode(this.projectOptions), logger);
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(this.syncIssueHandler, this.projectOptions, projectPath);
        this.extraModelInfo = new ExtraModelInfo();
        final SdkComponents sdkComponents = SdkComponents.Companion.createSdkComponents(this.project, this.projectOptions, this::getExtension, this.getLogger(), this.syncIssueHandler);
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(SyncOptions.getErrorFormatMode(this.projectOptions) == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE);
        this.projectOptions.getAllOptions().forEach(deprecationReporter::reportOptionIssuesIfAny);
        GradlePluginUtils.enforceMinimumVersionsOfPlugins(this.project, this.syncIssueHandler);
        this.project.getPlugins().apply(JavaBasePlugin.class);
        DslScopeImpl dslScope = new DslScopeImpl(this.syncIssueHandler, deprecationReporter, objectFactory, this.project.getLogger(), new BuildFeatureValuesImpl(this.projectOptions), this.project.getProviders(), new DslVariableFactory(this.syncIssueHandler), this.project.getLayout(), (Function1<Object, ? extends File>)((Function1)arg_0 -> ((Project)this.project).file(arg_0)));
        FileCache buildCache = BuildCacheUtils.createBuildCacheIfEnabled(this.project, this.projectOptions);
        MessageReceiverImpl messageReceiver = new MessageReceiverImpl(SyncOptions.getErrorFormatMode(this.projectOptions), (Logger)logger);
        this.globalScope = new GlobalScope(this.project, this.creator, this.projectOptions, dslScope, sdkComponents, this.registry, buildCache, messageReceiver, this.componentFactory);
        this.project.getTasks().named("assemble").configure(task -> task.setDescription("Assembles all variants of all applications and secondary packages."));
        gradle.addBuildListener((BuildListener)new BuildAdapter(){

            public void buildFinished(BuildResult buildResult) {
                if (buildResult.getGradle().getParent() != null) {
                    return;
                }
                ModelBuilder.clearCaches();
                sdkComponents.unload();
                SdkLocator.resetCache();
                ConstraintHandler.clearCache();
                BasePlugin.this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_BUILD_FINISHED, projectPath, null, Main::clearInternTables);
                DeprecationReporterImpl.Companion.clean();
            }
        });
        BasePlugin.createLintClasspathConfiguration(this.project);
    }

    public static void createLintClasspathConfiguration(Project project2) {
        Configuration config2 = (Configuration)project2.getConfigurations().create("lintClassPath");
        config2.setVisible(false);
        config2.setTransitive(true);
        config2.setCanBeConsumed(false);
        config2.setDescription("The lint embedded classpath");
        project2.getDependencies().add(config2.getName(), (Object)("com.android.tools.lint:lint-gradle:" + Version.ANDROID_TOOLS_BASE_VERSION));
    }

    private void configureExtension() {
        DslScope dslScope = this.globalScope.getDslScope();
        NamedDomainObjectContainer buildTypeContainer = this.project.container(BuildType.class, (NamedDomainObjectFactory)new BuildTypeFactory(dslScope));
        NamedDomainObjectContainer productFlavorContainer = this.project.container(ProductFlavor.class, (NamedDomainObjectFactory)new ProductFlavorFactory(dslScope));
        NamedDomainObjectContainer signingConfigContainer = this.project.container(SigningConfig.class, (NamedDomainObjectFactory)new SigningConfigFactory(dslScope.getObjectFactory(), GradleKeystoreHelper.getDefaultDebugKeystoreLocation()));
        NamedDomainObjectContainer buildOutputs = this.project.container(BaseVariantOutput.class);
        this.project.getExtensions().add("buildOutputs", (Object)buildOutputs);
        this.sourceSetManager = new SourceSetManager(this.project, this.isPackagePublished(), dslScope, new DelayedActionsExecutor());
        DefaultConfig defaultConfig = (DefaultConfig)dslScope.getObjectFactory().newInstance(DefaultConfig.class, new Object[]{"main", dslScope});
        this.extension = this.createExtension(dslScope, this.projectOptions, this.globalScope, (NamedDomainObjectContainer<BuildType>)buildTypeContainer, defaultConfig, (NamedDomainObjectContainer<ProductFlavor>)productFlavorContainer, (NamedDomainObjectContainer<SigningConfig>)signingConfigContainer, (NamedDomainObjectContainer<BaseVariantOutput>)buildOutputs, this.sourceSetManager, this.extraModelInfo);
        ((BuildFeatureValuesImpl)dslScope.getBuildFeatures()).setDslBuildFeatures(((CommonExtension)this.extension).getBuildFeatures());
        this.globalScope.setExtension(this.extension);
        this.variantFactory = this.createVariantFactory(this.globalScope);
        this.taskManager = this.createTaskManager(this.globalScope, this.project, this.projectOptions, this.dataBindingBuilder, this.extension, this.variantFactory, this.registry, this.threadRecorder);
        this.variantInputModel = new VariantInputModelImpl(this.globalScope, this.extension, this.variantFactory, this.sourceSetManager);
        this.variantManager = new VariantManager(this.globalScope, this.project, this.projectOptions, this.extension, this.variantFactory, this.variantInputModel, this.taskManager, this.sourceSetManager, this.threadRecorder);
        this.registerModels(this.registry, this.globalScope, this.variantInputModel, this.variantManager, this.extension, this.extraModelInfo);
        signingConfigContainer.whenObjectAdded(this.variantInputModel::addSigningConfig);
        buildTypeContainer.whenObjectAdded(buildType -> {
            if (!this.getClass().isAssignableFrom(DynamicFeaturePlugin.class)) {
                SigningConfig signingConfig = (SigningConfig)signingConfigContainer.findByName("debug");
                buildType.init(signingConfig);
            } else {
                buildType.init();
            }
            this.variantInputModel.addBuildType((BuildType)buildType);
        });
        productFlavorContainer.whenObjectAdded(this.variantInputModel::addProductFlavor);
        signingConfigContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing signingConfigs is not supported."));
        buildTypeContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing build types is not supported."));
        productFlavorContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing product flavors is not supported."));
        this.variantFactory.createDefaultComponents((NamedDomainObjectContainer<BuildType>)buildTypeContainer, (NamedDomainObjectContainer<ProductFlavor>)productFlavorContainer, (NamedDomainObjectContainer<SigningConfig>)signingConfigContainer);
        this.createAndroidTestUtilConfiguration();
    }

    protected void registerModels(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantInputModel variantInputModel, VariantManager variantManager, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        VariantModelImpl variantModel = new VariantModelImpl(variantInputModel, (Function0<String>)((Function0)extension::getTestBuildType), variantManager, globalScope.getDslScope().getIssueReporter());
        this.registerModelBuilder(registry, globalScope, variantModel, extension, extraModelInfo);
        NativeModelBuilder nativeModelBuilder = new NativeModelBuilder(globalScope, variantManager);
        registry.register((ToolingModelBuilder)nativeModelBuilder);
    }

    protected void registerModelBuilder(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantModel variantModel, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        registry.register(new ModelBuilder<BaseExtension>(globalScope, variantModel, this.taskManager, extension, extraModelInfo, this.syncIssueHandler, this.getProjectType()));
    }

    private void createTasks() {
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.TASK_MANAGER_CREATE_TASKS, this.project.getPath(), null, () -> this.taskManager.createTasksBeforeEvaluate());
        this.project.afterEvaluate(CrashReporting.afterEvaluate(p -> {
            this.sourceSetManager.runBuildableArtifactsActions();
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, this.project.getPath(), null, this::createAndroidTasks);
        }));
    }

    @VisibleForTesting
    final void createAndroidTasks() {
        if (this.extension.getCompileSdkVersion() == null) {
            if (SyncOptions.getModelQueryMode(this.projectOptions).equals((Object)SyncOptions.EvaluationMode.IDE)) {
                String newCompileSdkVersion = this.findHighestSdkInstalled();
                if (newCompileSdkVersion == null) {
                    newCompileSdkVersion = "android-29";
                }
                this.extension.setCompileSdkVersion(newCompileSdkVersion);
            }
            this.globalScope.getDslScope().getIssueReporter().reportError(IssueReporter.Type.COMPILE_SDK_VERSION_NOT_SET, "compileSdkVersion is not specified. Please add it to build.gradle");
        }
        Preconditions.checkState((this.extension.getCompileSdkVersion() != null ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        this.extension.getCompileOptions().setDefaultJavaVersion(AbstractCompilesUtil.getDefaultJavaVersion(this.extension.getCompileSdkVersion()));
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        if (this.project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            String warningMsg = "One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: 'me.tatarka.retrolambda'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n";
            this.globalScope.getDslScope().getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, warningMsg);
        }
        if (!(this.project.getState().getExecuted() && this.project.getState().getFailure() == null || SdkLocator.getSdkTestDirectory() != null)) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = true;
        this.extension.disableWrite();
        this.globalScope.getDslScope().getVariableFactory().disableWrite();
        this.taskManager.configureCustomLintChecks();
        ProcessProfileWriter.getProject((String)this.project.getPath()).setCompileSdk(this.extension.getCompileSdkVersion()).setBuildToolsVersion(this.extension.getBuildToolsRevision().toString()).setSplits(AnalyticsUtil.toProto(this.extension.getSplits()));
        String kotlinPluginVersion = this.getKotlinPluginVersion();
        if (kotlinPluginVersion != null) {
            ProcessProfileWriter.getProject((String)this.project.getPath()).setKotlinPluginVersion(kotlinPluginVersion);
        }
        AnalyticsUtil.recordFirebasePerformancePluginVersion(this.project);
        List<VariantScope> variantScopes = this.variantManager.createVariantsAndTasks();
        new DependencyConfigurator(this.project, this.project.getName(), this.globalScope, this.variantInputModel).configureDependencies();
        ApiObjectFactory apiObjectFactory = new ApiObjectFactory(this.extension, this.variantFactory, this.project.getObjects());
        for (VariantScope variantScope : variantScopes) {
            BaseVariantData variantData = variantScope.getVariantData();
            apiObjectFactory.create(variantData);
        }
        this.sourceSetManager.checkForUnconfiguredSourceSets();
        this.taskManager.addBindingDependenciesIfNecessary(this.globalScope.getBuildFeatures().getViewBinding(), this.globalScope.getBuildFeatures().getDataBinding(), this.extension.getDataBinding(), this.variantManager.getVariantScopes());
        this.taskManager.configureKotlinPluginTasksForComposeIfNecessary(this.globalScope, this.variantManager.getVariantScopes());
        this.taskManager.configureGlobalLintTask(this.variantManager.getVariantScopes());
        int flavorDimensionCount = 0;
        if (this.extension.getFlavorDimensionList() != null) {
            flavorDimensionCount = this.extension.getFlavorDimensionList().size();
        }
        this.taskManager.createAnchorAssembleTasks(variantScopes, this.extension.getProductFlavors().size(), flavorDimensionCount);
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            this.variantManager.publishBuildArtifacts(variantScope);
        }
        this.checkSplitConfiguration();
        this.variantManager.setHasCreatedTasks(true);
        GradleProperty.Companion.endOfEvaluation();
    }

    private String findHighestSdkInstalled() {
        String highestSdk = null;
        File folder = new File(this.globalScope.getSdkComponents().getSdkDirectory(), "platforms");
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            Arrays.sort(listOfFiles, Comparator.comparing(File::getName).reversed());
            for (File file : listOfFiles) {
                if (AndroidTargetHash.getPlatformVersion((String)file.getName()) == null) continue;
                highestSdk = file.getName();
                break;
            }
        }
        return highestSdk;
    }

    private void checkSplitConfiguration() {
        boolean splitsEnabled;
        String configApkUrl = "https://d.android.com/topic/instant-apps/guides/config-splits.html";
        boolean generatePureSplits = this.extension.getGeneratePureSplits();
        Splits splits = this.extension.getSplits();
        boolean bl = splitsEnabled = splits.getDensity().isEnable() || splits.getAbi().isEnable() || splits.getLanguage().isEnable();
        if (generatePureSplits) {
            this.globalScope.getDslScope().getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, "Configuration APKs are supported by the Google Play Store only when publishing Android Instant Apps. To instead generate stand-alone APKs for different device configurations, set generatePureSplits=false. For more information, go to " + configApkUrl);
        }
        if (!generatePureSplits && splits.getLanguage().isEnable()) {
            this.globalScope.getDslScope().getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, "Per-language APKs are supported only when building Android Instant Apps. For more information, go to " + configApkUrl);
        }
    }

    private void checkModulesForErrors() {
        Project rootProject = this.project.getRootProject();
        HashMap<String, Project> subProjectsById = new HashMap<String, Project>();
        for (Project subProject : rootProject.getAllprojects()) {
            String id = subProject.getGroup().toString() + ":" + subProject.getName();
            if (subProjectsById.containsKey(id)) {
                String message = String.format("Your project contains 2 or more modules with the same identification %1$s\nat \"%2$s\" and \"%3$s\".\nYou must use different identification (either name or group) for each modules.", id, ((Project)subProjectsById.get(id)).getPath(), subProject.getPath());
                throw new StopExecutionException(message);
            }
            subProjectsById.put(id, subProject);
        }
    }

    private void checkPathForErrors() {
        if (!System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        if (this.projectOptions.get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY)) {
            return;
        }
        if (CharMatcher.ascii().matchesAllOf((CharSequence)this.project.getRootDir().getAbsolutePath())) {
            return;
        }
        String message = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line '" + BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY.getPropertyName() + "=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message);
    }

    public ToolingModelBuilderRegistry getModelBuilderRegistry() {
        return this.registry;
    }

    private String getKotlinPluginVersion() {
        Plugin plugin = this.project.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        try {
            Method method = plugin.getClass().getMethod("getKotlinPluginVersion", new Class[0]);
            method.setAccessible(true);
            return method.invoke((Object)plugin, new Object[0]).toString();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    protected boolean isPackagePublished() {
        return false;
    }

    private void createAndroidTestUtilConfiguration() {
        this.getLogger().info("Creating configuration androidTestUtil", new Object[0]);
        Configuration configuration2 = (Configuration)this.project.getConfigurations().maybeCreate("androidTestUtil");
        configuration2.setVisible(false);
        configuration2.setDescription("Additional APKs used during instrumentation testing.");
        configuration2.setCanBeConsumed(false);
        configuration2.setCanBeResolved(true);
    }

    private static class UnsupportedAction
    implements Action<Object> {
        private final String message;

        UnsupportedAction(String message) {
            this.message = message;
        }

        public void execute(Object o) {
            throw new UnsupportedOperationException(this.message);
        }
    }
}

