/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.SdkConstants;
import com.android.Version;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.res.Aapt2Extractor;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.Aapt2Version;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.options.StringOption;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"AAPT2_CONFIG_NAME", "", "TYPE_EXTRACTED_AAPT2_BINARY", "getAapt2FromMaven", "Lorg/gradle/api/file/FileCollection;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "getAapt2FromMavenAndVersion", "Lkotlin/Pair;", "project", "Lorg/gradle/api/Project;", "getArtifactCollection", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "gradle"})
@JvmName(name="Aapt2MavenUtils")
public final class Aapt2MavenUtils {
    private static final String TYPE_EXTRACTED_AAPT2_BINARY = "_internal-android-aapt2-binary";
    private static final String AAPT2_CONFIG_NAME = "_internal_aapt2_binary";

    @NotNull
    public static final FileCollection getAapt2FromMaven(@NotNull GlobalScope globalScope) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Pair<FileCollection, String> pair = Aapt2MavenUtils.getAapt2FromMavenAndVersion(globalScope);
        FileCollection aapt2FromMaven = (FileCollection)pair.component1();
        return aapt2FromMaven;
    }

    @NotNull
    public static final Pair<FileCollection, String> getAapt2FromMavenAndVersion(@NotNull GlobalScope globalScope) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        String customAapt2 = globalScope.getProjectOptions().get(StringOption.AAPT2_FROM_MAVEN_OVERRIDE);
        CharSequence charSequence = customAapt2;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = customAapt2;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = SdkConstants.FN_AAPT2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SdkConstants.FN_AAPT2");
            if (!StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                charSequence = "Custom AAPT2 location does not point to an AAPT2 executable: " + customAapt2;
                bl = false;
                throw (Throwable)new IllegalStateException(((Object)charSequence).toString());
            }
            return new Pair((Object)globalScope.getProject().files(new Object[]{new File(customAapt2).getParentFile()}), (Object)customAapt2);
        }
        Project project2 = globalScope.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"globalScope.project");
        return Aapt2MavenUtils.getAapt2FromMavenAndVersion(project2);
    }

    @VisibleForTesting
    @NotNull
    public static final Pair<FileCollection, String> getAapt2FromMavenAndVersion(@NotNull Project project2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        String version = Version.ANDROID_GRADLE_PLUGIN_VERSION + '-' + Aapt2Version.INSTANCE.getBUILD_NUMBER();
        Configuration existingConfig = (Configuration)project2.getConfigurations().findByName(AAPT2_CONFIG_NAME);
        if (existingConfig != null) {
            return new Pair((Object)Aapt2MavenUtils.getArtifactCollection(existingConfig), (Object)version);
        }
        Configuration config2 = (Configuration)project2.getConfigurations().create(AAPT2_CONFIG_NAME, (Action)getAapt2FromMavenAndVersion.config.1.INSTANCE);
        switch (SdkConstants.currentPlatform()) {
            case 2: {
                string = "windows";
                break;
            }
            case 3: {
                string = "osx";
                break;
            }
            case 1: {
                string = "linux";
                break;
            }
            default: {
                String string2 = "Unknown platform '" + System.getProperty("os.name") + '\'';
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        String classifier = string;
        DependencyHandler dependencyHandler = project2.getDependencies();
        Configuration configuration2 = config2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"config");
        dependencyHandler.add(configuration2.getName(), (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.build"), TuplesKt.to((Object)"name", (Object)"aapt2"), TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"classifier", (Object)classifier)}));
        project2.getDependencies().registerTransform(Aapt2Extractor.class, (Action)new Action<TransformSpec<GenericTransformParameters>>(project2){
            final /* synthetic */ Project $project;

            public final void execute(TransformSpec<GenericTransformParameters> it) {
                TransformSpec<GenericTransformParameters> transformSpec = it;
                Intrinsics.checkExpressionValueIsNotNull(transformSpec, (String)"it");
                ((GenericTransformParameters)transformSpec.getParameters()).getProjectName().set((Object)this.$project.getName());
                it.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                it.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-android-aapt2-binary");
            }
            {
                this.$project = project2;
            }
        });
        return new Pair((Object)Aapt2MavenUtils.getArtifactCollection(config2), (Object)version);
    }

    private static final FileCollection getArtifactCollection(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }
}

