/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTaskRunnable;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "assetsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAssetsFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "manifestFiles", "Lorg/gradle/api/file/DirectoryProperty;", "getManifestFiles", "()Lorg/gradle/api/file/DirectoryProperty;", "outputDir", "getOutputDir", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class AssetPackPreBundleTask
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getManifestFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getAssetsFiles();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        FileTree fileTree = this.getManifestFiles().getAsFileTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"manifestFiles.asFileTree");
        for (File manifestFile : fileTree.getFiles()) {
            File file = manifestFile.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"manifestFile.parentFile");
            String assetPackName = file.getName();
            Directory packDir = (Directory)this.getOutputDir().dir(assetPackName).get();
            Closeable closeable = (Closeable)this.getWorkerFacadeWithWorkers();
            boolean bl = false;
            Throwable throwable = null;
            try {
                WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
                boolean bl2 = false;
                Directory directory2 = packDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)directory2, (String)"packDir");
                File file2 = directory2.getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"packDir.asFile");
                RegularFile regularFile = packDir.file(assetPackName + ".zip");
                Intrinsics.checkExpressionValueIsNotNull((Object)regularFile, (String)"packDir.file(\"${assetPackName}.zip\")");
                File file3 = regularFile.getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"packDir.file(\"${assetPackName}.zip\").asFile");
                FileCollection fileCollection2 = this.getAssetsFiles().filter((Spec)new Spec<File>(this, packDir, assetPackName, manifestFile){
                    final /* synthetic */ AssetPackPreBundleTask this$0;
                    final /* synthetic */ Directory $packDir$inlined;
                    final /* synthetic */ String $assetPackName$inlined;
                    final /* synthetic */ File $manifestFile$inlined;
                    {
                        this.this$0 = assetPackPreBundleTask;
                        this.$packDir$inlined = directory2;
                        this.$assetPackName$inlined = string;
                        this.$manifestFile$inlined = file;
                    }

                    public final boolean isSatisfiedBy(File assetPack) {
                        File file = assetPack;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"assetPack");
                        String string = file.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"assetPack.absolutePath");
                        return StringsKt.contains$default((CharSequence)string, (CharSequence)(this.$assetPackName$inlined + File.separator + "src" + File.separator + "main" + File.separator + "assets"), (boolean)false, (int)2, null);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"assetsFiles.filter{asset\u2026le.separator + \"assets\")}");
                String string = fileCollection2.getAsPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"assetsFiles.filter{asset\u2026rator + \"assets\")}.asPath");
                it.submit(AssetPackPreBundleTaskRunnable.class, (Serializable)new AssetPackPreBundleTaskRunnable.Params(file2, file3, string, manifestFile));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "assetFileCollection", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/scope/VariantScope;Lorg/gradle/api/file/FileCollection;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AssetPackPreBundleTask> {
        @NotNull
        private final Class<AssetPackPreBundleTask> type;
        @NotNull
        private final String name;
        private final FileCollection assetFileCollection;

        @Override
        @NotNull
        public Class<AssetPackPreBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends AssetPackPreBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            BuildArtifactsHolder.producesDir$default(this.getVariantScope().getArtifacts(), InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE, taskProvider, (Function1)AssetPackPreBundleTask$CreationAction$handleProvider$1.INSTANCE, null, 8, null);
        }

        @Override
        public void configure(@NotNull AssetPackPreBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
            BuildArtifactsHolder artifacts2 = buildArtifactsHolder;
            artifacts2.setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.LINKED_RES_FOR_ASSET_PACK.INSTANCE, (Property)task.getManifestFiles());
            task.getAssetsFiles().from(new Object[]{this.assetFileCollection});
        }

        public CreationAction(@NotNull VariantScope variantScope, @NotNull FileCollection assetFileCollection) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            Intrinsics.checkParameterIsNotNull((Object)assetFileCollection, (String)"assetFileCollection");
            super(variantScope);
            this.assetFileCollection = assetFileCollection;
            this.type = AssetPackPreBundleTask.class;
            String string = variantScope.getTaskName("assetPack", "PreBundleTask");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026etPack\", \"PreBundleTask\")");
            this.name = string;
        }
    }
}

