/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import java.io.IOException;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class SourceSetsTask
extends AbstractReportTask {
    private final TextReportRenderer mRenderer = new TextReportRenderer();
    private BaseExtension extension;

    protected ReportRenderer getRenderer() {
        return this.mRenderer;
    }

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    public BaseExtension getExtension() {
        return this.extension;
    }

    public void setExtension(BaseExtension extension) {
        this.extension = extension;
    }

    protected void generate(Project project2) throws IOException {
        if (this.extension != null) {
            for (AndroidSourceSet sourceSet : this.extension.getSourceSets()) {
                this.mRenderer.getBuilder().subheading(sourceSet.getName());
                this.renderKeyValue("Compile configuration: ", sourceSet.getCompileConfigurationName());
                this.renderKeyValue("build.gradle name: ", "android.sourceSets." + sourceSet.getName());
                this.renderDirectorySet("Java sources", sourceSet.getJava(), project2);
                if (!sourceSet.getName().startsWith("test")) {
                    this.renderKeyValue("Manifest file: ", project2.getRootProject().relativePath((Object)sourceSet.getManifest().getSrcFile()));
                    this.renderDirectorySet("Android resources", sourceSet.getRes(), project2);
                    this.renderDirectorySet("Assets", sourceSet.getAssets(), project2);
                    this.renderDirectorySet("AIDL sources", sourceSet.getAidl(), project2);
                    this.renderDirectorySet("RenderScript sources", sourceSet.getRenderscript(), project2);
                    this.renderDirectorySet("JNI sources", sourceSet.getJni(), project2);
                    this.renderDirectorySet("JNI libraries", sourceSet.getJniLibs(), project2);
                }
                this.renderDirectorySet("Java-style resources", sourceSet.getResources(), project2);
                this.mRenderer.getTextOutput().println();
            }
        }
        this.mRenderer.complete();
    }

    private void renderDirectorySet(String name2, AndroidSourceDirectorySet java, Project project2) {
        String relativePaths = java.getSrcDirs().stream().map(file -> project2.getRootProject().relativePath(file)).collect(Collectors.joining(", "));
        this.renderKeyValue(name2 + ": ", String.format("[%s]", relativePaths));
    }

    private void renderKeyValue(String o, String o1) {
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)o);
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)o1);
        this.mRenderer.getTextOutput().println();
    }

    public static class CreationAction
    extends TaskCreationAction<SourceSetsTask> {
        private final BaseExtension extension;

        public CreationAction(BaseExtension extension) {
            this.extension = extension;
        }

        @Override
        public String getName() {
            return "sourceSets";
        }

        @Override
        public Class<SourceSetsTask> getType() {
            return SourceSetsTask.class;
        }

        @Override
        public void configure(SourceSetsTask sourceSetsTask) {
            sourceSetsTask.setExtension(this.extension);
            sourceSetsTask.setDescription("Prints out all the source sets defined in this project.");
            sourceSetsTask.setGroup("Android");
        }
    }
}

