/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.feature.BundleAllClasses;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.ApkZipPackagingTask;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckMultiApkLibrariesTask;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.featuresplit.PackagedDependenciesWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class AbstractAppTaskManager<VariantT extends VariantImpl<VariantPropertiesT>, VariantPropertiesT extends VariantPropertiesImpl>
extends TaskManager<VariantT, VariantPropertiesT> {
    protected AbstractAppTaskManager(List<ComponentInfo<VariantT, VariantPropertiesT>> variants, List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents, boolean hasFlavors, GlobalScope globalScope, BaseExtension extension, Recorder recorder) {
        super(variants, testComponents, hasFlavors, globalScope, extension, recorder);
    }

    protected void createCommonTasks(ComponentInfo<VariantT, VariantPropertiesT> variant2, List<ComponentInfo<VariantT, VariantPropertiesT>> allComponentsWithLint) {
        VariantPropertiesImpl appVariantProperties = (VariantPropertiesImpl)variant2.getProperties();
        ApkCreationConfig apkCreationConfig = (ApkCreationConfig)((Object)appVariantProperties);
        this.createAnchorTasks(appVariantProperties);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(appVariantProperties));
        this.createDependencyStreams(appVariantProperties);
        this.createApplicationIdWriterTask(apkCreationConfig);
        this.createBuildArtifactReportTask(appVariantProperties);
        this.taskFactory.register(new CheckManifest.CreationAction(appVariantProperties));
        this.createMergeApkManifestsTask(appVariantProperties);
        this.createGenerateResValuesTask(appVariantProperties);
        this.createRenderscriptTask(appVariantProperties);
        this.createMergeResourcesTasks(appVariantProperties);
        this.createShaderTask(appVariantProperties);
        this.createMergeAssetsTask(appVariantProperties);
        this.createBuildConfigTask(appVariantProperties);
        this.createApkProcessResTask(appVariantProperties);
        this.registerRClassTransformStream(appVariantProperties);
        this.createProcessJavaResTask(appVariantProperties);
        this.createAidlTask(appVariantProperties);
        this.createExternalNativeBuildJsonGenerators(appVariantProperties);
        this.createExternalNativeBuildTasks(appVariantProperties);
        this.createMergeJniLibFoldersTasks(appVariantProperties);
        this.createDataBindingTasksIfNecessary(appVariantProperties);
        this.createMlkitTask(appVariantProperties);
        this.createCompileTask(appVariantProperties);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(appVariantProperties));
        this.taskFactory.register(new ExtractNativeDebugMetadataTask.FullCreationAction(appVariantProperties));
        this.taskFactory.register(new ExtractNativeDebugMetadataTask.SymbolTableCreationAction(appVariantProperties));
        this.createPackagingTask(apkCreationConfig);
        this.maybeCreateLintVitalTask(appVariantProperties, allComponentsWithLint);
        this.createLintTasks(appVariantProperties, allComponentsWithLint);
        this.taskFactory.register(new PackagedDependenciesWriterTask.CreationAction(appVariantProperties));
        this.taskFactory.register(new ApkZipPackagingTask.CreationAction(appVariantProperties));
    }

    private void createCompileTask(VariantPropertiesImpl variantProperties) {
        ApkCreationConfig apkCreationConfig = (ApkCreationConfig)((Object)variantProperties);
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(variantProperties);
        this.addJavacClassesStream(variantProperties);
        AbstractAppTaskManager.setJavaCompilerTask(javacTask, variantProperties);
        this.createPostCompilationTasks(apkCreationConfig);
    }

    @Override
    protected void postJavacCreation(ComponentPropertiesImpl componentProperties) {
        Provider javacOutput = componentProperties.getArtifacts().getFinalProduct(InternalArtifactType.JAVAC.INSTANCE);
        ConfigurableFileCollection preJavacGeneratedBytecode = componentProperties.getVariantData().getAllPreJavacGeneratedBytecode();
        ConfigurableFileCollection postJavacGeneratedBytecode = componentProperties.getVariantData().getAllPostJavacGeneratedBytecode();
        this.taskFactory.register(new BundleAllClasses.CreationAction(componentProperties));
        ConfigurableFileCollection files2 = componentProperties.getGlobalScope().getProject().files(new Object[]{javacOutput, preJavacGeneratedBytecode, postJavacGeneratedBytecode});
        componentProperties.getArtifacts().appendToAllClasses((FileCollection)files2);
    }

    @Override
    protected void createVariantPreBuildTask(ComponentPropertiesImpl componentProperties) {
        VariantType variantType = componentProperties.getVariantType();
        if (variantType.isApk()) {
            Object task;
            boolean useDependencyConstraints = componentProperties.getServices().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS);
            if (variantType.isTestComponent()) {
                task = this.taskFactory.register(new TestPreBuildTask.CreationAction((TestComponentPropertiesImpl)componentProperties));
                if (useDependencyConstraints) {
                    task.configure(t -> t.setEnabled(false));
                }
            } else {
                task = this.taskFactory.register(AppPreBuildTask.getCreationAction(componentProperties));
            }
            if (!useDependencyConstraints) {
                TaskProvider<AppClasspathCheckTask> classpathCheck = this.taskFactory.register(new AppClasspathCheckTask.CreationAction(componentProperties));
                TaskFactoryUtils.dependsOn(task, classpathCheck);
            }
            if (variantType.isBaseModule() && this.globalScope.hasDynamicFeatures()) {
                TaskProvider<CheckMultiApkLibrariesTask> checkMultiApkLibrariesTask = this.taskFactory.register(new CheckMultiApkLibrariesTask.CreationAction(componentProperties));
                TaskFactoryUtils.dependsOn(task, checkMultiApkLibrariesTask);
            }
            return;
        }
        super.createVariantPreBuildTask(componentProperties);
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(ComponentPropertiesImpl componentProperties, QualifiedContent.ContentType contentType) {
        if (componentProperties.getVariantScope().consumesFeatureJars() && contentType == QualifiedContent.DefaultContentType.RESOURCES) {
            return TransformManager.SCOPE_FULL_WITH_FEATURES;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void createApplicationIdWriterTask(ApkCreationConfig creationConfig) {
        if (creationConfig.getVariantType().isBaseModule()) {
            this.taskFactory.register(new ModuleMetadataWriterTask.CreationAction((ApplicationCreationConfig)creationConfig));
        }
        TaskProvider<ApplicationIdWriterTask> applicationIdWriterTask = this.taskFactory.register(new ApplicationIdWriterTask.CreationAction(creationConfig));
        TextResourceFactory resources = this.project.getResources().getText();
        ((ComponentPropertiesImpl)((Object)creationConfig)).getVariantData().applicationIdTextResource = resources.fromFile(applicationIdWriterTask);
    }

    private void createMergeResourcesTasks(VariantPropertiesImpl variantProperties) {
        this.createMergeResourcesTask(variantProperties, true, (ImmutableSet<MergeResources.Flag>)Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]));
        if (variantProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_APP_COMPILE_TIME_R_CLASS) && !variantProperties.getVariantType().isForTesting() && !variantProperties.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            this.basicCreateMergeResourcesTask(variantProperties, TaskManager.MergeType.PACKAGE, variantProperties.getPaths().getIntermediateDir(InternalArtifactType.PACKAGED_RES.INSTANCE), false, false, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of(), null);
        }
    }
}

