/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.PublicArtifactType;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.BaseCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.TryCreateCxxModuleModelKt;
import com.android.build.gradle.internal.dependency.AndroidXDependencySubstitution;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.AnnotationProcessorOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.GenerateLibraryRFileTask;
import com.android.build.gradle.internal.res.LinkAndroidResForBundleTask;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.ParseLibraryResourcesTask;
import com.android.build.gradle.internal.res.namespaced.NamespacedResourcesTaskManager;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MultipleArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.SingleArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.CheckDuplicateClassesTask;
import com.android.build.gradle.internal.tasks.CheckProguardFiles;
import com.android.build.gradle.internal.tasks.D8MainDexListTask;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DesugarTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTask;
import com.android.build.gradle.internal.tasks.DexFileDependenciesTask;
import com.android.build.gradle.internal.tasks.DexMergingAction;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.internal.tasks.DexSplitterTask;
import com.android.build.gradle.internal.tasks.ExtractProguardFiles;
import com.android.build.gradle.internal.tasks.ExtractTryWithResourcesSupportJar;
import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.internal.tasks.L8DexDesugarLibTask;
import com.android.build.gradle.internal.tasks.LintCompile;
import com.android.build.gradle.internal.tasks.MergeAaptProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.MergeClassesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.MergeJavaResourceTask;
import com.android.build.gradle.internal.tasks.MergeNativeLibsTask;
import com.android.build.gradle.internal.tasks.OptimizeResourcesTask;
import com.android.build.gradle.internal.tasks.PackageForUnitTest;
import com.android.build.gradle.internal.tasks.PrepareLintJar;
import com.android.build.gradle.internal.tasks.PrepareLintJarForPublish;
import com.android.build.gradle.internal.tasks.ProcessJavaResTask;
import com.android.build.gradle.internal.tasks.ProguardTask;
import com.android.build.gradle.internal.tasks.R8Task;
import com.android.build.gradle.internal.tasks.RecalculateStackFramesTask;
import com.android.build.gradle.internal.tasks.ShrinkResourcesTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingCompilerArguments;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingGenBaseClassesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeBaseClassLogTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeDependencyArtifactsTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryImpl;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitUtils;
import com.android.build.gradle.internal.tasks.mlkit.GenerateMlModelClass;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BundleTestDataImpl;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.internal.transforms.CustomClassTransform;
import com.android.build.gradle.internal.transforms.ShrinkBundleResourcesTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.AnalyzeDependenciesTask;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.ExternalNativeBuildJsonTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeCleanTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.build.gradle.tasks.JavaCompileCreationAction;
import com.android.build.gradle.tasks.JavaPreCompileTask;
import com.android.build.gradle.tasks.LintFixTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import com.android.build.gradle.tasks.LintPerVariantTask;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PrepareKotlinCompileTask;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.CodeShrinker;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class TaskManager<VariantT extends VariantImpl<? extends VariantPropertiesT>, VariantPropertiesT extends VariantPropertiesImpl> {
    private static final String MULTIDEX_VERSION = "1.0.2";
    private static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.2";
    private static final String ANDROIDX_MULTIDEX_MULTIDEX = AndroidXDependencySubstitution.getAndroidXMappings().get("com.android.support:multidex");
    private static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.2";
    private static final String ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION = AndroidXDependencySubstitution.getAndroidXMappings().get("com.android.support:multidex-instrumentation");
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    public static final String FEATURE_SUFFIX = "Feature";
    public static final String MAIN_PREBUILD = "preBuild";
    public static final String UNINSTALL_ALL = "uninstallAll";
    public static final String DEVICE_CHECK = "deviceCheck";
    public static final String DEVICE_ANDROID_TEST = "deviceAndroidTest";
    public static final String CONNECTED_CHECK = "connectedCheck";
    public static final String CONNECTED_ANDROID_TEST = "connectedAndroidTest";
    public static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    public static final String LINT = "lint";
    public static final String LINT_FIX = "lintFix";
    public static final String EXTRACT_PROGUARD_FILES = "extractProguardFiles";
    public static final String KOTLIN_COMPILER_CLASSPATH_CONFIGURATION_NAME = "kotlinCompilerClasspath";
    public static final String COMPOSE_KOTLIN_COMPILER_EXTENSION_VERSION = "0.1.0-dev03";
    public static final String COMPOSE_KOTLIN_COMPILER_VERSION = "1.3.61-dev-withExperimentalGoogleExtensions-20191127";
    public static final String CREATE_MOCKABLE_JAR_TASK_NAME = "createMockableJar";
    protected final Project project;
    protected final BaseExtension extension;
    private final List<ComponentInfo<VariantT, VariantPropertiesT>> variants;
    private final List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents;
    private final boolean hasFlavors;
    protected final GlobalScope globalScope;
    protected final Recorder recorder;
    private final Logger logger;
    protected final TaskFactory taskFactory;
    private final ImmutableList<VariantPropertiesT> variantPropertiesList;
    private final ImmutableList<TestComponentPropertiesImpl> testComponentPropertiesList;
    private final ImmutableList<ComponentPropertiesImpl> allPropertiesList;

    public TaskManager(List<ComponentInfo<VariantT, VariantPropertiesT>> variants, List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents, boolean hasFlavors, GlobalScope globalScope, BaseExtension extension, Recorder recorder) {
        this.variants = variants;
        this.testComponents = testComponents;
        this.hasFlavors = hasFlavors;
        this.globalScope = globalScope;
        this.project = globalScope.getProject();
        this.extension = extension;
        this.recorder = recorder;
        this.logger = Logging.getLogger(this.getClass());
        this.taskFactory = new TaskFactoryImpl(this.project.getTasks());
        this.variantPropertiesList = (ImmutableList)variants.stream().map(ComponentInfo::getProperties).collect(ImmutableList.toImmutableList());
        this.testComponentPropertiesList = (ImmutableList)testComponents.stream().map(ComponentInfo::getProperties).collect(ImmutableList.toImmutableList());
        this.allPropertiesList = ImmutableList.builder().addAll(this.variantPropertiesList).addAll(this.testComponentPropertiesList).build();
    }

    public void createTasks() {
        this.taskFactory.register(new PrepareLintJar.CreationAction(this.globalScope));
        this.taskFactory.register(new PrepareLintJarForPublish.CreationAction(this.globalScope));
        this.createTopLevelTestTasks();
        for (ComponentInfo<VariantT, VariantPropertiesT> componentInfo : this.variants) {
            this.createTasksForVariant(componentInfo, this.variants);
        }
        for (ComponentInfo<Object, Object> componentInfo : this.testComponents) {
            this.createTasksForTest(componentInfo);
        }
        this.createReportTasks();
    }

    public void createPostApiTasks() {
        this.addBindingDependenciesIfNecessary(this.extension.getDataBinding());
        this.configureKotlinPluginTasksForComposeIfNecessary();
        this.configureGlobalLintTask();
        int flavorDimensionCount = 0;
        if (this.extension.getFlavorDimensionList() != null) {
            flavorDimensionCount = this.extension.getFlavorDimensionList().size();
        }
        this.createAnchorAssembleTasks(this.extension.getProductFlavors().size(), flavorDimensionCount);
    }

    private void createTasksForVariant(ComponentInfo<VariantT, VariantPropertiesT> variant2, List<ComponentInfo<VariantT, VariantPropertiesT>> variants) {
        VariantPropertiesImpl variantProperties = (VariantPropertiesImpl)variant2.getProperties();
        VariantType variantType = variantProperties.getVariantType();
        VariantDependencies variantDependencies = variantProperties.getVariantDependencies();
        if (variantProperties.getVariantDslInfo().isLegacyMultiDexMode()) {
            String multiDexDependency = variantProperties.getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX : COM_ANDROID_SUPPORT_MULTIDEX;
            this.project.getDependencies().add(variantDependencies.getCompileClasspath().getName(), (Object)multiDexDependency);
            this.project.getDependencies().add(variantDependencies.getRuntimeClasspath().getName(), (Object)multiDexDependency);
        }
        if (variantProperties.getVariantDslInfo().getRenderscriptSupportModeEnabled()) {
            ConfigurableFileCollection fileCollection2 = this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()});
            this.project.getDependencies().add(variantDependencies.getCompileClasspath().getName(), (Object)fileCollection2);
            if (variantType.isApk() && !variantType.isForTesting()) {
                this.project.getDependencies().add(variantDependencies.getRuntimeClasspath().getName(), (Object)fileCollection2);
            }
        }
        this.createAssembleTask(variantProperties);
        if (variantType.isBaseModule()) {
            this.createBundleTask(variantProperties);
        }
        this.doCreateTasksForVariant(variant2, variants);
    }

    protected abstract void doCreateTasksForVariant(ComponentInfo<VariantT, VariantPropertiesT> var1, List<ComponentInfo<VariantT, VariantPropertiesT>> var2);

    private void createTasksForTest(ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl> testComponent) {
        TestComponentPropertiesImpl componentProperties = testComponent.getProperties();
        this.createAssembleTask(componentProperties);
        VariantPropertiesImpl testedVariant = componentProperties.getTestedVariant();
        VariantDslInfo variantDslInfo = componentProperties.getVariantDslInfo();
        VariantDependencies variantDependencies = componentProperties.getVariantDependencies();
        if (testedVariant.getVariantDslInfo().getRenderscriptSupportModeEnabled()) {
            this.project.getDependencies().add(variantDependencies.getCompileClasspath().getName(), (Object)this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()}));
        }
        if (componentProperties.getVariantType().isApk()) {
            if (variantDslInfo.isLegacyMultiDexMode()) {
                String multiDexInstrumentationDep = componentProperties.getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION : COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION;
                this.project.getDependencies().add(variantDependencies.getCompileClasspath().getName(), (Object)multiDexInstrumentationDep);
                this.project.getDependencies().add(variantDependencies.getRuntimeClasspath().getName(), (Object)multiDexInstrumentationDep);
            }
            this.createAndroidTestVariantTasks((AndroidTestPropertiesImpl)componentProperties);
        } else {
            this.createUnitTestVariantTasks((UnitTestPropertiesImpl)componentProperties);
        }
    }

    public static void createTasksBeforeEvaluate(GlobalScope globalScope, VariantType variantType, Iterable<AndroidSourceSet> sourceSetContainer) {
        Project project2 = globalScope.getProject();
        TaskFactoryImpl taskFactory = new TaskFactoryImpl(project2.getTasks());
        taskFactory.register(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAllTask -> {
            uninstallAllTask.setDescription("Uninstall all applications.");
            uninstallAllTask.setGroup(INSTALL_GROUP);
        }));
        taskFactory.register(DEVICE_CHECK, (Action<? super Task>)((Action)deviceCheckTask -> {
            deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
            deviceCheckTask.setGroup("verification");
        }));
        taskFactory.register(CONNECTED_CHECK, (Action<? super Task>)((Action)connectedCheckTask -> {
            connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
            connectedCheckTask.setGroup("verification");
        }));
        taskFactory.register(MAIN_PREBUILD);
        taskFactory.register(EXTRACT_PROGUARD_FILES, ExtractProguardFiles.class, task -> task.dependsOn(new Object[]{MAIN_PREBUILD}));
        taskFactory.register(new SourceSetsTask.CreationAction(sourceSetContainer));
        taskFactory.register(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleAndroidTestTask -> {
            assembleAndroidTestTask.setGroup(BUILD_GROUP);
            assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
        }));
        taskFactory.register(new LintCompile.CreationAction(globalScope));
        if (!variantType.isForTesting()) {
            taskFactory.register(LINT, LintGlobalTask.class, task -> {});
            taskFactory.configure("check", (Action<? super Task>)((Action)it -> it.dependsOn(new Object[]{LINT})));
            taskFactory.register(LINT_FIX, LintFixTask.class, task -> {});
        }
        globalScope.setLintChecks(TaskManager.createCustomLintChecksConfig(project2));
        globalScope.setLintPublish(TaskManager.createCustomLintPublishConfig(project2));
        globalScope.setAndroidJarConfig(TaskManager.createAndroidJarConfig(project2));
        taskFactory.register("resolveConfigAttr", ConfigAttrTask.class, task -> {
            task.resolvable = true;
        });
        taskFactory.register("consumeConfigAttr", ConfigAttrTask.class, task -> {
            task.consumable = true;
        });
        Aapt2MavenUtils.getAapt2FromMavenAndVersion(globalScope);
        TaskManager.createCoreLibraryDesugaringConfig(project2);
    }

    public static Configuration createCustomLintChecksConfig(Project project2) {
        Configuration lintChecks = (Configuration)project2.getConfigurations().maybeCreate("lintChecks");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to apply external lint check jar");
        lintChecks.setCanBeConsumed(false);
        return lintChecks;
    }

    public static Configuration createCustomLintPublishConfig(Project project2) {
        Configuration lintChecks = (Configuration)project2.getConfigurations().maybeCreate("lintPublish");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to publish external lint check jar");
        lintChecks.setCanBeConsumed(false);
        return lintChecks;
    }

    protected void configureGlobalLintTask() {
        this.taskFactory.configure(LINT, LintGlobalTask.class, task -> new LintGlobalTask.GlobalCreationAction(this.globalScope, (Collection<? extends VariantPropertiesImpl>)this.variantPropertiesList).configure((LintGlobalTask)((Object)task)));
        this.taskFactory.configure(LINT_FIX, LintFixTask.class, task -> new LintFixTask.GlobalCreationAction(this.globalScope, (Collection<? extends VariantPropertiesImpl>)this.variantPropertiesList).configure((LintFixTask)((Object)task)));
        for (VariantPropertiesImpl variant2 : this.variantPropertiesList) {
            variant2.getArtifacts().copy(InternalArtifactType.LINT_PUBLISH_JAR.INSTANCE, this.globalScope.getArtifacts());
        }
    }

    private void configureKotlinPluginTasksForComposeIfNecessary() {
        boolean composeIsEnabled = this.allPropertiesList.stream().anyMatch(componentProperties -> componentProperties.getBuildFeatures().getCompose());
        if (!composeIsEnabled) {
            return;
        }
        String kotlinCompilerVersionInDsl = this.globalScope.getExtension().getComposeOptions().getKotlinCompilerVersion();
        String kotlinCompilerExtensionVersionInDsl = this.globalScope.getExtension().getComposeOptions().getKotlinCompilerExtensionVersion();
        String kotlinCompilerDependency = "org.jetbrains.kotlin:kotlin-compiler-embeddable:" + (kotlinCompilerVersionInDsl != null ? kotlinCompilerVersionInDsl : COMPOSE_KOTLIN_COMPILER_VERSION);
        ((Configuration)this.project.getConfigurations().maybeCreate(KOTLIN_COMPILER_CLASSPATH_CONFIGURATION_NAME)).withDependencies(configuration2 -> configuration2.add((Object)this.project.getDependencies().create((Object)kotlinCompilerDependency))).getResolutionStrategy().force(new Object[]{kotlinCompilerDependency});
        ProcessProfileWriter.getProject((String)this.project.getPath()).setComposeEnabled(true);
        Configuration kotlinExtension = (Configuration)this.project.getConfigurations().create("kotlin-extension");
        this.project.getDependencies().add(kotlinExtension.getName(), (Object)("androidx.compose:compose-compiler:" + (kotlinCompilerExtensionVersionInDsl != null ? kotlinCompilerExtensionVersionInDsl : COMPOSE_KOTLIN_COMPILER_EXTENSION_VERSION)));
        kotlinExtension.setTransitive(false);
        kotlinExtension.setDescription("Configuration for Compose related kotlin compiler extension");
        for (ComponentPropertiesImpl component2 : this.allPropertiesList) {
            try {
                TaskProvider compileKotlin = this.globalScope.getProject().getTasks().named(component2.computeTaskName("compile", "Kotlin"));
                TaskProvider<PrepareKotlinCompileTask> prepareKotlinCompileTaskTaskProvider = this.taskFactory.register(new PrepareKotlinCompileTask.CreationAction(component2, (TaskProvider<Task>)compileKotlin, kotlinExtension));
                compileKotlin.configure(task -> task.dependsOn(new Object[]{prepareKotlinCompileTaskTaskProvider}));
            }
            catch (UnknownTaskException unknownTaskException) {}
        }
    }

    public void createMockableJarTask() {
        this.project.getDependencies().add("androidApis", (Object)this.project.files(new Object[]{() -> (File)this.globalScope.getSdkComponents().getAndroidJarProvider().getOrNull()}));
        this.taskFactory.register(CREATE_MOCKABLE_JAR_TASK_NAME, (Action<? super Task>)((Action)task -> task.dependsOn(new Object[]{this.globalScope.getMockableJarArtifact()})));
    }

    public static Configuration createAndroidJarConfig(Project project2) {
        Configuration androidJarConfig = (Configuration)project2.getConfigurations().maybeCreate("androidApis");
        androidJarConfig.setDescription("Configuration providing various types of Android JAR file");
        androidJarConfig.setCanBeConsumed(false);
        return androidJarConfig;
    }

    public static void createCoreLibraryDesugaringConfig(Project project2) {
        Configuration coreLibraryDesugaring = (Configuration)project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (coreLibraryDesugaring == null) {
            coreLibraryDesugaring = (Configuration)project2.getConfigurations().create("coreLibraryDesugaring");
            coreLibraryDesugaring.setVisible(false);
            coreLibraryDesugaring.setCanBeConsumed(false);
            coreLibraryDesugaring.setDescription("Configuration to desugar libraries");
        }
    }

    protected void createDependencyStreams(ComponentPropertiesImpl componentProperties) {
        VariantScope variantScope;
        this.handleJacocoDependencies(componentProperties);
        TransformManager transformManager = componentProperties.getTransformManager();
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(componentProperties.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR)).build());
        if (!this.getJavaResMergingScopes(componentProperties, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-java-res").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(componentProperties.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(componentProperties.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.CLASSES_JAR)).build());
        if (!this.getJavaResMergingScopes(componentProperties, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).contains(QualifiedContent.Scope.SUB_PROJECTS)) {
            transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-java-res").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(componentProperties.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        }
        if ((variantScope = componentProperties.getVariantScope()).consumesFeatureJars() || variantScope.getNeedsMainDexListForBundle()) {
            transformManager.addStream(OriginalStream.builder(this.project, "metadata-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.FEATURES).setArtifactCollection(componentProperties.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_CLASSES)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "provided-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY).setFileCollection(variantScope.getProvidedOnlyClasspath()).build());
        componentProperties.onTestedConfig(testedConfig -> {
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-deps").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setArtifactCollection(testedConfig.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR)).build());
            return null;
        });
    }

    public void createBuildArtifactReportTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(new BuildArtifactReportTask.BuildArtifactReportCreationAction(componentProperties));
    }

    public void createMergeApkManifestsTask(ComponentPropertiesImpl componentProperties) {
        ApkVariantData apkVariantData = (ApkVariantData)componentProperties.getVariantData();
        Set<String> screenSizes = apkVariantData.getCompatibleScreens();
        ApkCreationConfig creationConfig = (ApkCreationConfig)((Object)componentProperties);
        this.taskFactory.register(new CompatibleScreensManifest.CreationAction(creationConfig, screenSizes));
        TaskProvider<ManifestProcessorTask> processManifestTask = this.createMergeManifestTask(creationConfig);
        MutableTaskContainer taskContainer = componentProperties.getTaskContainer();
        if (taskContainer.getMicroApkTask() != null) {
            TaskFactoryUtils.dependsOn(processManifestTask, taskContainer.getMicroApkTask());
        }
    }

    protected static boolean packagesCustomClassDependencies(BaseCreationConfig creationConfig) {
        return TaskManager.appliesCustomClassTransforms(creationConfig) && !creationConfig.getVariantType().isDynamicFeature();
    }

    protected static boolean appliesCustomClassTransforms(BaseCreationConfig creationConfig) {
        if (creationConfig instanceof ApkCreationConfig) {
            return ((ApkCreationConfig)creationConfig).getDebuggable() && !creationConfig.getVariantType().isForTesting() && !TaskManager.getAdvancedProfilingTransforms(creationConfig.getServices().getProjectOptions()).isEmpty();
        }
        return false;
    }

    private static List<String> getAdvancedProfilingTransforms(ProjectOptions options) {
        String string = options.get(StringOption.IDE_ANDROID_CUSTOM_CLASS_TRANSFORMS);
        if (string == null) {
            return ImmutableList.of();
        }
        return Splitter.on((char)',').splitToList((CharSequence)string);
    }

    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTask(ApkCreationConfig creationConfig) {
        return this.taskFactory.register(new ProcessApplicationManifest.CreationAction(creationConfig, !TaskManager.getAdvancedProfilingTransforms(creationConfig.getServices().getProjectOptions()).isEmpty()));
    }

    protected void createProcessTestManifestTask(ComponentPropertiesImpl componentProperties, VariantPropertiesImpl testedVariant) {
        Provider mergedManifest = testedVariant.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_MANIFESTS.INSTANCE);
        this.taskFactory.register(new ProcessTestManifest.CreationAction(componentProperties, (FileCollection)this.project.files(new Object[]{mergedManifest})));
    }

    public void createRenderscriptTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getBuildFeatures().getRenderScript()) {
            MutableTaskContainer taskContainer = componentProperties.getTaskContainer();
            TaskProvider<RenderscriptCompile> rsTask = this.taskFactory.register(new RenderscriptCompile.CreationAction(componentProperties));
            VariantDslInfo variantDslInfo = componentProperties.getVariantDslInfo();
            TaskFactoryUtils.dependsOn(taskContainer.getResourceGenTask(), rsTask);
            if (!variantDslInfo.getRenderscriptNdkModeEnabled()) {
                TaskFactoryUtils.dependsOn(taskContainer.getSourceGenTask(), rsTask);
            }
        }
    }

    public void createMergeResourcesTask(ComponentPropertiesImpl componentProperties, boolean processResources2, ImmutableSet<MergeResources.Flag> flags) {
        boolean alsoOutputNotCompiledResources = componentProperties.getVariantType().isApk() && !componentProperties.getVariantType().isForTesting() && componentProperties.getVariantScope().useResourceShrinker();
        this.basicCreateMergeResourcesTask(componentProperties, MergeType.MERGE, null, true, processResources2, alsoOutputNotCompiledResources, flags, null);
    }

    public TaskProvider<MergeResources> basicCreateMergeResourcesTask(ComponentPropertiesImpl componentProperties, MergeType mergeType, File outputLocation, boolean includeDependencies, boolean processResources2, boolean alsoOutputNotCompiledResources, ImmutableSet<MergeResources.Flag> flags, TaskProviderCallback<MergeResources> taskProviderCallback) {
        String taskNamePrefix = mergeType.name().toLowerCase(Locale.ENGLISH);
        File mergedNotCompiledDir = alsoOutputNotCompiledResources ? new File(this.globalScope.getIntermediatesDir() + "/merged-not-compiled-resources/" + componentProperties.getDirName()) : null;
        TaskProvider<MergeResources> mergeResourcesTask = this.taskFactory.register(new MergeResources.CreationAction(componentProperties, mergeType, taskNamePrefix, mergedNotCompiledDir, includeDependencies, processResources2, flags, this.isLibrary()), null, null, taskProviderCallback);
        componentProperties.getArtifacts().producesDir(mergeType.getOutputType(), mergeResourcesTask, MergeResources::getOutputDir, ((File)MoreObjects.firstNonNull((Object)outputLocation, (Object)componentProperties.getPaths().getDefaultMergeResourcesOutputDir())).getAbsolutePath(), "");
        if (alsoOutputNotCompiledResources) {
            componentProperties.getArtifacts().producesDir(InternalArtifactType.MERGED_NOT_COMPILED_RES.INSTANCE, mergeResourcesTask, MergeResources::getMergedNotCompiledResourcesOutputDirectory, mergedNotCompiledDir.getAbsolutePath(), "");
        }
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getCompileTask(), mergeResourcesTask);
        }
        return mergeResourcesTask;
    }

    public void createMergeAssetsTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(new MergeSourceSetFolders.MergeAppAssetCreationAction(componentProperties));
    }

    public void createMergeJniLibFoldersTasks(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(new MergeSourceSetFolders.MergeJniLibFoldersCreationAction(componentProperties));
        Set<QualifiedContent.ScopeType> mergeScopes = this.getJavaResMergingScopes(componentProperties, ExtendedContentType.NATIVE_LIBS);
        this.taskFactory.register(new MergeNativeLibsTask.CreationAction(mergeScopes, componentProperties));
    }

    public void createBuildConfigTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getBuildFeatures().getBuildConfig()) {
            TaskProvider<GenerateBuildConfig> generateBuildConfigTask = this.taskFactory.register(new GenerateBuildConfig.CreationAction(componentProperties));
            TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getSourceGenTask(), generateBuildConfigTask);
        }
    }

    public void createGenerateResValuesTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getBuildFeatures().getResValues()) {
            TaskProvider<GenerateResValues> generateResValuesTask = this.taskFactory.register(new GenerateResValues.CreationAction(componentProperties));
            TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getResourceGenTask(), generateResValuesTask);
        }
    }

    public void createMlkitTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_MLKIT)) {
            TaskProvider<GenerateMlModelClass> generateMlModelClassTask = this.taskFactory.register(new GenerateMlModelClass.CreationAction(componentProperties));
            TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getSourceGenTask(), generateMlModelClassTask);
        }
    }

    public void createApkProcessResTask(ComponentPropertiesImpl componentProperties) {
        VariantType variantType = componentProperties.getVariantType();
        InternalArtifactType.FEATURE_RESOURCE_PKG packageOutputType = variantType.isApk() && !variantType.isForTesting() ? InternalArtifactType.FEATURE_RESOURCE_PKG.INSTANCE : null;
        this.createApkProcessResTask(componentProperties, packageOutputType);
        if (componentProperties.getVariantScope().consumesFeatureJars()) {
            this.taskFactory.register(new MergeAaptProguardFilesCreationAction(componentProperties));
        }
    }

    private void createApkProcessResTask(ComponentPropertiesImpl componentProperties, SingleArtifactType<Directory> packageOutputType) {
        GlobalScope globalScope = componentProperties.getGlobalScope();
        this.createProcessResTask(componentProperties, packageOutputType, MergeType.MERGE, globalScope.getProjectBaseName());
        if (componentProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_APP_COMPILE_TIME_R_CLASS) && !componentProperties.getVariantType().isForTesting() && !globalScope.getExtension().getAaptOptions().getNamespaced()) {
            this.createProcessResTask(componentProperties, packageOutputType, MergeType.PACKAGE, globalScope.getProjectBaseName());
        }
    }

    protected boolean isLibrary() {
        return false;
    }

    public void createProcessResTask(BaseCreationConfig creationConfig, SingleArtifactType<Directory> packageOutputType, MergeType mergeType, String baseName2) {
        VariantScope scope = creationConfig.getVariantScope();
        ComponentPropertiesImpl componentPropertiesImpl = (ComponentPropertiesImpl)creationConfig;
        BaseVariantData variantData = componentPropertiesImpl.getVariantData();
        variantData.calculateFilters(creationConfig.getGlobalScope().getExtension().getSplits());
        boolean useAaptToGenerateLegacyMultidexMainDexProguardRules = creationConfig.getNeedsMainDexList();
        if (creationConfig.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) {
            new NamespacedResourcesTaskManager(this.globalScope, this.taskFactory, componentPropertiesImpl).createNamespacedResourceTasks(packageOutputType, baseName2, useAaptToGenerateLegacyMultidexMainDexProguardRules);
            ConfigurableFileCollection rFiles = this.project.files(new Object[]{creationConfig.getArtifacts().getFinalProduct(InternalArtifactType.RUNTIME_R_CLASS_CLASSES.INSTANCE)});
            creationConfig.getTransformManager().addStream(OriginalStream.builder(this.project, "final-r-classes").addContentTypes((Set<QualifiedContent.ContentType>)(scope.getNeedsJavaResStreams() ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)rFiles).build());
            creationConfig.getArtifacts().appendToAllClasses((FileCollection)rFiles);
            return;
        }
        this.createNonNamespacedResourceTasks(componentPropertiesImpl, packageOutputType, mergeType, baseName2, useAaptToGenerateLegacyMultidexMainDexProguardRules);
    }

    private void createNonNamespacedResourceTasks(ComponentPropertiesImpl componentProperties, SingleArtifactType<Directory> packageOutputType, MergeType mergeType, String baseName2, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        BuildArtifactsHolder artifacts2 = componentProperties.getArtifacts();
        ProjectOptions projectOptions = componentProperties.getServices().getProjectOptions();
        if (mergeType == MergeType.PACKAGE) {
            this.taskFactory.register(new ParseLibraryResourcesTask.CreateAction(componentProperties));
            if (TaskManager.generatesProguardOutputFile(componentProperties) && this.isLibrary()) {
                this.taskFactory.register(new GenerateLibraryProguardRulesTask.CreationAction(componentProperties));
            }
            this.taskFactory.register(new GenerateLibraryRFileTask.CreationAction(componentProperties, this.isLibrary()));
            if (!componentProperties.getVariantDslInfo().isDebuggable() && projectOptions.get(BooleanOption.ENABLE_RESOURCE_OPTIMIZATIONS)) {
                if (componentProperties.getVariantScope().useResourceShrinker()) {
                    this.taskFactory.register(new OptimizeResourcesTask.CreateAction(componentProperties));
                    componentProperties.getArtifacts().republish(InternalArtifactType.OPTIMIZED_PROCESSED_RES.INSTANCE, InternalArtifactType.PROCESSED_RES.INSTANCE);
                } else {
                    this.logger.error("Cannot apply AAPT2 OPTIMIZE without resource shrinker being enabled.");
                }
            }
        } else {
            this.taskFactory.register(new LinkApplicationAndroidResourcesTask.CreationAction(componentProperties, useAaptToGenerateLegacyMultidexMainDexProguardRules, mergeType, baseName2, this.isLibrary()));
            if (packageOutputType != null) {
                artifacts2.republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
            }
            this.taskFactory.register(new LinkAndroidResForBundleTask.CreationAction(componentProperties));
            if (!projectOptions.get(BooleanOption.GENERATE_R_JAVA)) {
                componentProperties.getArtifacts().appendToAllClasses((FileCollection)this.project.files(new Object[]{artifacts2.getFinalProductAsFileCollection(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE)}));
            }
        }
    }

    private static boolean generatesProguardOutputFile(ComponentPropertiesImpl componentProperties) {
        return componentProperties.getVariantScope().getCodeShrinker() != null || componentProperties.getVariantType().isDynamicFeature();
    }

    protected abstract Set<QualifiedContent.ScopeType> getJavaResMergingScopes(ComponentPropertiesImpl var1, QualifiedContent.ContentType var2);

    public void createProcessJavaResTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(new ProcessJavaResTask.CreationAction(componentProperties));
        if (componentProperties.getVariantScope().getNeedsJavaResStreams()) {
            componentProperties.getTransformManager().addStream(OriginalStream.builder(this.project, "processed-java-res").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)componentProperties.getGlobalScope().getProject().files(new Object[]{componentProperties.getArtifacts().getFinalProduct(InternalArtifactType.JAVA_RES.INSTANCE)})).build());
        }
    }

    public void createMergeJavaResTask(ComponentPropertiesImpl componentProperties) {
        TransformManager transformManager = componentProperties.getTransformManager();
        Set<QualifiedContent.ScopeType> mergeScopes = this.getJavaResMergingScopes(componentProperties, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES);
        this.taskFactory.register(new MergeJavaResourceTask.CreationAction(mergeScopes, componentProperties));
        if (componentProperties.getVariantScope().getNeedsMergedJavaResStream()) {
            Provider mergedJavaResProvider = componentProperties.getArtifacts().getFinalProduct(InternalArtifactType.MERGED_JAVA_RES.INSTANCE);
            transformManager.addStream(OriginalStream.builder(this.project, "merged-java-res").addContentTypes(TransformManager.CONTENT_RESOURCES).addScopes(mergeScopes).setFileCollection(this.project.getLayout().files(new Object[]{mergedJavaResProvider})).build());
        }
    }

    public void createAidlTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getBuildFeatures().getAidl()) {
            MutableTaskContainer taskContainer = componentProperties.getTaskContainer();
            TaskProvider<AidlCompile> aidlCompileTask = this.taskFactory.register(new AidlCompile.CreationAction(componentProperties));
            TaskFactoryUtils.dependsOn(taskContainer.getSourceGenTask(), aidlCompileTask);
        }
    }

    public void createShaderTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getBuildFeatures().getShaders()) {
            this.taskFactory.register(new MergeSourceSetFolders.MergeShaderSourceFoldersCreationAction(componentProperties));
            TaskProvider<ShaderCompile> shaderCompileTask = this.taskFactory.register(new ShaderCompile.CreationAction(componentProperties));
            TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getAssetGenTask(), shaderCompileTask);
        }
    }

    protected abstract void postJavacCreation(ComponentPropertiesImpl var1);

    public TaskProvider<? extends JavaCompile> createJavacTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(new JavaPreCompileTask.CreationAction(componentProperties));
        TaskProvider<JavaCompile> javacTask = this.taskFactory.register(new JavaCompileCreationAction(componentProperties));
        this.postJavacCreation(componentProperties);
        return javacTask;
    }

    protected void addJavacClassesStream(ComponentPropertiesImpl componentProperties) {
        BuildArtifactsHolder artifacts2 = componentProperties.getArtifacts();
        Provider javaOutputs = artifacts2.getFinalProduct(InternalArtifactType.JAVAC.INSTANCE);
        Preconditions.checkNotNull(javaOutputs);
        TransformManager transformManager = componentProperties.getTransformManager();
        boolean needsJavaResStreams = componentProperties.getVariantScope().getNeedsJavaResStreams();
        transformManager.addStream(OriginalStream.builder(this.project, "javac-output").addContentTypes((Set<QualifiedContent.ContentType>)(needsJavaResStreams ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(this.project.getLayout().files(new Object[]{javaOutputs})).build());
        BaseVariantData variantData = componentProperties.getVariantData();
        transformManager.addStream(OriginalStream.builder(this.project, "pre-javac-generated-bytecode").addContentTypes((Set<QualifiedContent.ContentType>)(needsJavaResStreams ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)variantData.getAllPreJavacGeneratedBytecode()).build());
        transformManager.addStream(OriginalStream.builder(this.project, "post-javac-generated-bytecode").addContentTypes((Set<QualifiedContent.ContentType>)(needsJavaResStreams ? TransformManager.CONTENT_JARS : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES))).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)variantData.getAllPostJavacGeneratedBytecode()).build());
    }

    public static void setJavaCompilerTask(TaskProvider<? extends JavaCompile> javaCompilerTask, ComponentPropertiesImpl componentProperties) {
        TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getCompileTask(), javaCompilerTask);
    }

    public void createExternalNativeBuildJsonGenerators(ComponentPropertiesImpl componentProperties) {
        CxxModuleModel module2 = TryCreateCxxModuleModelKt.tryCreateCxxModuleModel(componentProperties.getGlobalScope());
        if (module2 == null) {
            return;
        }
        componentProperties.getTaskContainer().setExternalNativeJsonGenerator((Provider<ExternalNativeJsonGenerator>)this.project.provider(() -> ExternalNativeJsonGenerator.create(module2, componentProperties)));
    }

    public void createExternalNativeBuildTasks(ComponentPropertiesImpl componentProperties) {
        MutableTaskContainer taskContainer = componentProperties.getTaskContainer();
        Provider<ExternalNativeJsonGenerator> generator = taskContainer.getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        TaskProvider generateTask = this.taskFactory.register(ExternalNativeBuildJsonTask.createTaskConfigAction(generator, componentProperties));
        TaskProvider<ExternalNativeBuildTask> buildTask = this.taskFactory.register(new ExternalNativeBuildTask.CreationAction(generator, generateTask, componentProperties));
        TaskFactoryUtils.dependsOn(taskContainer.getCompileTask(), buildTask);
        TaskProvider<Task> cleanTask = this.taskFactory.named("clean");
        CxxModuleModel module2 = TryCreateCxxModuleModelKt.tryCreateCxxModuleModel(componentProperties.getGlobalScope());
        if (module2 != null) {
            TaskProvider<ExternalNativeCleanTask> externalNativeCleanTask = this.taskFactory.register(new ExternalNativeCleanTask.CreationAction(module2, componentProperties));
            TaskFactoryUtils.dependsOn(cleanTask, externalNativeCleanTask);
        }
    }

    private void createUnitTestVariantTasks(UnitTestPropertiesImpl unitTestProperties2) {
        BuildArtifactsHolder artifacts2 = unitTestProperties2.getArtifacts();
        MutableTaskContainer taskContainer = unitTestProperties2.getTaskContainer();
        VariantPropertiesImpl testedVariant = unitTestProperties2.getTestedVariant();
        boolean includeAndroidResources = this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources();
        this.createAnchorTasks(unitTestProperties2);
        this.createDependencyStreams(unitTestProperties2);
        this.createProcessJavaResTask(unitTestProperties2);
        if (includeAndroidResources) {
            if (testedVariant.getVariantType().isAar()) {
                this.createProcessTestManifestTask(unitTestProperties2, testedVariant);
                this.createGenerateResValuesTask(unitTestProperties2);
                this.createMergeAssetsTask(unitTestProperties2);
                this.createMergeResourcesTask(unitTestProperties2, true, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
                this.createApkProcessResTask(unitTestProperties2, InternalArtifactType.FEATURE_RESOURCE_PKG.INSTANCE);
                this.taskFactory.register(new PackageForUnitTest.CreationAction(unitTestProperties2));
                this.createDataBindingTasksIfNecessary(unitTestProperties2);
            } else if (testedVariant.getVariantType().isApk()) {
                artifacts2.copy(InternalArtifactType.PROCESSED_RES.INSTANCE, testedVariant.getArtifacts());
                artifacts2.copy(InternalArtifactType.MERGED_ASSETS.INSTANCE, testedVariant.getArtifacts());
                this.taskFactory.register(new PackageForUnitTest.CreationAction(unitTestProperties2));
            } else {
                throw new IllegalStateException("Tested variant " + testedVariant.getName() + " in " + this.globalScope.getProject().getPath() + " must be a library or an application to have unit tests.");
            }
            TaskProvider<GenerateTestConfig> generateTestConfig = this.taskFactory.register(new GenerateTestConfig.CreationAction(unitTestProperties2));
            TaskProvider<? extends Task> compileTask = taskContainer.getCompileTask();
            TaskFactoryUtils.dependsOn(compileTask, generateTestConfig);
            compileTask.configure(task -> {
                GenerateTestConfig.TestConfigInputs testConfigInputs = new GenerateTestConfig.TestConfigInputs(unitTestProperties2);
                TaskInputs taskInputs = task.getInputs();
                taskInputs.property("isUseRelativePathEnabled", (Object)testConfigInputs.isUseRelativePathEnabled());
                taskInputs.files(new Object[]{testConfigInputs.getResourceApk()}).withPropertyName("resourceApk").optional().withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.files(new Object[]{testConfigInputs.getMergedAssets()}).withPropertyName("mergedAssets").withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.files(new Object[]{testConfigInputs.getMergedManifest()}).withPropertyName("mergedManifest").withPathSensitivity(PathSensitivity.RELATIVE);
                taskInputs.property("mainVariantOutput", (Object)testConfigInputs.getMainVariantOutput());
                taskInputs.property("packageNameOfFinalRClassProvider", testConfigInputs::getPackageNameOfFinalRClass);
            });
        } else if (testedVariant.getVariantType().isAar()) {
            this.taskFactory.register(new GenerateLibraryRFileTask.TestRuntimeStubRClassCreationAction(unitTestProperties2));
        }
        TaskProvider<? extends Task> compileTask = taskContainer.getCompileTask();
        TaskFactoryUtils.dependsOn(compileTask, taskContainer.getProcessJavaResourcesTask(), testedVariant.getTaskContainer().getProcessJavaResourcesTask());
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(unitTestProperties2);
        this.addJavacClassesStream(unitTestProperties2);
        TaskManager.setJavaCompilerTask(javacTask, unitTestProperties2);
        this.createRunUnitTestTask(unitTestProperties2);
        taskContainer.getAssembleTask().configure(task -> task.setGroup(null));
    }

    protected void registerRClassTransformStream(ComponentPropertiesImpl componentProperties) {
        if (this.globalScope.getExtension().getAaptOptions().getNamespaced() || componentProperties.getServices().getProjectOptions().get(BooleanOption.GENERATE_R_JAVA)) {
            return;
        }
        Provider<FileCollection> rClassJar = componentProperties.getArtifacts().getFinalProductAsFileCollection(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
        componentProperties.getTransformManager().addStream(OriginalStream.builder(this.project, "compile-and-runtime-light-r-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)this.project.files(new Object[]{rClassJar})).build());
    }

    private void createAndroidTestVariantTasks(AndroidTestPropertiesImpl androidTestProperties2) {
        this.createAnchorTasks(androidTestProperties2);
        this.createDependencyStreams(androidTestProperties2);
        this.createProcessTestManifestTask(androidTestProperties2, androidTestProperties2.getTestedVariant());
        this.createGenerateResValuesTask(androidTestProperties2);
        this.createRenderscriptTask(androidTestProperties2);
        this.createMergeResourcesTask(androidTestProperties2, true, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
        this.createShaderTask(androidTestProperties2);
        this.createMergeAssetsTask(androidTestProperties2);
        this.createBuildConfigTask(androidTestProperties2);
        this.createApkProcessResTask(androidTestProperties2);
        this.registerRClassTransformStream(androidTestProperties2);
        this.createProcessJavaResTask(androidTestProperties2);
        this.createAidlTask(androidTestProperties2);
        this.createMergeJniLibFoldersTasks(androidTestProperties2);
        this.createDataBindingTasksIfNecessary(androidTestProperties2);
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(androidTestProperties2);
        this.addJavacClassesStream(androidTestProperties2);
        TaskManager.setJavaCompilerTask(javacTask, androidTestProperties2);
        this.createPostCompilationTasks(androidTestProperties2);
        this.createValidateSigningTask(androidTestProperties2);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(androidTestProperties2));
        this.createPackagingTask(androidTestProperties2);
        this.taskFactory.configure(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleTest -> assembleTest.dependsOn(new Object[]{androidTestProperties2.getTaskContainer().getAssembleTask().getName()})));
        this.createConnectedTestForVariant(androidTestProperties2);
    }

    public void createLintTasks(VariantPropertiesT variantProperties, List<ComponentInfo<VariantT, VariantPropertiesT>> allVariants) {
        this.taskFactory.register(new LintPerVariantTask.CreationAction((VariantPropertiesImpl)variantProperties, allVariants.stream().map(ComponentInfo::getProperties).collect(Collectors.toList())));
    }

    private String getTaskPath(String taskName) {
        return this.project.getRootProject() == this.project ? ':' + taskName : this.project.getPath() + ':' + taskName;
    }

    public void maybeCreateLintVitalTask(VariantPropertiesT variant2, List<ComponentInfo<VariantT, VariantPropertiesT>> allVariants) {
        if (((ComponentPropertiesImpl)variant2).getVariantDslInfo().isDebuggable() || !this.extension.getLintOptions().isCheckReleaseBuilds()) {
            return;
        }
        TaskProvider<LintPerVariantTask> lintReleaseCheck = this.taskFactory.register(new LintPerVariantTask.VitalCreationAction((ComponentPropertiesImpl)variant2, allVariants.stream().map(ComponentInfo::getProperties).collect(Collectors.toList())), null, task -> task.dependsOn(new Object[]{variant2.getTaskContainer().getJavacTask()}), null);
        TaskFactoryUtils.dependsOn(((ComponentPropertiesImpl)variant2).getTaskContainer().getAssembleTask(), lintReleaseCheck);
        this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(this.getTaskPath(LINT))) {
                this.project.getTasks().getByName(lintReleaseCheck.getName()).setEnabled(false);
            }
        });
    }

    private void createRunUnitTestTask(UnitTestPropertiesImpl unitTestProperties2) {
        TaskProvider<AndroidUnitTest> runTestsTask = this.taskFactory.register(new AndroidUnitTest.CreationAction(unitTestProperties2));
        this.taskFactory.configure("test", (Action<? super Task>)((Action)test -> test.dependsOn(new Object[]{runTestsTask})));
    }

    private void createTopLevelTestTasks() {
        Object deviceAndroidTestTask;
        Object connectedAndroidTestTask;
        this.createMockableJarTask();
        ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        if (this.hasFlavors) {
            connectedAndroidTestTask = this.taskFactory.register(new AndroidReportTask.CreationAction(this.globalScope, AndroidReportTask.CreationAction.TaskKind.CONNECTED));
            reportTasks.add(connectedAndroidTestTask.getName());
        } else {
            connectedAndroidTestTask = this.taskFactory.register(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedTask -> {
                connectedTask.setGroup("verification");
                connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
            }));
        }
        this.taskFactory.configure(CONNECTED_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{connectedAndroidTestTask.getName()})));
        if (providers.size() > 1 || this.hasFlavors) {
            deviceAndroidTestTask = this.taskFactory.register(new AndroidReportTask.CreationAction(this.globalScope, AndroidReportTask.CreationAction.TaskKind.DEVICE_PROVIDER));
            reportTasks.add(deviceAndroidTestTask.getName());
        } else {
            deviceAndroidTestTask = this.taskFactory.register(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)providerTask -> {
                providerTask.setGroup("verification");
                providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
            }));
        }
        this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{deviceAndroidTestTask.getName()})));
        this.taskFactory.register("test", (Action<? super Task>)((Action)unitTestTask -> {
            unitTestTask.setGroup("verification");
            unitTestTask.setDescription("Run unit tests for all variants.");
        }));
        this.taskFactory.configure("check", (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{"test"})));
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
                for (String reportTask : reportTasks) {
                    if (!taskGraph.hasTask(this.getTaskPath(reportTask))) continue;
                    this.taskFactory.configure(reportTask, (Action<? super Task>)((Action)task -> ((AndroidReportTask)task).setWillRun()));
                }
            });
        }
    }

    protected void createConnectedTestForVariant(AndroidTestPropertiesImpl androidTestProperties2) {
        AbstractTestDataImpl testData;
        VariantPropertiesImpl testedVariant = androidTestProperties2.getTestedVariant();
        boolean isLibrary = testedVariant.getVariantType().isAar();
        if (testedVariant.getVariantType().isDynamicFeature()) {
            testData = new BundleTestDataImpl(androidTestProperties2, androidTestProperties2.getArtifacts().getFinalProduct(InternalArtifactType.APK.INSTANCE), FeatureSplitUtils.getFeatureName(this.globalScope.getProject().getPath()), testedVariant.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.APKS_FROM_BUNDLE));
        } else {
            ConfigurableFileCollection testedApkFileCollection = this.project.files(new Object[]{testedVariant.getArtifacts().getFinalProduct(InternalArtifactType.APK.INSTANCE)});
            testData = new TestDataImpl(androidTestProperties2, androidTestProperties2.getArtifacts().getFinalProduct(InternalArtifactType.APK.INSTANCE), (FileCollection)(isLibrary ? null : testedApkFileCollection));
        }
        this.configureTestData(androidTestProperties2, testData);
        TaskProvider<DeviceProviderInstrumentTestTask> connectedTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(androidTestProperties2, new ConnectedDeviceProvider(() -> (File)this.globalScope.getSdkComponents().getAdbExecutableProvider().get(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), DeviceProviderInstrumentTestTask.CreationAction.Type.INTERNAL_CONNECTED_DEVICE_PROVIDER, testData, (FileCollection)this.project.files(new Object[0])));
        this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{connectedTask})));
        if (testedVariant.getVariantDslInfo().isTestCoverageEnabled()) {
            Configuration jacocoAntConfiguration = JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, JacocoTask.getJacocoVersion(androidTestProperties2));
            Iterator<DeviceProvider> reportTask = this.taskFactory.register(new JacocoReportTask.CreationAction(androidTestProperties2, jacocoAntConfiguration));
            TaskFactoryUtils.dependsOn(testedVariant.getTaskContainer().getCoverageReportTask(), reportTask);
            this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{reportTask})));
        }
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        for (DeviceProvider deviceProvider : providers) {
            TaskProvider<DeviceProviderInstrumentTestTask> providerTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(androidTestProperties2, deviceProvider, DeviceProviderInstrumentTestTask.CreationAction.Type.CUSTOM_DEVICE_PROVIDER, testData, (FileCollection)this.project.files(new Object[0])));
            this.taskFactory.configure(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{providerTask})));
        }
        List<TestServer> servers = this.extension.getTestServers();
        for (TestServer testServer : servers) {
            TaskProvider<TestServerTask> serverTask = this.taskFactory.register(new TestServerTask.TestServerTaskCreationAction(androidTestProperties2, testServer));
            TaskFactoryUtils.dependsOn(serverTask, androidTestProperties2.getTaskContainer().getAssembleTask());
            this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{serverTask})));
        }
    }

    public void createPostCompilationTasks(ApkCreationConfig creationConfig) {
        boolean isTestCoverageEnabled;
        ComponentPropertiesImpl componentProperties = (ComponentPropertiesImpl)((Object)creationConfig);
        Preconditions.checkNotNull(componentProperties.getTaskContainer().getJavacTask());
        VariantDslInfo variantDslInfo = componentProperties.getVariantDslInfo();
        VariantScope variantScope = componentProperties.getVariantScope();
        TransformManager transformManager = componentProperties.getTransformManager();
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(componentProperties));
        boolean bl = isTestCoverageEnabled = variantDslInfo.isTestCoverageEnabled() && !componentProperties.getVariantType().isForTesting();
        if (isTestCoverageEnabled) {
            this.createJacocoTask(componentProperties);
        }
        this.maybeCreateDesugarTask(componentProperties, componentProperties.getMinSdkVersion(), transformManager, isTestCoverageEnabled);
        BaseExtension extension = componentProperties.getGlobalScope().getExtension();
        this.createMergeJavaResTask(componentProperties);
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        boolean registeredExternalTransform = false;
        int count = customTransforms.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Transform transform2 = customTransforms.get(i2);
            List<Object> deps = customTransformsDependencies.get(i2);
            registeredExternalTransform |= transformManager.addTransform(this.taskFactory, componentProperties, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(componentProperties.getTaskContainer().getAssembleTask(), taskProvider);
                }
            }).isPresent();
        }
        if (componentProperties.getVariantType().isDynamicFeature() || variantScope.consumesFeatureJars()) {
            this.taskFactory.register(new MergeClassesTask.CreationAction(componentProperties));
        }
        if (TaskManager.appliesCustomClassTransforms(componentProperties)) {
            for (String jar : TaskManager.getAdvancedProfilingTransforms(componentProperties.getServices().getProjectOptions())) {
                if (jar == null) continue;
                transformManager.addTransform(this.taskFactory, componentProperties, new CustomClassTransform(jar, TaskManager.packagesCustomClassDependencies(componentProperties)));
            }
        }
        this.maybeCreateCheckDuplicateClassesTask(componentProperties);
        this.maybeCreateJavaCodeShrinkerTask(componentProperties);
        if (componentProperties.getVariantScope().getCodeShrinker() == CodeShrinker.R8) {
            this.maybeCreateResourcesShrinkerTasks(componentProperties);
            this.maybeCreateDexDesugarLibTask(componentProperties, false);
            return;
        }
        DexingType dexingType = creationConfig.getDexingType();
        if (dexingType == DexingType.LEGACY_MULTIDEX && variantDslInfo.isMultiDexEnabled() && variantDslInfo.getMinSdkVersionWithTargetDeviceApi().getFeatureLevel() >= 21) {
            dexingType = DexingType.NATIVE_MULTIDEX;
        }
        if (componentProperties.getNeedsMainDexList()) {
            this.taskFactory.register(new D8MainDexListTask.CreationAction(componentProperties, false));
        }
        if (variantScope.getNeedsMainDexListForBundle()) {
            this.taskFactory.register(new D8MainDexListTask.CreationAction(componentProperties, true));
        }
        this.createDexTasks(componentProperties, dexingType, registeredExternalTransform);
        this.maybeCreateResourcesShrinkerTasks(componentProperties);
        this.maybeCreateDexSplitterTask(creationConfig);
    }

    private void maybeCreateDesugarTask(ComponentPropertiesImpl componentProperties, AndroidVersion minSdk, TransformManager transformManager, boolean isTestCoverageEnabled) {
        VariantScope variantScope = componentProperties.getVariantScope();
        if (variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.DESUGAR) {
            componentProperties.getTransformManager().consumeStreams((Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES), TransformManager.CONTENT_CLASS);
            this.taskFactory.register(new RecalculateStackFramesTask.CreationAction(componentProperties, isTestCoverageEnabled));
            this.taskFactory.register(new DesugarTask.CreationAction(componentProperties));
            if (minSdk.getFeatureLevel() >= 19) {
                return;
            }
            QualifiedContent.ScopeType testedType = (QualifiedContent.ScopeType)componentProperties.onTestedConfig(testedConfig -> {
                if (!testedConfig.getVariantType().isAar()) {
                    return QualifiedContent.Scope.PROVIDED_ONLY;
                }
                return null;
            });
            QualifiedContent.ScopeType scopeType = testedType != null ? testedType : QualifiedContent.Scope.EXTERNAL_LIBRARIES;
            TaskProvider<ExtractTryWithResourcesSupportJar> extractTryWithResources = this.taskFactory.register(new ExtractTryWithResourcesSupportJar.CreationAction(componentProperties));
            variantScope.getTryWithResourceRuntimeSupportJar().builtBy(new Object[]{extractTryWithResources});
            transformManager.addStream(OriginalStream.builder(this.project, "runtime-deps-try-with-resources").addContentTypes(TransformManager.CONTENT_CLASS).addScope(scopeType).setFileCollection((FileCollection)variantScope.getTryWithResourceRuntimeSupportJar()).build());
        }
    }

    private void createDexTasks(ComponentPropertiesImpl componentProperties, DexingType dexingType, boolean registeredExternalTransform) {
        DexOptions dexOptions;
        VariantType variantType = componentProperties.getVariantType();
        if (variantType.isTestComponent()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        VariantScope.Java8LangSupport java8SLangSupport = componentProperties.getVariantScope().getJava8LangSupportType();
        boolean minified = componentProperties.getVariantScope().getCodeShrinker() != null;
        boolean supportsDesugaring = java8SLangSupport == VariantScope.Java8LangSupport.UNUSED || java8SLangSupport == VariantScope.Java8LangSupport.D8 && componentProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_DEXING_DESUGARING_ARTIFACT_TRANSFORM);
        boolean enableDexingArtifactTransform = componentProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_DEXING_ARTIFACT_TRANSFORM) && !registeredExternalTransform && !minified && supportsDesugaring && !TaskManager.appliesCustomClassTransforms(componentProperties);
        this.taskFactory.register(new DexArchiveBuilderTask.CreationAction((com.android.builder.core.DexOptions)dexOptions, enableDexingArtifactTransform, componentProperties));
        this.maybeCreateDexDesugarLibTask(componentProperties, enableDexingArtifactTransform);
        this.createDexMergingTasks(componentProperties, dexingType, enableDexingArtifactTransform);
    }

    private void createDexMergingTasks(ComponentPropertiesImpl componentProperties, DexingType dexingType, boolean dexingUsingArtifactTransforms) {
        DexMergingTask.CreationAction configAction;
        boolean separateFileDependenciesDexingTask;
        boolean bl = separateFileDependenciesDexingTask = componentProperties.getVariantScope().getJava8LangSupportType() == VariantScope.Java8LangSupport.D8 && dexingUsingArtifactTransforms;
        if (separateFileDependenciesDexingTask) {
            DexFileDependenciesTask.CreationAction desugarFileDeps = new DexFileDependenciesTask.CreationAction(componentProperties);
            this.taskFactory.register(desugarFileDeps);
        }
        if (dexingType == DexingType.LEGACY_MULTIDEX) {
            configAction = new DexMergingTask.CreationAction(componentProperties, DexMergingAction.MERGE_ALL, dexingType, dexingUsingArtifactTransforms, separateFileDependenciesDexingTask);
            this.taskFactory.register(configAction);
        } else if (componentProperties.getVariantScope().getCodeShrinker() != null) {
            configAction = new DexMergingTask.CreationAction(componentProperties, DexMergingAction.MERGE_ALL, dexingType, dexingUsingArtifactTransforms);
            this.taskFactory.register(configAction);
        } else {
            boolean produceSeparateOutputs = dexingType == DexingType.NATIVE_MULTIDEX && componentProperties.getVariantDslInfo().isDebuggable();
            this.taskFactory.register(new DexMergingTask.CreationAction(componentProperties, DexMergingAction.MERGE_EXTERNAL_LIBS, DexingType.NATIVE_MULTIDEX, dexingUsingArtifactTransforms, separateFileDependenciesDexingTask, produceSeparateOutputs ? MultipleArtifactType.DEX.INSTANCE : MultipleArtifactType.EXTERNAL_LIBS_DEX.INSTANCE));
            if (produceSeparateOutputs) {
                DexMergingTask.CreationAction mergeProject = new DexMergingTask.CreationAction(componentProperties, DexMergingAction.MERGE_PROJECT, dexingType, dexingUsingArtifactTransforms);
                this.taskFactory.register(mergeProject);
                DexMergingTask.CreationAction mergeLibraries = new DexMergingTask.CreationAction(componentProperties, DexMergingAction.MERGE_LIBRARY_PROJECTS, dexingType, dexingUsingArtifactTransforms);
                this.taskFactory.register(mergeLibraries);
            } else {
                DexMergingTask.CreationAction configAction2 = new DexMergingTask.CreationAction(componentProperties, DexMergingAction.MERGE_ALL, dexingType, dexingUsingArtifactTransforms);
                this.taskFactory.register(configAction2);
            }
        }
    }

    protected void handleJacocoDependencies(ComponentPropertiesImpl componentProperties) {
        boolean isTestCoverageEnabled;
        VariantDslInfo variantDslInfo = componentProperties.getVariantDslInfo();
        boolean bl = isTestCoverageEnabled = variantDslInfo.isTestCoverageEnabled() && (!componentProperties.getVariantType().isTestComponent() || variantDslInfo.getTestedVariant() != null && variantDslInfo.getTestedVariant().getVariantType().isAar());
        if (isTestCoverageEnabled) {
            if (componentProperties.getVariantScope().getDexer() == DexerTool.DX) {
                componentProperties.getServices().getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, String.format("Jacoco version is downgraded to %s because dx is used. This is due to -P%s=false flag. See https://issuetracker.google.com/37116789 for more details.", "0.7.4.201502262128", BooleanOption.ENABLE_D8.getPropertyName()));
            }
            String jacocoAgentRuntimeDependency = JacocoConfigurations.getAgentRuntimeDependency(JacocoTask.getJacocoVersion(componentProperties));
            this.project.getDependencies().add(componentProperties.getVariantDependencies().getRuntimeClasspath().getName(), (Object)jacocoAgentRuntimeDependency);
            componentProperties.getVariantDependencies().getRuntimeClasspath().resolutionStrategy(r -> r.force(new Object[]{jacocoAgentRuntimeDependency}));
        }
    }

    public void createJacocoTask(ComponentPropertiesImpl componentProperties) {
        componentProperties.getTransformManager().consumeStreams((Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES));
        this.taskFactory.register(new JacocoTask.CreationAction(componentProperties));
        ConfigurableFileCollection instumentedClasses = this.project.files(new Object[]{componentProperties.getArtifacts().getFinalProduct(InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES.INSTANCE), this.project.files(new Object[]{componentProperties.getArtifacts().getFinalProduct(InternalArtifactType.JACOCO_INSTRUMENTED_JARS.INSTANCE)}).getAsFileTree()});
        componentProperties.getTransformManager().addStream(OriginalStream.builder(this.project, "jacoco-instrumented-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)instumentedClasses).build());
    }

    protected void createDataBindingTasksIfNecessary(ComponentPropertiesImpl componentProperties) {
        boolean dataBindingEnabled = componentProperties.getBuildFeatures().getDataBinding();
        boolean viewBindingEnabled = componentProperties.getBuildFeatures().getViewBinding();
        if (!dataBindingEnabled && !viewBindingEnabled) {
            return;
        }
        this.taskFactory.register(new DataBindingMergeBaseClassLogTask.CreationAction(componentProperties));
        this.taskFactory.register(new DataBindingMergeDependencyArtifactsTask.CreationAction(componentProperties));
        this.globalScope.getDataBindingBuilder().setDebugLogEnabled(this.getLogger().isDebugEnabled());
        this.taskFactory.register(new DataBindingGenBaseClassesTask.CreationAction(componentProperties));
        if (dataBindingEnabled) {
            this.taskFactory.register(new DataBindingExportBuildInfoTask.CreationAction(componentProperties));
            this.setDataBindingAnnotationProcessorParams(componentProperties);
        }
    }

    private void setDataBindingAnnotationProcessorParams(ComponentPropertiesImpl componentProperties) {
        VariantDslInfo variantDslInfo = componentProperties.getVariantDslInfo();
        JavaCompileOptions javaCompileOptions = variantDslInfo.getJavaCompileOptions();
        com.android.build.gradle.api.AnnotationProcessorOptions processorOptions = javaCompileOptions.getAnnotationProcessorOptions();
        if (processorOptions instanceof AnnotationProcessorOptions) {
            AnnotationProcessorOptions options = (AnnotationProcessorOptions)processorOptions;
            if (!options.getClassNames().isEmpty() && !options.getClassNames().contains("android.databinding.annotationprocessor.ProcessDataBinding")) {
                options.className("android.databinding.annotationprocessor.ProcessDataBinding");
            }
            DataBindingCompilerArguments dataBindingArgs = DataBindingCompilerArguments.createArguments(componentProperties, this.getLogger().isDebugEnabled(), this.globalScope.getDataBindingBuilder().getPrintMachineReadableOutput());
            options.compilerArgumentProvider(dataBindingArgs);
        } else {
            this.getLogger().error("Cannot setup data binding for {} because java compiler options is not an instance of AnnotationProcessorOptions", (Object)processorOptions);
        }
    }

    public void createPackagingTask(ApkCreationConfig creationConfig) {
        MutableTaskContainer taskContainer = creationConfig.getTaskContainer();
        boolean signedApk = creationConfig.getVariantDslInfo().isSigningReady();
        VariantScope variantScope = creationConfig.getVariantScope();
        InternalArtifactType<Directory> manifestType = creationConfig.getManifestArtifactType();
        Provider manifests = creationConfig.getArtifacts().getFinalProduct(manifestType);
        Action configureResourcesAndAssetsDependencies = task -> {
            task.dependsOn(new Object[]{taskContainer.getMergeAssetsTask()});
            if (taskContainer.getProcessAndroidResTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getProcessAndroidResTask()});
            }
        };
        TaskProvider<PackageApplication> packageApp = this.taskFactory.register(new PackageApplication.CreationAction(creationConfig, creationConfig.getPaths().getApkLocation(), variantScope.useResourceShrinker(), manifests, manifestType, TaskManager.packagesCustomClassDependencies(creationConfig)), null, task -> {
            task.dependsOn(new Object[]{taskContainer.getJavacTask()});
            if (taskContainer.getPackageSplitResourcesTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getPackageSplitResourcesTask()});
            }
            if (taskContainer.getPackageSplitAbiTask() != null) {
                task.dependsOn(new Object[]{taskContainer.getPackageSplitAbiTask()});
            }
            configureResourcesAndAssetsDependencies.execute((Object)task);
        }, null);
        TaskFactoryUtils.dependsOn(taskContainer.getAssembleTask(), packageApp.getName());
        creationConfig.getArtifacts().republish(InternalArtifactType.APK.INSTANCE, PublicArtifactType.APK.INSTANCE);
        if (signedApk) {
            this.createInstallTask(creationConfig);
        }
        TaskProvider<UninstallTask> uninstallTask = this.taskFactory.register(new UninstallTask.CreationAction(creationConfig));
        this.taskFactory.configure(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAll -> uninstallAll.dependsOn(new Object[]{uninstallTask})));
    }

    protected void createInstallTask(ApkCreationConfig creationConfig) {
        this.taskFactory.register(new InstallVariantTask.CreationAction(creationConfig));
    }

    protected void createValidateSigningTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getVariantDslInfo().getSigningConfig() == null) {
            return;
        }
        this.taskFactory.register(new ValidateSigningTask.CreationAction(componentProperties, GradleKeystoreHelper.getDefaultDebugKeystoreLocation()));
    }

    public void createAnchorAssembleTasks(int flavorCount, int flavorDimensionCount) {
        ArrayList subAssembleTasks = Lists.newArrayList();
        ArrayList subBundleTasks = Lists.newArrayList();
        if (flavorCount > 0) {
            ArrayListMultimap assembleMap = ArrayListMultimap.create();
            ArrayListMultimap bundleMap = ArrayListMultimap.create();
            for (Object component2 : this.allPropertiesList) {
                VariantType variantType = ((ComponentPropertiesImpl)component2).getVariantType();
                if (variantType.isTestComponent()) continue;
                MutableTaskContainer taskContainer = ((ComponentPropertiesImpl)component2).getTaskContainer();
                VariantDslInfo variantDslInfo = ((ComponentPropertiesImpl)component2).getVariantDslInfo();
                String buildType = ((ComponentPropertiesImpl)component2).getBuildType();
                TaskProvider<? extends Task> assembleTask = taskContainer.getAssembleTask();
                if (buildType != null) {
                    assembleMap.put((Object)buildType, assembleTask);
                }
                for (ProductFlavor flavor : variantDslInfo.getProductFlavorList()) {
                    assembleMap.put((Object)flavor.getName(), assembleTask);
                }
                if (flavorDimensionCount > 1) {
                    assembleMap.put((Object)((ComponentPropertiesImpl)component2).getFlavorName(), assembleTask);
                }
                if (!variantType.isBaseModule()) continue;
                TaskProvider<? extends Task> bundleTask = taskContainer.getBundleTask();
                if (buildType != null) {
                    bundleMap.put((Object)buildType, bundleTask);
                }
                for (ProductFlavor flavor : variantDslInfo.getProductFlavorList()) {
                    bundleMap.put((Object)flavor.getName(), bundleTask);
                }
                if (flavorDimensionCount <= 1) continue;
                bundleMap.put((Object)((ComponentPropertiesImpl)component2).getFlavorName(), bundleTask);
            }
            Set dimensionKeys = assembleMap.keySet();
            for (String dimensionKey : dimensionKeys) {
                String dimensionName = StringHelper.usLocaleCapitalize((String)dimensionKey);
                subAssembleTasks.add(this.taskFactory.register("assemble" + dimensionName, (Action<? super Task>)((Action)arg_0 -> TaskManager.lambda$createAnchorAssembleTasks$45(dimensionName, (ListMultimap)assembleMap, dimensionKey, arg_0))));
                List subBundleMap = bundleMap.get((Object)dimensionKey);
                if (subBundleMap.isEmpty()) continue;
                subBundleTasks.add(this.taskFactory.register("bundle" + dimensionName, (Action<? super Task>)((Action)task -> {
                    task.setDescription("Assembles bundles for all " + dimensionName + " variants.");
                    task.setGroup(BUILD_GROUP);
                    task.dependsOn(new Object[]{subBundleMap});
                })));
            }
        } else {
            for (ComponentPropertiesImpl component3 : this.allPropertiesList) {
                VariantType variantType = component3.getVariantType();
                if (variantType.isTestComponent()) continue;
                MutableTaskContainer taskContainer = component3.getTaskContainer();
                subAssembleTasks.add(taskContainer.getAssembleTask());
                if (!variantType.isBaseModule()) continue;
                subBundleTasks.add(taskContainer.getBundleTask());
            }
        }
        if (!subAssembleTasks.isEmpty()) {
            this.taskFactory.configure("assemble", (Action<? super Task>)((Action)task -> {
                task.setDescription("Assemble main outputs for all the variants.");
                task.setGroup(BUILD_GROUP);
                task.dependsOn(new Object[]{subAssembleTasks});
            }));
        }
        if (!subBundleTasks.isEmpty()) {
            this.taskFactory.register("bundle", (Action<? super Task>)((Action)task -> {
                task.setDescription("Assemble bundles for all the variants.");
                task.setGroup(BUILD_GROUP);
                task.dependsOn(new Object[]{subBundleTasks});
            }));
        }
    }

    public void createAssembleTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(componentProperties.computeTaskName("assemble"), null, task -> task.setDescription("Assembles main output for variant " + componentProperties.getName()), taskProvider -> componentProperties.getTaskContainer().setAssembleTask((TaskProvider<? extends Task>)taskProvider));
    }

    public void createBundleTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(componentProperties.computeTaskName("bundle"), null, task -> {
            task.setDescription("Assembles bundle for variant " + componentProperties.getName());
            task.dependsOn(new Object[]{componentProperties.getArtifacts().getFinalProduct(InternalArtifactType.BUNDLE.INSTANCE)});
        }, taskProvider -> componentProperties.getTaskContainer().setBundleTask((TaskProvider<? extends Task>)taskProvider));
    }

    protected void maybeCreateJavaCodeShrinkerTask(ComponentPropertiesImpl componentProperties) {
        CodeShrinker codeShrinker = componentProperties.getVariantScope().getCodeShrinker();
        if (codeShrinker != null) {
            this.doCreateJavaCodeShrinkerTask(componentProperties, codeShrinker);
        }
    }

    protected final void doCreateJavaCodeShrinkerTask(ComponentPropertiesImpl componentProperties, CodeShrinker codeShrinker) {
        this.doCreateJavaCodeShrinkerTask(componentProperties, codeShrinker, false);
    }

    protected final void doCreateJavaCodeShrinkerTask(ComponentPropertiesImpl componentProperties, CodeShrinker codeShrinker, Boolean isTestApplication) {
        Object task;
        switch (codeShrinker) {
            case PROGUARD: {
                task = this.createProguardTask(componentProperties, isTestApplication);
                break;
            }
            case R8: {
                task = this.createR8Task(componentProperties, isTestApplication);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown value " + codeShrinker));
            }
        }
        if (componentProperties.getVariantScope().getPostprocessingFeatures() != null) {
            TaskProvider<CheckProguardFiles> checkFilesTask = this.taskFactory.register(new CheckProguardFiles.CreationAction(componentProperties));
            TaskFactoryUtils.dependsOn(task, checkFilesTask);
        }
    }

    private TaskProvider<ProguardTask> createProguardTask(ComponentPropertiesImpl componentProperties, boolean isTestApplication) {
        return this.taskFactory.register(new ProguardTask.CreationAction(componentProperties, isTestApplication));
    }

    private TaskProvider<R8Task> createR8Task(BaseCreationConfig creationConfig, Boolean isTestApplication) {
        if (creationConfig instanceof ApplicationCreationConfig) {
            this.publishFeatureDex((ApplicationCreationConfig)creationConfig);
        }
        return this.taskFactory.register(new R8Task.CreationAction(creationConfig, (boolean)isTestApplication));
    }

    private void maybeCreateDexSplitterTask(ApkCreationConfig creationConfig) {
        if (!creationConfig.getVariantScope().consumesFeatureJars()) {
            return;
        }
        this.taskFactory.register(new DexSplitterTask.CreationAction(creationConfig));
        if (creationConfig instanceof ApplicationCreationConfig) {
            this.publishFeatureDex((ApplicationCreationConfig)creationConfig);
        }
    }

    private void publishFeatureDex(ApplicationCreationConfig creationConfig) {
        BaseExtension extension = this.globalScope.getExtension();
        if (!(extension instanceof BaseAppModuleExtension)) {
            return;
        }
        Set<String> modulePaths = ((BaseAppModuleExtension)extension).getDynamicFeatures();
        Configuration configuration2 = creationConfig.getVariantDependencies().getElements(AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS);
        Preconditions.checkNotNull((Object)configuration2, (Object)("Publishing to Runtime Element with no Runtime Elements configuration object. VariantType: " + creationConfig.getVariantType()));
        Provider artifact = creationConfig.getArtifacts().getFinalProduct(InternalArtifactType.FEATURE_DEX.INSTANCE);
        for (String modulePath : modulePaths) {
            Provider file = artifact.map(directory2 -> directory2.file(TaskManager.getFeatureFileName(modulePath, null)));
            ImmutableMap attributeMap = ImmutableMap.of(AndroidArtifacts.MODULE_PATH, (Object)this.project.absoluteProjectPath(modulePath));
            ArtifactPublishingUtil.publishArtifactToConfiguration(configuration2, file, AndroidArtifacts.ArtifactType.FEATURE_DEX, (Map<Attribute<String>, String>)attributeMap);
        }
    }

    public static String getFeatureFileName(String modulePath, String fileExtension) {
        String featureName2 = FeatureSplitUtils.getFeatureName(modulePath);
        String sanitizedFeatureName = ":".equals(featureName2) ? "" : featureName2;
        return "feature-" + sanitizedFeatureName + Strings.nullToEmpty((String)fileExtension);
    }

    protected void maybeCreateResourcesShrinkerTasks(ComponentPropertiesImpl componentProperties) {
        if (!componentProperties.getVariantScope().useResourceShrinker()) {
            return;
        }
        this.taskFactory.register(new ShrinkResourcesTask.CreationAction(componentProperties));
        this.taskFactory.register(new ShrinkBundleResourcesTask.CreationAction(componentProperties));
    }

    private void createReportTasks() {
        this.taskFactory.register("androidDependencies", DependencyReportTask.class, task -> {
            task.setDescription("Displays the Android dependencies of the project.");
            task.variants = this.variantPropertiesList;
            task.testComponents = this.testComponentPropertiesList;
            task.setGroup(ANDROID_GROUP);
        });
        List signingReportComponents = this.allPropertiesList.stream().filter(component2 -> component2.getVariantType().isForTesting() || component2.getVariantType().isBaseModule()).collect(Collectors.toList());
        if (!signingReportComponents.isEmpty()) {
            this.taskFactory.register("signingReport", SigningReportTask.class, task -> {
                task.setDescription("Displays the signing info for the base and test modules");
                task.setComponents(signingReportComponents);
                task.setGroup(ANDROID_GROUP);
            });
        }
        this.createDependencyAnalyzerTask();
    }

    protected void createDependencyAnalyzerTask() {
        for (VariantPropertiesImpl variant2 : this.variantPropertiesList) {
            this.taskFactory.register(new AnalyzeDependenciesTask.CreationAction(variant2));
        }
        for (TestComponentPropertiesImpl testComponent : this.testComponentPropertiesList) {
            this.taskFactory.register(new AnalyzeDependenciesTask.CreationAction(testComponent));
        }
    }

    public void createAnchorTasks(ComponentPropertiesImpl componentProperties) {
        this.createVariantPreBuildTask(componentProperties);
        BaseVariantData variantData = componentProperties.getVariantData();
        componentProperties.getTaskContainer().setSourceGenTask(this.taskFactory.register(componentProperties.computeTaskName("generate", "Sources"), (Action<? super Task>)((Action)task -> {
            task.dependsOn(new Object[]{"prepareLintJar"});
            task.dependsOn(new Object[]{"prepareLintJarForPublish"});
            task.dependsOn(new Object[]{variantData.getExtraGeneratedResFolders()});
        })));
        componentProperties.getTaskContainer().setResourceGenTask(this.taskFactory.register(componentProperties.computeTaskName("generate", "Resources")));
        componentProperties.getTaskContainer().setAssetGenTask(this.taskFactory.register(componentProperties.computeTaskName("generate", "Assets")));
        if (!componentProperties.getVariantType().isForTesting() && componentProperties.getVariantDslInfo().isTestCoverageEnabled()) {
            componentProperties.getTaskContainer().setCoverageReportTask(this.taskFactory.register(componentProperties.computeTaskName("create", "CoverageReport"), (Action<? super Task>)((Action)task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Creates test coverage reports for the %s variant.", componentProperties.getName()));
            })));
        }
        this.createCompileAnchorTask(componentProperties);
    }

    protected void createVariantPreBuildTask(ComponentPropertiesImpl componentProperties) {
        this.createDefaultPreBuildTask(componentProperties);
    }

    protected void createDefaultPreBuildTask(ComponentPropertiesImpl componentProperties) {
        this.taskFactory.register(new PreBuildCreationAction(componentProperties));
    }

    private void createCompileAnchorTask(ComponentPropertiesImpl componentProperties) {
        MutableTaskContainer taskContainer = componentProperties.getTaskContainer();
        taskContainer.setCompileTask(this.taskFactory.register(componentProperties.computeTaskName("compile", "Sources"), (Action<? super Task>)((Action)task -> task.setGroup(BUILD_GROUP))));
        TaskFactoryUtils.dependsOn(taskContainer.getAssembleTask(), taskContainer.getCompileTask());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private void addBindingDependenciesIfNecessary(DataBindingOptions dataBindingOptions) {
        String version;
        boolean viewBindingEnabled = this.allPropertiesList.stream().anyMatch(componentProperties -> componentProperties.getBuildFeatures().getViewBinding());
        boolean dataBindingEnabled = this.allPropertiesList.stream().anyMatch(componentProperties -> componentProperties.getBuildFeatures().getDataBinding());
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        boolean useAndroidX = projectOptions.get(BooleanOption.USE_ANDROID_X);
        DataBindingBuilder dataBindingBuilder = this.globalScope.getDataBindingBuilder();
        if (viewBindingEnabled) {
            version = dataBindingBuilder.getLibraryVersion(dataBindingBuilder.getCompilerVersion());
            String groupAndArtifact = useAndroidX ? "androidx.databinding:viewbinding" : "com.android.databinding:viewbinding";
            this.project.getDependencies().add("api", (Object)(groupAndArtifact + ":" + version));
        }
        if (dataBindingEnabled) {
            version = (String)MoreObjects.firstNonNull((Object)dataBindingOptions.getVersion(), (Object)dataBindingBuilder.getCompilerVersion());
            String baseLibArtifact = useAndroidX ? "androidx.databinding:databinding-common" : "com.android.databinding:baseLibrary";
            this.project.getDependencies().add("api", (Object)(baseLibArtifact + ":" + dataBindingBuilder.getBaseLibraryVersion(version)));
            this.project.getDependencies().add("annotationProcessor", (Object)("androidx.databinding:databinding-compiler:" + version));
            if (dataBindingOptions.isEnabledForTests() || this instanceof LibraryTaskManager) {
                String dataBindingArtifact = "androidx.databinding:databinding-compiler:" + version;
                this.project.getDependencies().add("androidTestAnnotationProcessor", (Object)dataBindingArtifact);
                if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
                    this.project.getDependencies().add("testAnnotationProcessor", (Object)dataBindingArtifact);
                }
            }
            if (dataBindingOptions.getAddDefaultAdapters()) {
                String libArtifact = useAndroidX ? "androidx.databinding:databinding-runtime" : "com.android.databinding:library";
                String adaptersArtifact = useAndroidX ? "androidx.databinding:databinding-adapters" : "com.android.databinding:adapters";
                this.project.getDependencies().add("api", (Object)(libArtifact + ":" + dataBindingBuilder.getLibraryVersion(version)));
                this.project.getDependencies().add("api", (Object)(adaptersArtifact + ":" + dataBindingBuilder.getBaseAdaptersVersion(version)));
            }
            this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.kapt", appliedPlugin -> this.configureKotlinKaptTasksForDataBinding(this.project, version));
        }
    }

    private void configureKotlinKaptTasksForDataBinding(Project project2, String version) {
        DependencySet kaptDeps = project2.getConfigurations().getByName("kapt").getAllDependencies();
        kaptDeps.forEach(dependency -> {
            if (Objects.equals(dependency.getGroup() + ":" + dependency.getName(), "androidx.databinding:databinding-compiler") && !Objects.equals(dependency.getVersion(), version)) {
                String depString = dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion();
                this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Data Binding annotation processor version needs to match the Android Gradle Plugin version. You can remove the kapt dependency " + depString + " and Android Gradle Plugin will inject the right version.");
            }
        });
        project2.getDependencies().add("kapt", (Object)("androidx.databinding:databinding-compiler:" + version));
        Class<?> kaptTaskClass = null;
        try {
            kaptTaskClass = Class.forName("org.jetbrains.kotlin.gradle.internal.KaptTask");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Kotlin plugin is applied to the project " + project2.getPath() + " but we cannot find the KaptTask. Make sure you apply the kotlin-kapt plugin because it is necessary to use kotlin with data binding.");
        }
        if (kaptTaskClass == null) {
            return;
        }
        Map<String, ComponentPropertiesImpl> kaptTaskLookup = this.allPropertiesList.stream().collect(Collectors.toMap(component2 -> component2.computeTaskName("kapt", "Kotlin"), component2 -> component2));
        project2.getTasks().withType(kaptTaskClass, kaptTask -> {
            ComponentPropertiesImpl matchingComponent = (ComponentPropertiesImpl)kaptTaskLookup.get(kaptTask.getName());
            if (matchingComponent != null) {
                TaskManager.configureKaptTaskInScope(matchingComponent, kaptTask);
            }
        });
    }

    private static void configureKaptTaskInScope(ComponentPropertiesImpl componentProperties, Task kaptTask) {
        DirectoryProperty databindingArtifact = componentProperties.getGlobalScope().getProject().getObjects().directoryProperty();
        TaskProvider kaptTaskProvider = componentProperties.getGlobalScope().getProject().getTasks().named(kaptTask.getName());
        componentProperties.getArtifacts().getOperations().replace(kaptTaskProvider, task -> databindingArtifact).on((ArtifactType)InternalArtifactType.DATA_BINDING_ARTIFACT.INSTANCE);
        kaptTask.getOutputs().dir((Object)databindingArtifact);
    }

    protected void configureTestData(ComponentPropertiesImpl componentProperties, AbstractTestDataImpl testData) {
        testData.setAnimationsDisabled(this.extension.getTestOptions().getAnimationsDisabled());
        testData.setExtraInstrumentationTestRunnerArgs(componentProperties.getServices().getProjectOptions().getExtraInstrumentationTestRunnerArgs());
    }

    private void maybeCreateCheckDuplicateClassesTask(ComponentPropertiesImpl componentProperties) {
        if (componentProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_DUPLICATE_CLASSES_CHECK)) {
            this.taskFactory.register(new CheckDuplicateClassesTask.CreationAction(componentProperties));
        }
    }

    private void maybeCreateDexDesugarLibTask(ComponentPropertiesImpl componentProperties, boolean enableDexingArtifactTransform) {
        boolean separateFileDependenciesDexingTask;
        boolean bl = separateFileDependenciesDexingTask = componentProperties.getVariantScope().getJava8LangSupportType() == VariantScope.Java8LangSupport.D8 && enableDexingArtifactTransform;
        if (componentProperties.getVariantScope().getNeedsShrinkDesugarLibrary()) {
            this.taskFactory.register(new L8DexDesugarLibTask.CreationAction(componentProperties, enableDexingArtifactTransform, separateFileDependenciesDexingTask));
        }
    }

    private static /* synthetic */ void lambda$createAnchorAssembleTasks$45(String dimensionName, ListMultimap assembleMap, String dimensionKey, Task task) {
        task.setDescription("Assembles main outputs for all " + dimensionName + " variants.");
        task.setGroup(BUILD_GROUP);
        task.dependsOn(new Object[]{assembleMap.get((Object)dimensionKey)});
    }

    private static class PreBuildCreationAction
    extends AbstractPreBuildCreationAction<AndroidVariantTask> {
        public PreBuildCreationAction(ComponentPropertiesImpl componentProperties) {
            super(componentProperties);
        }

        @Override
        public Class<AndroidVariantTask> getType() {
            return AndroidVariantTask.class;
        }
    }

    public static abstract class AbstractPreBuildCreationAction<TaskT extends AndroidVariantTask>
    extends VariantTaskCreationAction<TaskT, ComponentPropertiesImpl> {
        @Override
        public String getName() {
            return this.computeTaskName("pre", "Build");
        }

        public AbstractPreBuildCreationAction(ComponentPropertiesImpl componentProperties) {
            super(componentProperties, false);
        }

        @Override
        public void handleProvider(TaskProvider<? extends TaskT> taskProvider) {
            super.handleProvider(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getVariantData().getTaskContainer().setPreBuildTask(taskProvider);
        }

        @Override
        public void configure(TaskT task) {
            super.configure(task);
            task.dependsOn(new Object[]{TaskManager.MAIN_PREBUILD});
            if (((ComponentPropertiesImpl)this.creationConfig).getVariantScope().getCodeShrinker() != null) {
                task.dependsOn(new Object[]{TaskManager.EXTRACT_PROGUARD_FILES});
            }
        }
    }

    public static enum MergeType {
        MERGE{

            @Override
            public SingleArtifactType<Directory> getOutputType() {
                return InternalArtifactType.MERGED_RES.INSTANCE;
            }
        }
        ,
        PACKAGE{

            @Override
            public SingleArtifactType<Directory> getOutputType() {
                return InternalArtifactType.PACKAGED_RES.INSTANCE;
            }
        };


        public abstract SingleArtifactType<Directory> getOutputType();
    }

    public static class ConfigAttrTask
    extends DefaultTask {
        boolean consumable = false;
        boolean resolvable = false;

        @TaskAction
        public void run() {
            for (Configuration config2 : this.getProject().getConfigurations()) {
                AttributeContainer attributes2 = config2.getAttributes();
                if ((!this.consumable || !config2.isCanBeConsumed()) && (!this.resolvable || !config2.isCanBeResolved())) continue;
                System.out.println(config2.getName());
                System.out.println("\tcanBeResolved: " + config2.isCanBeResolved());
                System.out.println("\tcanBeConsumed: " + config2.isCanBeConsumed());
                for (Attribute attr : attributes2.keySet()) {
                    System.out.println("\t" + attr.getName() + ": " + attributes2.getAttribute(attr));
                }
                if (!this.consumable || !config2.isCanBeConsumed()) continue;
                for (PublishArtifact artifact : config2.getArtifacts()) {
                    System.out.println("\tArtifact: " + artifact.getName() + " (" + artifact.getFile().getName() + ")");
                }
                for (ConfigurationVariant cv : config2.getOutgoing().getVariants()) {
                    System.out.println("\tConfigurationVariant: " + cv.getName());
                    for (PublishArtifact pa : cv.getArtifacts()) {
                        System.out.println("\t\tArtifact: " + pa.getFile());
                        System.out.println("\t\tType:" + pa.getType());
                    }
                }
            }
        }
    }
}

