/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.DefaultConfigData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.core.VariantBuilder;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dependency.VariantDependenciesBuilder;
import com.android.build.gradle.internal.dsl.ActionableVariantObjectOperationsExecutor;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantBuildArtifactsHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.scope.VariantScopeImpl;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.TaskCreationServicesImpl;
import com.android.build.gradle.internal.services.VariantApiServices;
import com.android.build.gradle.internal.services.VariantApiServicesImpl;
import com.android.build.gradle.internal.services.VariantPropertiesApiServicesImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.build.gradle.internal.variant.DimensionCombinator;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SigningOptions;
import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.model.ObjectFactory;

public class VariantManager<VariantT extends VariantImpl<VariantPropertiesT>, VariantPropertiesT extends VariantPropertiesImpl> {
    private final Project project;
    private final ProjectOptions projectOptions;
    private final BaseExtension extension;
    private final VariantFactory<VariantT, VariantPropertiesT> variantFactory;
    private final VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> variantInputModel;
    private final VariantApiServices variantApiServices;
    private final VariantPropertiesApiServicesImpl variantPropertiesApiServices;
    private final TaskCreationServices taskCreationServices;
    private final ProjectServices projectServices;
    private final Recorder recorder;
    private final VariantFilter variantFilter;
    private final List<ComponentInfo<VariantT, VariantPropertiesT>> variants = Lists.newArrayList();
    private final List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents = Lists.newArrayList();
    private final Map<File, ManifestAttributeSupplier> manifestParserMap;
    protected final GlobalScope globalScope;
    private final SigningConfig signingOverride;
    private boolean hasCreatedTasks = false;
    public static final Attribute<String> SHRINKER_ATTR = Attribute.of((String)"codeShrinker", String.class);

    public VariantManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, BaseExtension extension, VariantFactory<VariantT, VariantPropertiesT> variantFactory, VariantInputModel variantInputModel, ProjectServices projectServices, Recorder recorder) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.project = project2;
        this.projectOptions = projectOptions;
        this.variantFactory = variantFactory;
        this.variantInputModel = variantInputModel;
        this.projectServices = projectServices;
        this.recorder = recorder;
        this.signingOverride = this.createSigningOverride();
        this.variantFilter = new VariantFilter(new ReadOnlyObjectProvider());
        this.manifestParserMap = Maps.newHashMap();
        this.variantApiServices = new VariantApiServicesImpl(projectServices);
        this.variantPropertiesApiServices = new VariantPropertiesApiServicesImpl(projectServices);
        this.taskCreationServices = new TaskCreationServicesImpl(projectServices);
    }

    public List<ComponentInfo<VariantT, VariantPropertiesT>> getMainComponents() {
        return this.variants;
    }

    public List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> getTestComponents() {
        return this.testComponents;
    }

    public void createVariants() {
        this.variantFactory.validateModel(this.variantInputModel);
        this.variantFactory.preVariantWork(this.project);
        this.computeVariants();
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorSelection(VariantDslInfo variantDslInfo) {
        ObjectFactory factory2 = this.project.getObjects();
        return variantDslInfo.getMissingDimensionStrategies().entrySet().stream().collect(Collectors.toMap(entry -> Attribute.of((String)((String)entry.getKey()), ProductFlavorAttr.class), entry -> (ProductFlavorAttr)factory2.named(ProductFlavorAttr.class, ((AbstractProductFlavor.DimensionRequest)entry.getValue()).getRequested())));
    }

    public static String getModifiedName(String name2) {
        return "____" + name2;
    }

    private void computeVariants() {
        List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
        DimensionCombinator computer = new DimensionCombinator(this.variantInputModel, this.projectServices.getIssueReporter(), flavorDimensionList);
        List<DimensionCombination> variants = computer.computeVariants();
        BuildTypeData<BuildType> testBuildTypeData = this.getTestBuildTypeData();
        for (DimensionCombination variant2 : variants) {
            this.createVariantsFromCombination(variant2, testBuildTypeData);
        }
        this.variantApiServices.lockValues();
    }

    private BuildTypeData<BuildType> getTestBuildTypeData() {
        BuildTypeData<BuildType> testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig) {
            TestedAndroidConfig testedExtension = (TestedAndroidConfig)((Object)this.extension);
            testBuildTypeData = this.variantInputModel.getBuildTypes().get(testedExtension.getTestBuildType());
            if (testBuildTypeData == null) {
                throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
            }
        }
        return testBuildTypeData;
    }

    private ComponentInfo<VariantT, VariantPropertiesT> createVariant(DimensionCombination dimensionCombination, BuildTypeData<BuildType> buildTypeData, List<ProductFlavorData<ProductFlavor>> productFlavorDataList, VariantType variantType) {
        DslServices dslServices = this.globalScope.getDslServices();
        DefaultConfigData<DefaultConfig> defaultConfig = this.variantInputModel.getDefaultConfigData();
        DefaultAndroidSourceSet defaultConfigSourceProvider = defaultConfig.getSourceSet();
        VariantBuilder variantBuilder = VariantBuilder.getBuilder(dimensionCombination, variantType, defaultConfig.getDefaultConfig(), defaultConfigSourceProvider, buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.signingOverride, this.getParser(defaultConfigSourceProvider.getManifestFile(), variantType.getRequiresManifest()), dslServices, this::canParseManifest);
        for (ProductFlavorData<ProductFlavor> productFlavorData : productFlavorDataList) {
            variantBuilder.addProductFlavor(productFlavorData.getProductFlavor(), productFlavorData.getSourceSet());
        }
        VariantDslInfoImpl variantDslInfo = variantBuilder.createVariantDslInfo();
        ComponentIdentity componentIdentity = variantDslInfo.getComponentIdentity();
        VariantT variant2 = this.variantFactory.createVariantObject(componentIdentity, variantDslInfo, this.variantApiServices);
        ActionableVariantObjectOperationsExecutor commonExtension = (ActionableVariantObjectOperationsExecutor)((Object)this.extension);
        commonExtension.executeVariantOperations(variant2);
        if (!((ComponentImpl)variant2).getEnabled()) {
            return null;
        }
        this.createCompoundSourceSets(productFlavorDataList, variantBuilder);
        VariantSources variantSources = variantBuilder.createVariantSources();
        if (!buildTypeData.getBuildType().isDebuggable() && variantType.isApk() && !variantDslInfo.getVariantType().isForTesting()) {
            ProcessProfileWriter.get().recordApplicationId(variantDslInfo::getApplicationId);
        }
        ArrayList variantSourceSets = Lists.newArrayListWithExpectedSize((int)(productFlavorDataList.size() + 4));
        if (!productFlavorDataList.isEmpty()) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantSources.getVariantSourceProvider());
        }
        variantSourceSets.add(buildTypeData.getSourceSet());
        if (productFlavorDataList.size() > 1) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantSources.getMultiFlavorSourceProvider());
        }
        for (ProductFlavorData<ProductFlavor> productFlavor : productFlavorDataList) {
            variantSourceSets.add(productFlavor.getSourceSet());
        }
        variantSourceSets.add(this.variantInputModel.getDefaultConfigData().getSourceSet());
        VariantDependenciesBuilder builder = VariantDependenciesBuilder.builder(this.project, this.projectOptions, this.projectServices.getIssueReporter(), variantDslInfo).setFlavorSelection(this.getFlavorSelection(variantDslInfo)).addSourceSets(variantSourceSets);
        if (this.extension instanceof BaseAppModuleExtension) {
            builder.setFeatureList(((BaseAppModuleExtension)this.extension).getDynamicFeatures());
        }
        VariantDependencies variantDependencies = builder.build();
        VariantPathHelper pathHelper = new VariantPathHelper(this.project, variantDslInfo, dslServices);
        VariantBuildArtifactsHolder artifacts2 = new VariantBuildArtifactsHolder(this.project, componentIdentity.getName(), this.globalScope.getBuildDir());
        MutableTaskContainer taskContainer = new MutableTaskContainer();
        TransformManager transformManager = new TransformManager(this.project, dslServices.getIssueReporter(), this.recorder);
        VariantScopeImpl variantScope = new VariantScopeImpl(componentIdentity, variantDslInfo, variantDependencies, pathHelper, artifacts2, this.globalScope, null);
        BaseVariantData variantData = this.variantFactory.createVariantData(componentIdentity, variantDslInfo, variantDependencies, variantSources, pathHelper, artifacts2, this.variantPropertiesApiServices, this.globalScope, taskContainer);
        VariantPropertiesT variantProperties = this.variantFactory.createVariantPropertiesObject(variant2, componentIdentity, this.variantFactory.createBuildFeatureValues(this.extension.getBuildFeatures(), this.projectOptions), variantDslInfo, variantDependencies, variantSources, pathHelper, artifacts2, variantScope, variantData, transformManager, this.variantPropertiesApiServices, this.taskCreationServices);
        commonExtension.executeVariantPropertiesOperations(variantProperties);
        ((ComponentImpl)variant2).executePropertiesActions(variantProperties);
        return new ComponentInfo<VariantT, VariantPropertiesT>(variant2, variantProperties);
    }

    private void createCompoundSourceSets(List<ProductFlavorData<ProductFlavor>> productFlavorList, VariantBuilder variantBuilder) {
        VariantType variantType = variantBuilder.getVariantType();
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)this.variantInputModel.getSourceSetManager().setUpSourceSet(VariantBuilder.computeSourceSetName(variantBuilder.getName(), variantType), variantType.isTestComponent());
            variantBuilder.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)this.variantInputModel.getSourceSetManager().setUpSourceSet(VariantBuilder.computeSourceSetName(variantBuilder.getFlavorName(), variantType), variantType.isTestComponent());
            variantBuilder.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    public ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl> createTestComponents(DimensionCombination dimensionCombination, BuildTypeData<BuildType> buildTypeData, List<ProductFlavorData<ProductFlavor>> productFlavorDataList, VariantT testedVariant, VariantPropertiesT testedVariantProperties, VariantType variantType) {
        TestComponentPropertiesImpl componentProperties;
        DefaultAndroidSourceSet buildTypeConfigurationProvider;
        TestComponentImpl component2;
        DefaultAndroidSourceSet testSourceSet = this.variantInputModel.getDefaultConfigData().getTestSourceSet(variantType);
        DslServices dslServices = this.globalScope.getDslServices();
        VariantBuilder variantBuilder = VariantBuilder.getBuilder(dimensionCombination, variantType, this.variantInputModel.getDefaultConfigData().getDefaultConfig(), testSourceSet, buildTypeData.getBuildType(), buildTypeData.getTestSourceSet(variantType), this.signingOverride, testSourceSet != null ? this.getParser(testSourceSet.getManifestFile(), variantType.getRequiresManifest()) : null, dslServices, this::canParseManifest);
        variantBuilder.setTestedVariant((VariantDslInfoImpl)((ComponentPropertiesImpl)testedVariantProperties).getVariantDslInfo());
        List<ProductFlavor> productFlavorList = ((ComponentPropertiesImpl)testedVariantProperties).getVariantDslInfo().getProductFlavorList();
        Map<String, ProductFlavorData<ProductFlavor>> productFlavors = this.variantInputModel.getProductFlavors();
        for (ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<ProductFlavor> data = productFlavors.get(productFlavor.getName());
            variantBuilder.addProductFlavor(data.getProductFlavor(), data.getTestSourceSet(variantType));
        }
        VariantDslInfoImpl variantDslInfo = variantBuilder.createVariantDslInfo();
        if (variantType.isApk()) {
            AndroidTestImpl androidTestVariant = this.variantFactory.createAndroidTestObject(variantDslInfo.getComponentIdentity(), variantDslInfo, this.variantApiServices);
            ((VariantImpl)testedVariant).executeAndroidTestActions(androidTestVariant);
            component2 = androidTestVariant;
        } else {
            UnitTestImpl unitTestVariant = this.variantFactory.createUnitTestObject(variantDslInfo.getComponentIdentity(), variantDslInfo, this.variantApiServices);
            ((VariantImpl)testedVariant).executeUnitTestActions(unitTestVariant);
            component2 = unitTestVariant;
        }
        if (!component2.getEnabled()) {
            return null;
        }
        this.createCompoundSourceSets(productFlavorDataList, variantBuilder);
        VariantSources variantSources = variantBuilder.createVariantSources();
        List<ProductFlavor> testProductFlavors = variantDslInfo.getProductFlavorList();
        ArrayList testVariantSourceSets = Lists.newArrayListWithExpectedSize((int)(4 + testProductFlavors.size()));
        if (!testProductFlavors.isEmpty()) {
            testVariantSourceSets.add((DefaultAndroidSourceSet)variantSources.getVariantSourceProvider());
        }
        if ((buildTypeConfigurationProvider = buildTypeData.getTestSourceSet(variantType)) != null) {
            testVariantSourceSets.add(buildTypeConfigurationProvider);
        }
        if (testProductFlavors.size() > 1) {
            testVariantSourceSets.add((DefaultAndroidSourceSet)variantSources.getMultiFlavorSourceProvider());
        }
        for (ProductFlavor productFlavor : testProductFlavors) {
            testVariantSourceSets.add(this.variantInputModel.getProductFlavors().get(productFlavor.getName()).getTestSourceSet(variantType));
        }
        testVariantSourceSets.add(this.variantInputModel.getDefaultConfigData().getTestSourceSet(variantType));
        VariantDependenciesBuilder builder = VariantDependenciesBuilder.builder(this.project, this.projectOptions, this.projectServices.getIssueReporter(), variantDslInfo).addSourceSets(testVariantSourceSets).setFlavorSelection(this.getFlavorSelection(variantDslInfo)).setTestedVariant((VariantPropertiesImpl)testedVariantProperties);
        VariantDependencies variantDependencies = builder.build();
        VariantPathHelper pathHelper = new VariantPathHelper(this.project, variantDslInfo, dslServices);
        ComponentIdentity componentIdentity = variantDslInfo.getComponentIdentity();
        VariantBuildArtifactsHolder artifacts2 = new VariantBuildArtifactsHolder(this.project, componentIdentity.getName(), this.globalScope.getBuildDir());
        MutableTaskContainer taskContainer = new MutableTaskContainer();
        TransformManager transformManager = new TransformManager(this.project, dslServices.getIssueReporter(), this.recorder);
        VariantScopeImpl variantScope = new VariantScopeImpl(componentIdentity, variantDslInfo, variantDependencies, pathHelper, artifacts2, this.globalScope, (VariantPropertiesImpl)testedVariantProperties);
        TestVariantData testVariantData = new TestVariantData(componentIdentity, variantDslInfo, variantDependencies, variantSources, pathHelper, artifacts2, (TestedVariantData)((Object)((ComponentPropertiesImpl)testedVariantProperties).getVariantData()), this.variantPropertiesApiServices, this.globalScope, taskContainer);
        TestComponentImpl testComponent = component2;
        BuildFeatureValues buildFeatureValues = this.variantFactory.createTestBuildFeatureValues(this.extension.getBuildFeatures(), this.extension.getDataBinding(), this.projectOptions);
        if (variantType.isApk()) {
            AndroidTestPropertiesImpl androidTestProperties2 = this.variantFactory.createAndroidTestProperties(componentIdentity, buildFeatureValues, variantDslInfo, variantDependencies, variantSources, pathHelper, artifacts2, variantScope, testVariantData, (VariantPropertiesImpl)testedVariantProperties, transformManager, this.variantPropertiesApiServices, this.taskCreationServices);
            testComponent.executePropertiesActions(androidTestProperties2);
            ((VariantImpl)testedVariant).executeAndroidTestPropertiesActions(androidTestProperties2);
            componentProperties = androidTestProperties2;
        } else {
            UnitTestPropertiesImpl unitTestProperties2 = this.variantFactory.createUnitTestProperties(componentIdentity, buildFeatureValues, variantDslInfo, variantDependencies, variantSources, pathHelper, artifacts2, variantScope, testVariantData, (VariantPropertiesImpl)testedVariantProperties, transformManager, this.variantPropertiesApiServices, this.taskCreationServices);
            testComponent.executePropertiesActions(unitTestProperties2);
            ((VariantImpl)testedVariant).executeUnitTestPropertiesActions(unitTestProperties2);
            componentProperties = unitTestProperties2;
        }
        ((VariantPropertiesImpl)testedVariantProperties).getTestComponents().put(variantDslInfo.getVariantType(), componentProperties);
        return new ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>(component2, componentProperties);
    }

    private void createVariantsFromCombination(DimensionCombination dimensionCombination, BuildTypeData<BuildType> testBuildTypeData) {
        ComponentInfo<VariantT, VariantPropertiesT> variantInfo;
        VariantType variantType = this.variantFactory.getVariantType();
        Action<com.android.build.api.variant.VariantFilter> variantFilterAction = this.extension.getVariantFilter();
        DefaultConfig defaultConfig = this.variantInputModel.getDefaultConfigData().getDefaultConfig();
        BuildTypeData<BuildType> buildTypeData = this.variantInputModel.getBuildTypes().get(dimensionCombination.getBuildType());
        BuildType buildType = buildTypeData.getBuildType();
        List<ProductFlavorData<ProductFlavor>> productFlavorDataList = dimensionCombination.getProductFlavors().stream().map(it -> this.variantInputModel.getProductFlavors().get(it.getSecond())).collect(Collectors.toList());
        List productFlavorList = productFlavorDataList.stream().map(ProductFlavorData::getProductFlavor).collect(Collectors.toList());
        boolean ignore = false;
        if (variantFilterAction != null) {
            this.variantFilter.reset(dimensionCombination, defaultConfig, buildType, variantType, productFlavorList);
            try {
                variantFilterAction.execute((Object)this.variantFilter);
            }
            catch (Throwable t) {
                throw new ExternalApiUsageException(t);
            }
            ignore = this.variantFilter.getIgnore();
        }
        if (!ignore && (variantInfo = this.createVariant(dimensionCombination, buildTypeData, productFlavorDataList, variantType)) != null) {
            VariantScope.Java8LangSupport supportType;
            this.addVariant(variantInfo);
            VariantPropertiesImpl variantProperties = (VariantPropertiesImpl)variantInfo.getProperties();
            VariantDslInfo variantDslInfo = variantProperties.getVariantDslInfo();
            VariantScope variantScope = variantProperties.getVariantScope();
            int minSdkVersion = variantDslInfo.getMinSdkVersion().getApiLevel();
            int targetSdkVersion = variantDslInfo.getTargetSdkVersion().getApiLevel();
            if (minSdkVersion > 0 && targetSdkVersion > 0 && minSdkVersion > targetSdkVersion) {
                this.projectServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, String.format(Locale.US, "minSdkVersion (%d) is greater than targetSdkVersion (%d) for variant \"%s\". Please change the values such that minSdkVersion is less than or equal to targetSdkVersion.", minSdkVersion, targetSdkVersion, variantProperties.getName()));
            }
            GradleBuildVariant.Builder profileBuilder = ProcessProfileWriter.getOrCreateVariant((String)this.project.getPath(), (String)variantProperties.getName()).setIsDebug(buildType.isDebuggable()).setMinSdkVersion(AnalyticsUtil.toProto(variantDslInfo.getMinSdkVersion())).setMinifyEnabled(variantScope.getCodeShrinker() != null).setUseMultidex(variantDslInfo.isMultiDexEnabled()).setUseLegacyMultidex(variantDslInfo.isLegacyMultiDexMode()).setVariantType(variantProperties.getVariantType().getAnalyticsVariantType()).setDexBuilder(AnalyticsUtil.toProto(variantScope.getDexer())).setDexMerger(AnalyticsUtil.toProto(variantScope.getDexMerger())).setCoreLibraryDesugaringEnabled(variantScope.isCoreLibraryDesugaringEnabled()).setTestExecution(AnalyticsUtil.toProto(this.globalScope.getExtension().getTestOptions().getExecutionEnum()));
            if (variantScope.getCodeShrinker() != null) {
                profileBuilder.setCodeShrinker(AnalyticsUtil.toProto(variantScope.getCodeShrinker()));
            }
            if (variantDslInfo.getTargetSdkVersion().getApiLevel() > 0) {
                profileBuilder.setTargetSdkVersion(AnalyticsUtil.toProto(variantDslInfo.getTargetSdkVersion()));
            }
            if (variantDslInfo.getMaxSdkVersion() != null) {
                profileBuilder.setMaxSdkVersion(ApiVersion.newBuilder().setApiLevel((long)variantDslInfo.getMaxSdkVersion().intValue()));
            }
            if ((supportType = variantScope.getJava8LangSupportType()) != VariantScope.Java8LangSupport.INVALID && supportType != VariantScope.Java8LangSupport.UNUSED) {
                profileBuilder.setJava8LangSupport(AnalyticsUtil.toProto(supportType));
            }
            if (this.variantFactory.getVariantType().getHasTestComponents()) {
                ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl> unitTest2;
                ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl> androidTest2;
                if (buildTypeData == testBuildTypeData && (androidTest2 = this.createTestComponents(dimensionCombination, buildTypeData, productFlavorDataList, (VariantImpl)variantInfo.getVariant(), variantProperties, (VariantType)VariantTypeImpl.ANDROID_TEST)) != null) {
                    this.addTestComponent(androidTest2);
                }
                if ((unitTest2 = this.createTestComponents(dimensionCombination, buildTypeData, productFlavorDataList, (VariantImpl)variantInfo.getVariant(), variantProperties, (VariantType)VariantTypeImpl.UNIT_TEST)) != null) {
                    this.addTestComponent(unitTest2);
                }
            }
        }
    }

    private void addVariant(ComponentInfo<VariantT, VariantPropertiesT> variant2) {
        this.variants.add(variant2);
    }

    private void addTestComponent(ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl> testComponent) {
        this.testComponents.add(testComponent);
    }

    private SigningConfig createSigningOverride() {
        SigningOptions signingOptions = SigningOptions.readSigningOptions(this.projectOptions);
        if (signingOptions != null) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            signingConfigDsl.setStoreFile(new File(signingOptions.getStoreFile()));
            signingConfigDsl.setStorePassword(signingOptions.getStorePassword());
            signingConfigDsl.setKeyAlias(signingOptions.getKeyAlias());
            signingConfigDsl.setKeyPassword(signingOptions.getKeyPassword());
            if (signingOptions.getStoreType() != null) {
                signingConfigDsl.setStoreType(signingOptions.getStoreType());
            }
            if (signingOptions.getV1Enabled() != null) {
                signingConfigDsl.setV1SigningEnabled(signingOptions.getV1Enabled());
            }
            if (signingOptions.getV2Enabled() != null) {
                signingConfigDsl.setV2SigningEnabled(signingOptions.getV2Enabled());
            }
            return signingConfigDsl;
        }
        return null;
    }

    private ManifestAttributeSupplier getParser(File file, boolean isManifestFileRequired) {
        return this.manifestParserMap.computeIfAbsent(file, f -> new DefaultManifestParser(f, this::canParseManifest, isManifestFileRequired, (IssueReporter)this.projectServices.getIssueReporter()));
    }

    private boolean canParseManifest() {
        return this.hasCreatedTasks || !this.projectOptions.get(BooleanOption.DISABLE_EARLY_MANIFEST_PARSING);
    }

    public void setHasCreatedTasks(boolean hasCreatedTasks) {
        this.hasCreatedTasks = hasCreatedTasks;
    }

    public void lockVariantProperties() {
        this.variantPropertiesApiServices.lockProperties();
    }
}

