/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.xml.AndroidManifestParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.xml.sax.SAXException;

@CacheableTransform
public abstract class LibrarySymbolTableTransform
implements TransformAction<GenericTransformParameters> {
    @Classpath
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs transformOutputs) {
        try {
            Path explodedAar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile().toPath();
            LibrarySymbolTableTransform.transform(explodedAar, transformOutputs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void transform(Path explodedAar, TransformOutputs transformOutputs) throws IOException {
        Path manifest = explodedAar.resolve("AndroidManifest.xml");
        if (!Files.exists(manifest, new LinkOption[0])) {
            return;
        }
        String packageName = LibrarySymbolTableTransform.getPackageName(manifest);
        Path rTxt = explodedAar.resolve("R.txt");
        Path outputFile = transformOutputs.file((Object)(packageName + "-r.txt")).toPath();
        SymbolIo.writeSymbolListWithPackageName((Path)rTxt, (String)packageName, (Path)outputFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPackageName(Path manifest) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
            String string = AndroidManifestParser.parse((InputStream)is).getPackage();
            return string;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to get package name from manifest " + manifest.toAbsolutePath(), e);
        }
    }
}

