/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.SdkComponents;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalBuildArtifactsHolder;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.OptionalCompilationStep;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope {
    private final Project project;
    private final DataBindingBuilder dataBindingBuilder;
    private BaseExtension extension;
    private final SdkComponents sdkComponents;
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final Set<OptionalCompilationStep> optionalCompilationSteps;
    private final MessageReceiver messageReceiver;
    private final SoftwareComponentFactory componentFactory;
    private final String createdBy;
    private final DslServices dslServices;
    private Configuration lintChecks;
    private Configuration lintPublish;
    private Configuration androidJarConfig;
    private final BuildArtifactsHolder globalArtifacts;
    private ConfigurableFileCollection bootClasspath = null;

    public GlobalScope(Project project2, String createdBy, DslServices dslServices, SdkComponents sdkComponents, ToolingModelBuilderRegistry toolingRegistry, MessageReceiver messageReceiver, SoftwareComponentFactory componentFactory) {
        this.project = (Project)Preconditions.checkNotNull((Object)project2);
        this.createdBy = createdBy;
        this.dslServices = (DslServices)Preconditions.checkNotNull((Object)dslServices);
        this.sdkComponents = (SdkComponents)Preconditions.checkNotNull((Object)sdkComponents);
        this.toolingRegistry = (ToolingModelBuilderRegistry)Preconditions.checkNotNull((Object)toolingRegistry);
        this.optionalCompilationSteps = (Set)Preconditions.checkNotNull(dslServices.getProjectOptions().getOptionalCompilationSteps());
        this.messageReceiver = messageReceiver;
        this.componentFactory = componentFactory;
        this.globalArtifacts = new GlobalBuildArtifactsHolder(project2, (Function0<? extends File>)((Function0)this::getBuildDir));
        this.lintChecks = project2.getConfigurations().detachedConfiguration(new Dependency[0]);
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(SyncOptions.getErrorFormatMode(dslServices.getProjectOptions()) == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE);
    }

    public void setExtension(BaseExtension extension) {
        this.extension = (BaseExtension)Preconditions.checkNotNull((Object)extension);
    }

    public Project getProject() {
        return this.project;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public String getProjectBaseName() {
        return (String)this.project.property("archivesBaseName");
    }

    public SdkComponents getSdkComponents() {
        return this.sdkComponents;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    public File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    public File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    public File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    public File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    public File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    public File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    public String getArchivesBaseName() {
        return (String)this.getProject().getProperties().get("archivesBaseName");
    }

    public File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    public File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    public ProjectOptions getProjectOptions() {
        return this.dslServices.getProjectOptions();
    }

    public void setLintChecks(Configuration lintChecks) {
        this.lintChecks = lintChecks;
    }

    public void setLintPublish(Configuration lintPublish) {
        this.lintPublish = lintPublish;
    }

    public void setAndroidJarConfig(Configuration androidJarConfig) {
        this.androidJarConfig = androidJarConfig;
    }

    public FileCollection getMockableJarArtifact() {
        return this.getMockableJarArtifact(this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues());
    }

    public FileCollection getMockableJarArtifact(boolean returnDefaultValues) {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-mockable-jar").attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)returnDefaultValues);
        return this.androidJarConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPlatformAttrs() {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-platform-attr");
        return this.androidJarConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    @Deprecated
    public DslServices getDslServices() {
        return this.dslServices;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public FileCollection getLocalCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintChecks.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPublishedCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintPublish.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public BuildArtifactsHolder getArtifacts() {
        return this.globalArtifacts;
    }

    public boolean hasDynamicFeatures() {
        BaseExtension extension = this.getExtension();
        if (extension instanceof BaseAppModuleExtension) {
            return !((BaseAppModuleExtension)extension).getDynamicFeatures().isEmpty();
        }
        return false;
    }

    public FileCollection getBootClasspath() {
        if (this.bootClasspath == null) {
            this.bootClasspath = this.project.files(new Object[]{this.getFilteredBootClasspath()});
            if (this.extension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                this.bootClasspath.from(new Object[]{this.getSdkComponents().getCoreLambdaStubsProvider()});
            }
        }
        return this.bootClasspath;
    }

    public FileCollection getFilteredBootClasspath() {
        return BootClasspathBuilder.INSTANCE.computeClasspath(this.project, this.getDslServices().getIssueReporter(), this.getSdkComponents().getTargetBootClasspathProvider(), this.getSdkComponents().getTargetAndroidVersionProvider(), this.getSdkComponents().getAdditionalLibrariesProvider(), this.getSdkComponents().getOptionalLibrariesProvider(), this.getSdkComponents().getAnnotationsJarProvider(), false, (List<LibraryRequest>)ImmutableList.copyOf(this.getExtension().getLibraryRequests()));
    }

    public FileCollection getFullBootClasspath() {
        return BootClasspathBuilder.INSTANCE.computeClasspath(this.project, this.getDslServices().getIssueReporter(), this.getSdkComponents().getTargetBootClasspathProvider(), this.getSdkComponents().getTargetAndroidVersionProvider(), this.getSdkComponents().getAdditionalLibrariesProvider(), this.getSdkComponents().getOptionalLibrariesProvider(), this.getSdkComponents().getAnnotationsJarProvider(), true, (List<LibraryRequest>)ImmutableList.of());
    }

    public SoftwareComponentFactory getComponentFactory() {
        return this.componentFactory;
    }
}

