/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.signing;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.gradle.internal.component.BaseCreationConfig;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigProviderParams;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.options.SigningOptions;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/signing/SigningConfigProvider;", "", "signingConfigData", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "signingConfigFileCollection", "Lorg/gradle/api/file/FileCollection;", "signingConfigValidationResultDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "(Lcom/android/build/gradle/internal/signing/SigningConfigData;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/Provider;)V", "getSigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigData;", "getSigningConfigFileCollection", "()Lorg/gradle/api/file/FileCollection;", "getSigningConfigValidationResultDir", "()Lorg/gradle/api/provider/Provider;", "convertToParams", "Lcom/android/build/gradle/internal/signing/SigningConfigProviderParams;", "resolve", "Companion", "gradle"})
public final class SigningConfigProvider {
    @Nullable
    private final SigningConfigData signingConfigData;
    @Nullable
    private final FileCollection signingConfigFileCollection;
    @Nullable
    private final Provider<Directory> signingConfigValidationResultDir;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final SigningConfigData resolve() {
        return this.convertToParams().resolve();
    }

    @NotNull
    public final SigningConfigProviderParams convertToParams() {
        File file;
        SigningConfigData signingConfigData = this.signingConfigData;
        FileCollection fileCollection2 = this.signingConfigFileCollection;
        if (fileCollection2 != null) {
            FileCollection fileCollection3 = fileCollection2;
            SigningConfigData signingConfigData2 = signingConfigData;
            boolean bl = false;
            boolean bl2 = false;
            FileCollection it = fileCollection3;
            boolean bl3 = false;
            File file2 = it.getSingleFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.singleFile");
            File file3 = SigningConfigUtils.Companion.getSigningConfigFile(file2);
            signingConfigData = signingConfigData2;
            file = file3;
        } else {
            file = null;
        }
        File file4 = file;
        SigningConfigData signingConfigData3 = signingConfigData;
        return new SigningConfigProviderParams(signingConfigData3, file4);
    }

    @Nested
    @Optional
    @Nullable
    public final SigningConfigData getSigningConfigData() {
        return this.signingConfigData;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @Nullable
    public final FileCollection getSigningConfigFileCollection() {
        return this.signingConfigFileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @Nullable
    public final Provider<Directory> getSigningConfigValidationResultDir() {
        return this.signingConfigValidationResultDir;
    }

    public SigningConfigProvider(@Nullable SigningConfigData signingConfigData, @Nullable FileCollection signingConfigFileCollection, @Nullable Provider<Directory> signingConfigValidationResultDir) {
        this.signingConfigData = signingConfigData;
        this.signingConfigFileCollection = signingConfigFileCollection;
        this.signingConfigValidationResultDir = signingConfigValidationResultDir;
    }

    @JvmStatic
    @NotNull
    public static final SigningConfigProvider create(@NotNull BaseCreationConfig creationConfig) {
        return Companion.create(creationConfig);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/signing/SigningConfigProvider$Companion;", "", "()V", "create", "Lcom/android/build/gradle/internal/signing/SigningConfigProvider;", "creationConfig", "Lcom/android/build/gradle/internal/component/BaseCreationConfig;", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SigningConfigProvider create(@NotNull BaseCreationConfig creationConfig) {
            SigningConfigData signingConfigData;
            boolean isInDynamicFeature;
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            boolean bl = isInDynamicFeature = creationConfig.getVariantType().isDynamicFeature() || creationConfig instanceof TestComponentPropertiesImpl && ((TestComponentPropertiesImpl)creationConfig).getTestedConfig().getVariantType().isDynamicFeature();
            if (!isInDynamicFeature) {
                SigningConfig signingConfig = creationConfig.getVariantDslInfo().getSigningConfig();
                if (signingConfig != null) {
                    SigningConfigData signingConfigData2;
                    SigningConfig signingConfig2 = signingConfig;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SigningConfig it = signingConfig2;
                    boolean bl4 = false;
                    signingConfigData = signingConfigData2 = SigningConfigData.Companion.fromSigningConfig(it);
                } else {
                    signingConfigData = null;
                }
            } else {
                SigningConfigProvider signingConfigProvider;
                SigningOptions signingOptions = SigningOptions.readSigningOptions(creationConfig.getServices().getProjectOptions());
                if (signingOptions != null && signingOptions.getV1Enabled() != null && signingOptions.getV2Enabled() != null) {
                    String string = signingOptions.getStoreType();
                    File file = new File(signingOptions.getStoreFile());
                    String string2 = signingOptions.getStorePassword();
                    String string3 = signingOptions.getKeyAlias();
                    String string4 = signingOptions.getKeyPassword();
                    Boolean bl5 = signingOptions.getV1Enabled();
                    if (bl5 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl5, (String)"signingOptions.v1Enabled!!");
                    boolean bl6 = bl5;
                    Boolean bl7 = signingOptions.getV2Enabled();
                    if (bl7 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl7, (String)"signingOptions.v2Enabled!!");
                    boolean bl8 = bl7;
                    Boolean bl9 = signingOptions.getV1Configured();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl9, (String)"signingOptions.v1Configured");
                    boolean bl10 = bl9;
                    Boolean bl11 = signingOptions.getV2Configured();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl11, (String)"signingOptions.v2Configured");
                    signingConfigProvider = new SigningConfigProvider(new SigningConfigData("SigningConfigReceivedFromIDE", string, file, string2, string3, string4, bl6, bl8, bl10, bl11), null, null);
                } else {
                    signingConfigProvider = new SigningConfigProvider(null, creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_SIGNING_CONFIG), null);
                }
                return signingConfigProvider;
            }
            Provider provider = creationConfig.getArtifacts().getFinalProduct((ArtifactType)InternalArtifactType.VALIDATE_SIGNING_CONFIG.INSTANCE);
            FileCollection fileCollection2 = null;
            SigningConfigData signingConfigData3 = signingConfigData;
            return new SigningConfigProvider(signingConfigData3, fileCollection2, provider);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

