/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.InstrumentationTestAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.OnDeviceOrchestratorTestRunner;
import com.android.build.gradle.internal.testing.ShardedTestRunner;
import com.android.build.gradle.internal.testing.SimpleTestRunner;
import com.android.build.gradle.internal.testing.TestRunner;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.TestOptions;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.process.ExecOperations;
import org.xml.sax.SAXException;

public abstract class DeviceProviderInstrumentTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private static final Predicate<File> IS_APK = file -> "apk".equals(Files.getFileExtension((String)file.getName()));
    private DeviceProvider deviceProvider;
    private final DirectoryProperty coverageDir;
    private File reportsDir;
    private FileCollection buddyApks;
    private FileCollection testTargetManifests;
    private ProcessExecutor processExecutor;
    private String flavorName;
    private Provider<File> splitSelectExecProvider;
    private AbstractTestDataImpl testData;
    private TestRunnerFactory testRunnerFactory;
    private boolean ignoreFailures;
    private boolean testFailed;
    private boolean codeCoverageEnabled;
    private TestOptions.Execution testExecution;
    private Configuration dependencies;
    private final ExecOperations execOperations;
    private Collection<String> installOptions;

    @Internal
    public ExecutorServiceAdapter getExecutorServiceAdapter() {
        return Workers.INSTANCE.withThreads(this.getProjectName(), this.getPath());
    }

    @Inject
    public DeviceProviderInstrumentTestTask(ObjectFactory objectFactory, ExecOperations execOperations) {
        this.coverageDir = objectFactory.directoryProperty();
        this.execOperations = execOperations;
    }

    @Override
    protected void doTaskAction() throws DeviceException, IOException, ParserConfigurationException, SAXException, ExecutionException {
        boolean success;
        File additionalTestOutputDir;
        DeviceProviderInstrumentTestTask.checkForNonApks(this.buddyApks.getFiles(), message -> {
            throw new InvalidUserDataException(message);
        });
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        if (((Boolean)this.getAdditionalTestOutputEnabled().get()).booleanValue()) {
            additionalTestOutputDir = ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile();
            FileUtils.cleanOutputDir((File)additionalTestOutputDir);
        } else {
            additionalTestOutputDir = null;
        }
        File coverageOutDir = ((Directory)this.getCoverageDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)coverageOutDir);
        if (!this.testTargetManifests.isEmpty()) {
            this.testData.load(this.testTargetManifests.getSingleFile());
        }
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageOutDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success = true;
        } else {
            GradleProcessExecutor gradleProcessExecutor = new GradleProcessExecutor(arg_0 -> ((ExecOperations)this.execOperations).exec(arg_0));
            success = (Boolean)this.deviceProvider.use(() -> {
                TestRunner testRunner = this.testRunnerFactory.build((File)this.getSplitSelectExec().get(), gradleProcessExecutor);
                ImmutableList extraArgs = this.installOptions == null || this.installOptions.isEmpty() ? ImmutableList.of() : this.installOptions;
                try {
                    return testRunner.runTests(this.getProject().getName(), this.getFlavorName(), this.testData, this.buddyApks.getFiles(), this.deviceProvider.getDevices(), this.deviceProvider.getTimeoutInMs(), (Collection<String>)extraArgs, resultsOutDir, (Boolean)this.getAdditionalTestOutputEnabled().get(), additionalTestOutputDir, coverageOutDir, new LoggerWrapper(this.getLogger()));
                }
                catch (Exception e) {
                    InstrumentationTestAnalytics.recordCrashedTestRun(this.dependencies, this.testExecution, this.codeCoverageEnabled);
                    throw e;
                }
            });
        }
        File reportOutDir = this.getReportsDir();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report2 = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results = report2.generateReport();
        InstrumentationTestAnalytics.recordOkTestRun(this.dependencies, this.testExecution, this.codeCoverageEnabled, results.getTestCount());
        if (!success) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
        this.testFailed = false;
    }

    public static void checkForNonApks(Collection<File> buddyApksFiles, Consumer<String> errorHandler) {
        List nonApks = buddyApksFiles.stream().filter(IS_APK.negate()).collect(Collectors.toList());
        if (!nonApks.isEmpty()) {
            Collections.sort(nonApks);
            String message = String.format("Not all files in %s configuration are APKs: %s", "androidTestUtil", Joiner.on((char)' ').join(nonApks));
            errorHandler.accept(message);
        }
    }

    private boolean testsFound() {
        return !this.getProject().files(new Object[]{this.testData.getTestDirectories()}).getAsFileTree().isEmpty();
    }

    @OutputDirectory
    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    @Override
    @OutputDirectory
    public abstract DirectoryProperty getResultsDir();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @OutputDirectory
    public DirectoryProperty getCoverageDir() {
        return this.coverageDir;
    }

    @Deprecated
    public void setCoverageDir(File coverageDir) {
        this.getLogger().info("DeviceProviderInstrumentTestTask.setCoverageDir is deprecated and has no effect.");
    }

    @Internal
    public String getFlavorName() {
        return this.flavorName;
    }

    public void setFlavorName(String flavorName2) {
        this.flavorName = flavorName2;
    }

    @Input
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @Input
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @Internal
    public DeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    @Internal
    public AbstractTestDataImpl getTestData() {
        return this.testData;
    }

    public void setTestData(AbstractTestDataImpl testData) {
        this.testData = testData;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public Provider<File> getSplitSelectExec() {
        return this.splitSelectExecProvider;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.testFailed;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getTestTargetManifests() {
        return this.testTargetManifests;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getBuddyApks() {
        return this.buddyApks;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Provider<Directory> getTestApkDir() {
        return this.testData.getTestApkDir();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getTestedApksDir() {
        return this.testData.getTestedApksDir();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getTestedApksFromBundle() {
        return this.testData.getTestedApksFromBundle();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DeviceProviderInstrumentTestTask, ComponentPropertiesImpl> {
        private final DeviceProvider deviceProvider;
        private final Type type;
        private final AbstractTestDataImpl testData;
        private final FileCollection testTargetManifests;

        public CreationAction(ComponentPropertiesImpl componentProperties, DeviceProvider deviceProvider, Type type, AbstractTestDataImpl testData, FileCollection testTargetManifests) {
            super(componentProperties);
            this.deviceProvider = deviceProvider;
            this.type = type;
            this.testData = testData;
            this.testTargetManifests = testTargetManifests;
        }

        @Override
        public String getName() {
            return this.computeTaskName(this.deviceProvider.getName());
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends DeviceProviderInstrumentTestTask> taskProvider) {
            super.handleProvider(taskProvider);
            boolean isAdditionalAndroidTestOutputEnabled = ((ComponentPropertiesImpl)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                if (isAdditionalAndroidTestOutputEnabled) {
                    ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().producesDir(InternalArtifactType.CONNECTED_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir, this.deviceProvider.getName());
                }
                ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().producesDir(InternalArtifactType.CODE_COVERAGE.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getCoverageDir, this.deviceProvider.getName());
            } else {
                if (isAdditionalAndroidTestOutputEnabled) {
                    ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().producesDir(InternalArtifactType.DEVICE_PROVIDER_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getAdditionalTestOutputDir, this.deviceProvider.getName());
                }
                ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().producesDir(InternalArtifactType.DEVICE_PROVIDER_CODE_COVERAGE.INSTANCE, taskProvider, DeviceProviderInstrumentTestTask::getCoverageDir, this.deviceProvider.getName());
            }
            if (this.creationConfig instanceof TestComponentPropertiesImpl) {
                if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                    ((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().setConnectedTestTask(taskProvider);
                    ((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().setConnectedTask(taskProvider);
                } else {
                    ((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().getProviderTestTaskList().add(taskProvider);
                }
            }
        }

        @Override
        public void configure(DeviceProviderInstrumentTestTask task) {
            String variantName;
            super.configure(task);
            GlobalScope globalScope = ((ComponentPropertiesImpl)this.creationConfig).getGlobalScope();
            Project project2 = globalScope.getProject();
            ProjectOptions projectOptions = ((ComponentPropertiesImpl)this.creationConfig).getServices().getProjectOptions();
            VariantCreationConfig testedConfig = ((ComponentPropertiesImpl)this.creationConfig).getTestedConfig();
            String string = variantName = testedConfig != null ? testedConfig.getName() : ((ComponentPropertiesImpl)this.creationConfig).getName();
            if (this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription(StringHelper.appendCapitalized((String)("Installs and runs the tests for " + variantName + " using provider: "), (String)this.deviceProvider.getName()));
            }
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.setGroup("verification");
            task.setTestData(this.testData);
            task.setFlavorName(this.testData.getFlavorName());
            task.setDeviceProvider(this.deviceProvider);
            task.testTargetManifests = this.testTargetManifests;
            task.setInstallOptions(globalScope.getExtension().getAdbOptions().getInstallOptions());
            boolean shardBetweenDevices = projectOptions.get(BooleanOption.ENABLE_TEST_SHARDING);
            TestOptions.Execution executionEnum = globalScope.getExtension().getTestOptions().getExecutionEnum();
            switch (executionEnum) {
                case ANDROID_TEST_ORCHESTRATOR: 
                case ANDROIDX_TEST_ORCHESTRATOR: {
                    Preconditions.checkArgument((!shardBetweenDevices ? 1 : 0) != 0, (Object)"Sharding is not supported with Android Test Orchestrator.");
                    task.testRunnerFactory = (splitSelect, processExecutor2) -> new OnDeviceOrchestratorTestRunner(splitSelect, processExecutor2, executionEnum, task.getExecutorServiceAdapter());
                    break;
                }
                case HOST: {
                    if (shardBetweenDevices) {
                        Integer numShards = projectOptions.get(IntegerOption.ANDROID_TEST_SHARD_COUNT);
                        task.testRunnerFactory = (splitSelect, processExecutor2) -> new ShardedTestRunner(splitSelect, processExecutor2, numShards, task.getExecutorServiceAdapter());
                        break;
                    }
                    task.testRunnerFactory = (splitSelect, processExecutor2) -> new SimpleTestRunner(splitSelect, processExecutor2, task.getExecutorServiceAdapter());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown value " + executionEnum));
                }
            }
            task.codeCoverageEnabled = ((ComponentPropertiesImpl)this.creationConfig).getVariantDslInfo().isTestCoverageEnabled();
            task.dependencies = ((ComponentPropertiesImpl)this.creationConfig).getVariantDependencies().getRuntimeClasspath();
            task.testExecution = executionEnum;
            String flavorFolder = this.testData.getFlavorName();
            if (!flavorFolder.isEmpty()) {
                flavorFolder = "flavors/" + flavorFolder;
            }
            String providerFolder = this.type == Type.INTERNAL_CONNECTED_DEVICE_PROVIDER ? "connected" : "device/" + this.deviceProvider.getName();
            String subFolder = "/" + providerFolder + "/" + flavorFolder;
            task.splitSelectExecProvider = globalScope.getSdkComponents().getSplitSelectExecutableProvider();
            String rootLocation = globalScope.getExtension().getTestOptions().getResultsDir();
            if (rootLocation == null) {
                rootLocation = globalScope.getBuildDir() + "/" + "outputs" + "/" + "androidTest-results";
            }
            task.getResultsDir().set(new File(rootLocation + subFolder));
            rootLocation = globalScope.getExtension().getTestOptions().getReportDir();
            if (rootLocation == null) {
                rootLocation = globalScope.getBuildDir() + "/" + "reports" + "/" + "androidTests";
            }
            task.reportsDir = project2.file((Object)(rootLocation + subFolder));
            task.buddyApks = (FileCollection)MoreObjects.firstNonNull((Object)project2.getConfigurations().findByName("androidTestUtil"), (Object)project2.files(new Object[0]));
            task.setEnabled(this.deviceProvider.isConfigured());
            task.getOutputs().upToDateWhen(it -> false);
        }

        public static enum Type {
            INTERNAL_CONNECTED_DEVICE_PROVIDER,
            CUSTOM_DEVICE_PROVIDER;

        }
    }

    private static interface TestRunnerFactory {
        public TestRunner build(File var1, ProcessExecutor var2);
    }
}

