/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

public abstract class UninstallTask
extends NonIncrementalTask {
    private String variantName;
    private Provider<String> applicationId;
    private int mTimeOutInMs = 0;
    private Provider<File> adbExecutableProvider;

    public UninstallTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Uninstall task is always run.");
            return false;
        });
    }

    @Override
    protected void doTaskAction() throws DeviceException, ExecutionException {
        Logger logger = this.getLogger();
        logger.info("Uninstalling app: {}", this.applicationId);
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider((File)this.adbExecutableProvider.get(), this.getTimeOutInMs(), (ILogger)iLogger);
        deviceProvider.use(() -> {
            List devices = deviceProvider.getDevices();
            for (DeviceConnector device : devices) {
                device.uninstallPackage((String)this.applicationId.get(), this.getTimeOutInMs(), iLogger);
                logger.lifecycle("Uninstalling {} (from {}:{}) from device '{}' ({}).", new Object[]{this.applicationId, this.getProject().getName(), this.variantName, device.getName(), device.getSerialNumber()});
            }
            int n = devices.size();
            logger.quiet("Uninstalled {} from {} device{}.", new Object[]{this.applicationId, n, n == 1 ? "" : "s"});
            return null;
        });
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public File getAdbExe() {
        return (File)this.adbExecutableProvider.get();
    }

    @Input
    public int getTimeOutInMs() {
        return this.mTimeOutInMs;
    }

    public void setTimeOutInMs(int timeoutInMs) {
        this.mTimeOutInMs = timeoutInMs;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<UninstallTask, ApkCreationConfig> {
        public CreationAction(ApkCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("uninstall");
        }

        @Override
        public Class<UninstallTask> getType() {
            return UninstallTask.class;
        }

        @Override
        public void configure(UninstallTask task) {
            super.configure(task);
            task.variantName = ((ApkCreationConfig)this.creationConfig).getName();
            task.applicationId = ((ApkCreationConfig)this.creationConfig).getApplicationId();
            task.setDescription("Uninstalls the " + ((ApkCreationConfig)this.creationConfig).getDescription() + ".");
            task.setGroup("Install");
            task.setTimeOutInMs(((ApkCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            task.adbExecutableProvider = ((ApkCreationConfig)this.creationConfig).getGlobalScope().getSdkComponents().getAdbExecutableProvider();
        }

        @Override
        public void handleProvider(TaskProvider<? extends UninstallTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setUninstallTask(taskProvider);
        }
    }
}

