/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.innerclass;

import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.build.gradle.internal.tasks.mlkit.codegen.CodeUtils;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.CodeInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.InjectorUtils;
import com.android.tools.mlkit.TensorInfo;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;

public class OutputsClassInjector
implements CodeInjector<TypeSpec.Builder, List<TensorInfo>> {
    @Override
    public void inject(TypeSpec.Builder classBuilder, List<TensorInfo> tensorInfos) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Outputs");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TensorInfo tensorInfo : tensorInfos) {
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)CodeUtils.getParameterType(tensorInfo), (String)tensorInfo.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            builder.addField(fieldSpec);
        }
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TensorInfo tensorInfo : tensorInfos) {
            constructorBuilder.addStatement("this.$L = TensorBuffer.createFixedSize($L, $T.$L)", new Object[]{tensorInfo.getName(), CodeUtils.getIntArrayString(tensorInfo.getShape()), ClassNames.DATA_TYPE, CodeUtils.getDataType(tensorInfo.getDataType())});
        }
        builder.addMethod(constructorBuilder.build());
        for (TensorInfo tensorInfo : tensorInfos) {
            InjectorUtils.getGetterMethodInjector(tensorInfo).inject(builder, tensorInfo);
        }
        this.buildGetBufferMethod(builder, tensorInfos);
        classBuilder.addType(builder.build());
    }

    private void buildGetBufferMethod(TypeSpec.Builder classBuilder, List<TensorInfo> tensorInfos) {
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassNames.MAP, (TypeName[])new TypeName[]{ClassNames.INTEGER, ClassNames.OBJECT});
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)"getBuffer").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)mapType).addStatement("$T outputs = new $T<>()", new Object[]{mapType, ClassNames.HASH_MAP});
        int index = 0;
        for (TensorInfo tensorInfo : tensorInfos) {
            getterBuilder.addStatement("outputs.put($L, $L.getBuffer())", new Object[]{index, tensorInfo.getName()});
            ++index;
        }
        getterBuilder.addStatement("return outputs", new Object[0]);
        classBuilder.addMethod(getterBuilder.build());
    }
}

