/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.SimpleHtmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.reporting.ReportRenderer;

public class TabsRenderer<T>
extends ReportRenderer<T, SimpleHtmlWriter> {
    private final List<TabDefinition> tabs = new ArrayList<TabDefinition>();

    public void add(String title, ReportRenderer<T, SimpleHtmlWriter> contentRenderer) {
        this.tabs.add(new TabDefinition(title, contentRenderer));
    }

    public void clear() {
        this.tabs.clear();
    }

    public void render(T model2, SimpleHtmlWriter htmlWriterWriter) throws IOException {
        String tabId;
        TabDefinition tab;
        int i2;
        htmlWriterWriter.startElement("div").attribute("id", "tabs");
        htmlWriterWriter.startElement("ul").attribute("class", "tabLinks");
        for (i2 = 0; i2 < this.tabs.size(); ++i2) {
            tab = this.tabs.get(i2);
            tabId = String.format("tab%s", i2);
            htmlWriterWriter.startElement("li");
            htmlWriterWriter.startElement("a").attribute("href", "#" + tabId).characters(tab.title).endElement();
            htmlWriterWriter.endElement();
        }
        htmlWriterWriter.endElement();
        for (i2 = 0; i2 < this.tabs.size(); ++i2) {
            tab = this.tabs.get(i2);
            tabId = String.format("tab%s", i2);
            htmlWriterWriter.startElement("div").attribute("id", tabId).attribute("class", "tab");
            htmlWriterWriter.startElement("h2").characters(tab.title).endElement();
            tab.renderer.render(model2, (Object)htmlWriterWriter);
            htmlWriterWriter.endElement();
        }
        htmlWriterWriter.endElement();
    }

    private class TabDefinition {
        final String title;
        final ReportRenderer<T, SimpleHtmlWriter> renderer;

        private TabDefinition(String title, ReportRenderer<T, SimpleHtmlWriter> renderer) {
            this.title = title;
            this.renderer = renderer;
        }
    }
}

