/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.component.BaseCreationConfig;
import com.android.build.gradle.internal.dependency.L8DexDesugarLibTransformKt;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibLintExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002\u001a \u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\"\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"ATTR_LINT_COMPILE_SDK", "Lorg/gradle/api/attributes/Attribute;", "", "ATTR_LINT_MIN_SDK", "DESUGAR_LIB_CONFIG", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_DEX", "DESUGAR_LIB_LINT", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibConfiguration", "getDesugarLibDexFromTransform", "creationConfig", "Lcom/android/build/gradle/internal/component/BaseCreationConfig;", "minSdkVersion", "", "getDesugarLibJarFromMaven", "getDesugarLibLintFiles", "", "Ljava/io/File;", "coreLibraryDesugaringEnabled", "", "Lcom/android/sdklib/AndroidVersion;", "compileSdkVersion", "getDesugarLibLintFromTransform", "registerDesugarLibConfigTransform", "", "registerDesugarLibLintTransform", "gradle"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-lib-dex";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";
    private static final String DESUGAR_LIB_LINT = "_internal-desugar-lib-lint";
    private static final Attribute<String> ATTR_LINT_MIN_SDK;
    private static final Attribute<String> ATTR_LINT_COMPILE_SDK;

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration configuration2 = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getArtifactCollection(configuration2);
    }

    @NotNull
    public static final FileCollection getDesugarLibDexFromTransform(@NotNull BaseCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        if (!creationConfig.getVariantScope().isCoreLibraryDesugaringEnabled()) {
            ConfigurableFileCollection configurableFileCollection = creationConfig.getGlobalScope().getProject().files(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"creationConfig.globalScope.project.files()");
            return (FileCollection)configurableFileCollection;
        }
        Project project2 = creationConfig.getGlobalScope().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"creationConfig.globalScope.project");
        Configuration configuration2 = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getDesugarLibDexFromTransform(configuration2, creationConfig.getMinSdkVersion().getFeatureLevel());
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration2 = (Configuration)object;
        DesugarLibUtils.registerDesugarLibConfigTransform(project2);
        Provider provider = DesugarLibUtils.getDesugarLibConfigFromTransform(configuration2).getElements().map((Transformer)getDesugarLibConfig.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"getDesugarLibConfigFromT\u2026oString()\n        }\n    }");
        return provider;
    }

    @NotNull
    public static final Collection<File> getDesugarLibLintFiles(@NotNull Project project2, boolean coreLibraryDesugaringEnabled, @NotNull AndroidVersion minSdkVersion, @Nullable String compileSdkVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)minSdkVersion, (String)"minSdkVersion");
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration2 = (Configuration)object;
        if (compileSdkVersion == null || !coreLibraryDesugaringEnabled || configuration2.getDependencies().isEmpty()) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        int minSdk = minSdkVersion.getFeatureLevel();
        AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)compileSdkVersion);
        if (androidVersion == null) {
            Intrinsics.throwNpe();
        }
        int compileSdk = androidVersion.getFeatureLevel();
        DesugarLibUtils.registerDesugarLibLintTransform(project2, minSdk, compileSdk);
        Set set = DesugarLibUtils.getDesugarLibLintFromTransform(configuration2, minSdk, compileSdk).getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"getDesugarLibLintFromTra\u2026inSdk, compileSdk ).files");
        return set;
    }

    private static final Configuration getDesugarLibConfiguration(Project project2) {
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration2 = (Configuration)object;
        if (configuration2.getDependencies().isEmpty()) {
            throw (Throwable)new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration2;
    }

    private static final FileCollection getDesugarLibDexFromTransform(Configuration configuration2, int minSdkVersion) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(minSdkVersion){
            final /* synthetic */ int $minSdkVersion;

            public final void execute(ArtifactView.ViewConfiguration config2) {
                config2.attributes((Action)new Action<AttributeContainer>(this){
                    final /* synthetic */ getDesugarLibDexFromTransform.1 this$0;

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-dex");
                        it.attribute(L8DexDesugarLibTransformKt.getATTR_L8_MIN_SDK(), (Object)String.valueOf(this.this$0.$minSdkVersion));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$minSdkVersion = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026String())\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getDesugarLibConfigFromTransform.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(Project project2) {
        project2.getDependencies().registerTransform(DesugarLibConfigExtractor.class, (Action)registerDesugarLibConfigTransform.1.INSTANCE);
    }

    private static final void registerDesugarLibLintTransform(Project project2, int minSdkVersion, int compileSdkVersion) {
        project2.getDependencies().registerTransform(DesugarLibLintExtractor.class, (Action)new Action<TransformSpec<DesugarLibLintExtractor.Parameters>>(minSdkVersion, compileSdkVersion){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;

            public final void execute(TransformSpec<DesugarLibLintExtractor.Parameters> spec2) {
                spec2.parameters((Action)new Action<DesugarLibLintExtractor.Parameters>(this){
                    final /* synthetic */ registerDesugarLibLintTransform.1 this$0;

                    public final void execute(DesugarLibLintExtractor.Parameters parameters) {
                        parameters.getMinSdkVersion().set((Object)this.this$0.$minSdkVersion);
                        parameters.getCompileSdkVersion().set((Object)this.this$0.$compileSdkVersion);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                TransformSpec<DesugarLibLintExtractor.Parameters> transformSpec = spec2;
                Intrinsics.checkExpressionValueIsNotNull(transformSpec, (String)"spec");
                transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                spec2.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec2.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec2.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                spec2.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
            }
            {
                this.$minSdkVersion = n;
                this.$compileSdkVersion = n2;
            }
        });
    }

    private static final FileCollection getDesugarLibLintFromTransform(Configuration configuration2, int minSdkVersion, int compileSdkVersion) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(minSdkVersion, compileSdkVersion){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;

            public final void execute(ArtifactView.ViewConfiguration configuration2) {
                configuration2.attributes((Action)new Action<AttributeContainer>(this){
                    final /* synthetic */ getDesugarLibLintFromTransform.1 this$0;

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.this$0.$minSdkVersion));
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.this$0.$compileSdkVersion));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$minSdkVersion = n;
                this.$compileSdkVersion = n2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026String())\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    static {
        Attribute attribute = Attribute.of((String)"lint-min-sdk", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"Attribute.of(\"lint-min-sdk\", String::class.java)");
        ATTR_LINT_MIN_SDK = attribute;
        Attribute attribute2 = Attribute.of((String)"lint-compile-sdk", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute2, (String)"Attribute.of(\"lint-compi\u2026sdk\", String::class.java)");
        ATTR_LINT_COMPILE_SDK = attribute2;
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_MIN_SDK$p() {
        return ATTR_LINT_MIN_SDK;
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_COMPILE_SDK$p() {
        return ATTR_LINT_COMPILE_SDK;
    }
}

