/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.builder.errors.IssueReporter;

public abstract class AbstractAppVariantFactory<VariantT extends VariantImpl<VariantPropertiesT>, VariantPropertiesT extends VariantPropertiesImpl>
extends BaseVariantFactory<VariantT, VariantPropertiesT> {
    public AbstractAppVariantFactory(ProjectServices projectServices, GlobalScope globalScope) {
        super(projectServices, globalScope);
    }

    @Override
    public BaseVariantData createVariantData(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantPropertiesApiServices services2, GlobalScope globalScope, MutableTaskContainer taskContainer) {
        return new ApplicationVariantData(componentIdentity, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, services2, globalScope, taskContainer);
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return ApplicationVariantImpl.class;
    }

    @Override
    public void validateModel(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model2) {
        super.validateModel(model2);
        this.validateVersionCodes(model2);
        if (!this.getVariantType().isDynamicFeature()) {
            return;
        }
        SyncIssueReporter issueReporter = this.projectServices.getIssueReporter();
        for (BuildTypeData<BuildType> buildType : model2.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Dynamic feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\nTo enable minification for a dynamic feature module, set minifyEnabled to true in the base module.");
        }
        String message = "Signing configuration should not be declared in build types of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (BuildTypeData<BuildType> buildTypeData : model2.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getSigningConfig() == null) continue;
            issueReporter.reportWarning(IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, message);
        }
        message = "Signing configuration should not be declared in product flavors of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getSigningConfig() == null) continue;
            issueReporter.reportWarning(IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, message);
        }
        message = "abiFilters should not be declared in dynamic-features. Dynamic-features use the abiFilters declared in the application module.";
        if (model2.getDefaultConfigData().getDefaultConfig().getNdkConfig() != null && model2.getDefaultConfigData().getDefaultConfig().getNdkConfig().getAbiFilters() != null) {
            issueReporter.reportWarning(IssueReporter.Type.GENERIC, message);
        }
        for (BuildTypeData buildTypeData : model2.getBuildTypes().values()) {
            if (((BuildType)buildTypeData.getBuildType()).getNdkConfig().getAbiFilters() == null) continue;
            issueReporter.reportWarning(IssueReporter.Type.GENERIC, message);
        }
        for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getNdkConfig() == null || ((ProductFlavor)productFlavorData.getProductFlavor()).getNdkConfig().getAbiFilters() == null) continue;
            issueReporter.reportWarning(IssueReporter.Type.GENERIC, message);
        }
    }

    @Override
    public void createDefaultComponents(DslContainerProvider<DefaultConfig, BuildType, ProductFlavor, SigningConfig> dslContainers) {
        dslContainers.getSigningConfigContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("release");
    }

    private void validateVersionCodes(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model2) {
        SyncIssueReporter issueReporter = this.projectServices.getIssueReporter();
        Integer versionCode = model2.getDefaultConfigData().getDefaultConfig().getVersionCode();
        if (versionCode != null && versionCode < 1) {
            issueReporter.reportError(IssueReporter.Type.GENERIC, "android.defaultConfig.versionCode is set to " + versionCode + ", but it should be a positive integer.\nSee https://developer.android.com/studio/publish/versioning#appversioning for more information.");
            return;
        }
        for (ProductFlavorData<ProductFlavor> flavorData : model2.getProductFlavors().values()) {
            Integer flavorVersionCode = flavorData.getProductFlavor().getVersionCode();
            if (flavorVersionCode == null || flavorVersionCode > 0) {
                return;
            }
            issueReporter.reportError(IssueReporter.Type.GENERIC, "versionCode is set to " + flavorVersionCode + " in product flavor " + flavorData.getProductFlavor().getName() + ", but it should be a positive integer.\nSee https://developer.android.com/studio/publish/versioning#appversioning for more information.");
        }
    }
}

