/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.AndroidTestPropertiesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.component.impl.UnitTestPropertiesImpl;
import com.android.build.api.dsl.BuildFeatures;
import com.android.build.api.dsl.TestBuildFeatures;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.api.variant.impl.TestVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.BuildFeatureValuesImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantApiServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.variant.AbstractAppVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class TestVariantFactory
extends AbstractAppVariantFactory<TestVariantImpl, TestVariantPropertiesImpl> {
    public TestVariantFactory(ProjectServices projectServices, GlobalScope globalScope) {
        super(projectServices, globalScope);
    }

    @Override
    public TestVariantImpl createVariantObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (TestVariantImpl)this.projectServices.getObjectFactory().newInstance(TestVariantImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public UnitTestImpl createUnitTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        throw new RuntimeException("cannot instantiate unit-test in test plugin");
    }

    @Override
    public AndroidTestImpl createAndroidTestObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        throw new RuntimeException("cannot instantiate android-test in test plugin");
    }

    @Override
    public TestVariantPropertiesImpl createVariantPropertiesObject(TestVariantImpl variant2, ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantScope variantScope, BaseVariantData variantData, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        TestVariantPropertiesImpl variantProperties = (TestVariantPropertiesImpl)this.projectServices.getObjectFactory().newInstance(TestVariantPropertiesImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, transformManager, variantPropertiesApiServices, taskCreationServices, this.globalScope});
        variantProperties.addVariantOutput(variantData.getOutputFactory().addMainApk());
        return variantProperties;
    }

    @Override
    public BuildFeatureValues createBuildFeatureValues(BuildFeatures buildFeatures, ProjectOptions projectOptions) {
        if (buildFeatures instanceof TestBuildFeatures) {
            return new BuildFeatureValuesImpl(buildFeatures, true, false, projectOptions);
        }
        throw new RuntimeException("buildFeatures not of type TestBuildFeatures");
    }

    @Override
    public BuildFeatureValues createTestBuildFeatureValues(BuildFeatures buildFeatures, DataBindingOptions dataBindingOptions, ProjectOptions projectOptions) {
        throw new RuntimeException("cannot instantiate test build features in test plugin");
    }

    @Override
    public UnitTestPropertiesImpl createUnitTestProperties(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantScope variantScope, TestVariantData variantData, VariantPropertiesImpl testedVariantProperties, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        throw new RuntimeException("cannot instantiate unit-test properties in test plugin");
    }

    @Override
    public AndroidTestPropertiesImpl createAndroidTestProperties(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, BuildArtifactsHolder artifacts2, VariantScope variantScope, TestVariantData variantData, VariantPropertiesImpl testedVariantProperties, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices) {
        throw new RuntimeException("cannot instantiate android-test properties in test plugin");
    }

    @Override
    public void preVariantWork(Project project2) {
        super.preVariantWork(project2);
        TestAndroidConfig testExtension = (TestAndroidConfig)((Object)this.globalScope.getExtension());
        String path = testExtension.getTargetProjectPath();
        if (path == null) {
            throw new GradleException("targetProjectPath cannot be null in test project " + project2.getName());
        }
        DependencyHandler handler = project2.getDependencies();
        ImmutableMap projectNotation = ImmutableMap.of((Object)"path", (Object)path);
        handler.add("compileOnly", (Object)handler.project((Map)projectNotation));
        Configuration testedApks = (Configuration)project2.getConfigurations().maybeCreate("testedApks");
        testedApks.setCanBeConsumed(false);
        testedApks.setCanBeResolved(false);
        handler.add("testedApks", (Object)handler.project((Map)projectNotation));
    }

    @Override
    public void createDefaultComponents(DslContainerProvider dslContainers) {
        dslContainers.getSigningConfigContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("debug");
    }

    public static String getTestedApksConfigurationName(String variantName) {
        return StringHelper.appendCapitalized((String)variantName, (String)"testedApks");
    }

    @Override
    public VariantType getVariantType() {
        return VariantTypeImpl.TEST_APK;
    }
}

