/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.VariantOutputConfigurationImplKt;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.manifest.ManifestHelperKt;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class ProcessLibraryManifest
extends ManifestProcessorTask {
    private final RegularFileProperty manifestOutputFile;
    private final Property<String> packageOverride;
    private final Property<Integer> versionCode;
    private final Property<String> versionName;
    private final ListProperty<File> manifestOverlays;
    private final MapProperty<String, Object> manifestPlaceholders;
    @VisibleForTesting
    final Property<VariantOutputImpl> mainSplit;
    private boolean isNamespaced;

    @Inject
    public ProcessLibraryManifest(ObjectFactory objectFactory) {
        super(objectFactory);
        this.manifestOutputFile = objectFactory.fileProperty();
        this.packageOverride = objectFactory.property(String.class);
        this.versionCode = objectFactory.property(Integer.class);
        this.versionName = objectFactory.property(String.class);
        this.manifestOverlays = objectFactory.listProperty(File.class);
        this.manifestPlaceholders = objectFactory.mapProperty(String.class, Object.class);
        this.mainSplit = objectFactory.property(VariantOutputImpl.class);
    }

    @OutputFile
    public RegularFileProperty getManifestOutputFile() {
        return this.manifestOutputFile;
    }

    @Override
    protected void doFullTaskAction() {
        try (WorkerExecutorFacade workers = this.getWorkerFacadeWithWorkers();){
            DirectoryProperty manifestOutputDirectory = this.getManifestOutputDirectory();
            DirectoryProperty aaptFriendlyManifestOutputDirectory = this.getAaptFriendlyManifestOutputDirectory();
            workers.submit(ProcessLibRunnable.class, (Serializable)new ProcessLibParams(this.getVariantName(), this.getAaptFriendlyManifestOutputFile(), this.isNamespaced, (File)this.getMainManifest().get(), (List)this.manifestOverlays.get(), (String)this.packageOverride.get(), (Integer)this.versionCode.get(), (String)this.versionName.getOrNull(), (String)this.getMinSdkVersion().getOrNull(), (String)this.getTargetSdkVersion().getOrNull(), (Integer)this.getMaxSdkVersion().getOrNull(), ((RegularFile)this.manifestOutputFile.get()).getAsFile(), (Map)this.manifestPlaceholders.get(), ((RegularFile)this.getReportFile().get()).getAsFile(), ((RegularFile)this.getMergeBlameFile().get()).getAsFile(), manifestOutputDirectory.isPresent() ? ((Directory)manifestOutputDirectory.get()).getAsFile() : null, aaptFriendlyManifestOutputDirectory.isPresent() ? ((Directory)aaptFriendlyManifestOutputDirectory.get()).getAsFile() : null, ((VariantOutputImpl)this.mainSplit.get()).toSerializedForm()));
        }
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        return this.getAaptFriendlyManifestOutputDirectory().isPresent() ? FileUtils.join((File)((Directory)this.getAaptFriendlyManifestOutputDirectory().get()).getAsFile(), (String[])new String[]{VariantOutputConfigurationImplKt.dirName((VariantOutputConfiguration)this.mainSplit.get()), "AndroidManifest.xml"}) : null;
    }

    @Input
    @Optional
    public abstract Property<String> getMinSdkVersion();

    @Input
    @Optional
    public abstract Property<String> getTargetSdkVersion();

    @Input
    @Optional
    public abstract Property<Integer> getMaxSdkVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract Property<File> getMainManifest();

    @Input
    @Optional
    public Property<String> getPackageOverride() {
        return this.packageOverride;
    }

    @Input
    public Property<Integer> getVersionCode() {
        return this.versionCode;
    }

    @Input
    @Optional
    public Property<String> getVersionName() {
        return this.versionName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ListProperty<File> getManifestOverlays() {
        return this.manifestOverlays;
    }

    @Input
    @Optional
    public MapProperty<String, Object> getManifestPlaceholders() {
        return this.manifestPlaceholders;
    }

    @Input
    public String getMainSplitFullName() {
        return ((VariantOutputImpl)this.mainSplit.get()).getFullName();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ProcessLibraryManifest, LibraryCreationConfig> {
        public CreationAction(LibraryCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessLibraryManifest> getType() {
            return ProcessLibraryManifest.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends ProcessLibraryManifest> taskProvider) {
            super.handleProvider(taskProvider);
            ((LibraryCreationConfig)this.creationConfig).getTaskContainer().setProcessManifestTask(taskProvider);
            BuildArtifactsHolder artifacts2 = ((LibraryCreationConfig)this.creationConfig).getArtifacts();
            artifacts2.producesDir(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS.INSTANCE, taskProvider, ManifestProcessorTask::getAaptFriendlyManifestOutputDirectory, "aapt");
            artifacts2.producesDir(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, taskProvider, ManifestProcessorTask::getManifestOutputDirectory, "");
            artifacts2.producesFile(InternalArtifactType.LIBRARY_MANIFEST.INSTANCE, taskProvider, ProcessLibraryManifest::getManifestOutputFile, "AndroidManifest.xml");
            artifacts2.producesFile(InternalArtifactType.MANIFEST_MERGE_BLAME_FILE.INSTANCE, taskProvider, ManifestProcessorTask::getMergeBlameFile, "manifest-merger-blame-" + ((LibraryCreationConfig)this.creationConfig).getBaseName() + "-report.txt");
            artifacts2.producesFile(InternalArtifactType.MANIFEST_MERGE_REPORT.INSTANCE, taskProvider, ManifestProcessorTask::getReportFile, FileUtils.join((File)((LibraryCreationConfig)this.creationConfig).getGlobalScope().getOutputsDir(), (String[])new String[]{"logs"}).getAbsolutePath(), "manifest-merger-" + ((LibraryCreationConfig)this.creationConfig).getBaseName() + "-report.txt");
        }

        @Override
        public void configure(ProcessLibraryManifest task) {
            super.configure(task);
            VariantDslInfo variantDslInfo = ((LibraryCreationConfig)this.creationConfig).getVariantDslInfo();
            VariantSources variantSources = ((LibraryCreationConfig)this.creationConfig).getVariantSources();
            Project project2 = ((LibraryCreationConfig)this.creationConfig).getGlobalScope().getProject();
            task.getMinSdkVersion().set(project2.provider(() -> ((LibraryCreationConfig)this.creationConfig).getMinSdkVersion().getApiString()));
            task.getMinSdkVersion().disallowChanges();
            task.getTargetSdkVersion().set(project2.provider(() -> {
                ApiVersion targetSdkVersion = ((LibraryCreationConfig)this.creationConfig).getTargetSdkVersion();
                if (targetSdkVersion.getApiLevel() < 0) {
                    return null;
                }
                return targetSdkVersion.getApiString();
            }));
            task.getTargetSdkVersion().disallowChanges();
            task.getMaxSdkVersion().set(project2.provider(((LibraryCreationConfig)this.creationConfig)::getMaxSdkVersion));
            task.getMaxSdkVersion().disallowChanges();
            task.mainSplit.set(project2.provider(() -> ((LibraryCreationConfig)this.creationConfig).getOutputs().getMainSplit()));
            task.mainSplit.disallowChanges();
            task.isNamespaced = ((LibraryCreationConfig)this.creationConfig).getGlobalScope().getExtension().getAaptOptions().getNamespaced();
            task.versionName.set(task.getProject().provider(variantDslInfo::getVersionName));
            task.versionName.disallowChanges();
            task.versionCode.set(task.getProject().provider(variantDslInfo::getVersionCode));
            task.versionCode.disallowChanges();
            task.packageOverride.set(((LibraryCreationConfig)this.creationConfig).getApplicationId());
            task.packageOverride.disallowChanges();
            task.manifestPlaceholders.set(task.getProject().provider(variantDslInfo::getManifestPlaceholders));
            task.manifestPlaceholders.disallowChanges();
            task.getMainManifest().set(project2.provider(variantSources::getMainManifestFilePath));
            task.getMainManifest().disallowChanges();
            task.manifestOverlays.set(task.getProject().provider(variantSources::getManifestOverlays));
            task.manifestOverlays.disallowChanges();
        }
    }

    public static class ProcessLibRunnable
    implements Runnable {
        private final ProcessLibParams params;

        @Inject
        public ProcessLibRunnable(ProcessLibParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            ImmutableMap properties;
            List<Object> optionalFeatures = this.params.isNamespaced ? Collections.singletonList(ManifestMerger2.Invoker.Feature.FULLY_NAMESPACE_LOCAL_RESOURCES) : Collections.emptyList();
            MergingReport mergingReport = ManifestHelperKt.mergeManifestsForApplication(this.params.mainManifest, this.params.manifestOverlays, Collections.emptyList(), Collections.emptyList(), null, this.params.packageOverride, this.params.versionCode, this.params.versionName, this.params.minSdkVersion, this.params.targetSdkVersion, this.params.maxSdkVersion, this.params.manifestOutputFile.getAbsolutePath(), this.params.aaptFriendlyManifestOutputFile != null ? this.params.aaptFriendlyManifestOutputFile.getAbsolutePath() : null, null, null, null, ManifestMerger2.MergeType.LIBRARY, this.params.manifestPlaceholders, optionalFeatures, Collections.emptyList(), this.params.reportFile, LoggerWrapper.getLogger(ProcessLibraryManifest.class));
            XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            try {
                ManifestProcessorTask.outputMergeBlameContents(mergingReport, this.params.mergeBlameFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ImmutableMap immutableMap = properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName()) : ImmutableMap.of();
            if (this.params.manifestOutputDirectory != null) {
                new BuiltArtifactsImpl(2, InternalArtifactType.MERGED_MANIFESTS.INSTANCE, this.params.packageOverride, this.params.variantName, (Collection<BuiltArtifactImpl>)ImmutableList.of((Object)this.params.mainSplit.toBuiltArtifact(this.params.manifestOutputFile, (Map<String, String>)properties))).saveToDirectory(this.params.manifestOutputDirectory);
            }
            if (this.params.aaptFriendlyManifestOutputDirectory != null) {
                new BuiltArtifactsImpl(2, InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS.INSTANCE, this.params.packageOverride, this.params.variantName, (Collection<BuiltArtifactImpl>)ImmutableList.of((Object)this.params.mainSplit.toBuiltArtifact(this.params.aaptFriendlyManifestOutputFile, (Map<String, String>)properties))).saveToDirectory(this.params.aaptFriendlyManifestOutputDirectory);
            }
        }
    }

    private static class ProcessLibParams
    implements Serializable {
        private final String variantName;
        private final File aaptFriendlyManifestOutputFile;
        private final boolean isNamespaced;
        private final File mainManifest;
        private final List<File> manifestOverlays;
        private final String packageOverride;
        private final int versionCode;
        private final String versionName;
        private final String minSdkVersion;
        private final String targetSdkVersion;
        private final Integer maxSdkVersion;
        private final File manifestOutputFile;
        private final Map<String, Object> manifestPlaceholders;
        private final File reportFile;
        private final File mergeBlameFile;
        private final File manifestOutputDirectory;
        private final File aaptFriendlyManifestOutputDirectory;
        private final VariantOutputImpl.SerializedForm mainSplit;

        private ProcessLibParams(String variantName, File aaptFriendlyManifestOutputFile, boolean isNamespaced, File mainManifest, List<File> manifestOverlays2, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion, File manifestOutputFile, Map<String, Object> manifestPlaceholders, File reportFile, File mergeBlameFile, File manifestOutputDirectory, File aaptFriendlyManifestOutputDirectory, VariantOutputImpl.SerializedForm mainSplit) {
            this.variantName = variantName;
            this.aaptFriendlyManifestOutputFile = aaptFriendlyManifestOutputFile;
            this.isNamespaced = isNamespaced;
            this.mainManifest = mainManifest;
            this.manifestOverlays = manifestOverlays2;
            this.packageOverride = packageOverride;
            this.versionCode = versionCode;
            this.versionName = versionName;
            this.minSdkVersion = minSdkVersion;
            this.targetSdkVersion = targetSdkVersion;
            this.maxSdkVersion = maxSdkVersion;
            this.manifestOutputFile = manifestOutputFile;
            this.manifestPlaceholders = manifestPlaceholders;
            this.reportFile = reportFile;
            this.mergeBlameFile = mergeBlameFile;
            this.manifestOutputDirectory = manifestOutputDirectory;
            this.aaptFriendlyManifestOutputDirectory = aaptFriendlyManifestOutputDirectory;
            this.mainSplit = mainSplit;
        }
    }
}

