/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import tflite.Metadata;
import tflite.Model;
import tflite.QuantizationParameters;
import tflite.SubGraph;
import tflite.Tensor;

public class MetadataExtractor {
    private final Model bufferModel;

    public MetadataExtractor(ByteBuffer buffer) {
        this.bufferModel = Model.getRootAsModel((ByteBuffer)buffer);
    }

    public int getSubgraphCount() {
        return this.bufferModel.subgraphsLength();
    }

    public int getInputTensorCount(int subgraphIndex) {
        SubGraph subgraph = this.getSubGraph(subgraphIndex);
        return subgraph.inputsLength();
    }

    public int getOutputTensorCount(int subgraphIndex) {
        SubGraph subgraph = this.getSubGraph(subgraphIndex);
        return subgraph.outputsLength();
    }

    public int[] getInputTensorShape(int subgraphIndex, int inputIndex) {
        Tensor tensor = this.getInputTensor(subgraphIndex, inputIndex);
        return MetadataExtractor.getShape(tensor);
    }

    public byte getInputTensorType(int subgraphIndex, int inputIndex) {
        Tensor tensor = this.getInputTensor(subgraphIndex, inputIndex);
        return tensor.type();
    }

    public int[] getOutputTensorShape(int subgraphIndex, int outputIndex) {
        Tensor tensor = this.getOutputTensor(subgraphIndex, outputIndex);
        return MetadataExtractor.getShape(tensor);
    }

    public byte getOutputTensorType(int subgraphIndex, int outputIndex) {
        Tensor tensor = this.getOutputTensor(subgraphIndex, outputIndex);
        return tensor.type();
    }

    private SubGraph getSubGraph(int subgraphIndex) {
        return this.bufferModel.subgraphs(subgraphIndex);
    }

    public Tensor getInputTensor(int subgraphIndex, int inputIndex) {
        return this.getTensor(subgraphIndex, inputIndex, true);
    }

    public Tensor getOutputTensor(int subgraphIndex, int outputIndex) {
        return this.getTensor(subgraphIndex, outputIndex, false);
    }

    private Tensor getTensor(int subgraphIndex, int tensorIndex, boolean isInput) {
        SubGraph subgraph = this.getSubGraph(subgraphIndex);
        if (isInput) {
            return subgraph.tensors(subgraph.inputs(tensorIndex));
        }
        return subgraph.tensors(subgraph.outputs(tensorIndex));
    }

    private static int[] getShape(Tensor tensor) {
        int shapeDim = tensor.shapeLength();
        int[] tensorShape = new int[shapeDim];
        for (int i2 = 0; i2 < shapeDim; ++i2) {
            tensorShape[i2] = tensor.shape(i2);
        }
        return tensorShape;
    }

    public ModelMetadata getModelMetaData() {
        int length = this.bufferModel.metadataLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Metadata metadata = this.bufferModel.metadata(i2);
            if (!"TFLITE_METADATA".equals(metadata.name())) continue;
            long bufferIndex = metadata.buffer();
            return ModelMetadata.getRootAsModelMetadata((ByteBuffer)this.bufferModel.buffers((int)bufferIndex).dataAsByteBuffer());
        }
        return null;
    }

    public String getOutputLabelFileName() {
        ModelMetadata modelMetadata = this.getModelMetaData();
        return modelMetadata.subgraphMetadata(0).outputTensorMetadata(0).associatedFiles(0).name();
    }

    public QuantizationParams getQuantizationParams(Tensor tensor) {
        long zeroPoint;
        float scale;
        byte tensorType = tensor.type();
        if (tensorType == 2 || tensorType == 4 || tensorType == 3) {
            QuantizationParameters quantization = tensor.quantization();
            scale = quantization.scale(0) == 0.0f ? 1.0f : quantization.scale(0);
            zeroPoint = quantization.zeroPoint(0);
        } else {
            scale = 1.0f;
            zeroPoint = 0L;
        }
        return new QuantizationParams(scale, zeroPoint);
    }

    public static class NormalizationParams {
        private final float[] mean;
        private final float[] std;

        public NormalizationParams(FloatBuffer meanBuffer, FloatBuffer stdBuffer) {
            this.mean = new float[meanBuffer.limit()];
            meanBuffer.get(this.mean);
            this.std = new float[stdBuffer.limit()];
            stdBuffer.get(this.std);
        }

        public float[] getMean() {
            return this.mean;
        }

        public float[] getStd() {
            return this.std;
        }
    }

    public static class QuantizationParams {
        private final float scale;
        private final long zeroPoint;

        public QuantizationParams(float scale, long zeroPoint) {
            this.scale = scale;
            this.zeroPoint = zeroPoint;
        }

        public float getScale() {
            return this.scale;
        }

        public long getZeroPoint() {
            return this.zeroPoint;
        }
    }
}

