/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.MetadataExtractor;
import com.android.tools.mlkit.ModelParsingException;
import com.android.tools.mlkit.TensorInfo;
import java.util.HashSet;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.TensorMetadata;

public class ModelVerifier {
    public static void verifyModel(MetadataExtractor extractor) throws ModelParsingException {
        if (extractor.getSubgraphCount() != 1) {
            throw new ModelParsingException(ModelParsingException.ErrorType.UNSUPPORTED_SUBGRAPH, "Only support for model with 1 subgraph");
        }
        ModelMetadata metadata = extractor.getModelMetaData();
        if (metadata == null) {
            throw new ModelParsingException(ModelParsingException.ErrorType.INVALID_METADATA, "Model doesn't have valid metadata");
        }
        int inputCount = extractor.getInputTensorCount(0);
        HashSet<String> inputNameSet = new HashSet<String>();
        for (int i2 = 0; i2 < inputCount; ++i2) {
            ModelVerifier.verifyDataType(extractor.getInputTensorType(0, i2), i2, TensorInfo.Source.INPUT);
            TensorMetadata tensorMetadata = metadata.subgraphMetadata(0).inputTensorMetadata(i2);
            ModelVerifier.verifyTensorMetadata(tensorMetadata, i2, TensorInfo.Source.INPUT);
            if (inputNameSet.contains(tensorMetadata.name())) {
                throw new ModelParsingException(ModelParsingException.ErrorType.PARAM_NAME_CONFLICT, "More than one tensor has same name: " + tensorMetadata.name());
            }
            inputNameSet.add(tensorMetadata.name());
            if (TensorInfo.ContentType.fromByte(tensorMetadata.contentType()) != TensorInfo.ContentType.IMAGE || extractor.getInputTensorShape(0, i2).length == 4) continue;
            throw new ModelParsingException(ModelParsingException.ErrorType.INVALID_IMAGE_TENSOR, "Image tensor doesn't have valid tensor shape");
        }
        HashSet<String> outputNameSet = new HashSet<String>();
        int outputCount = extractor.getOutputTensorCount(0);
        for (int i3 = 0; i3 < outputCount; ++i3) {
            ModelVerifier.verifyDataType(extractor.getOutputTensorType(0, i3), i3, TensorInfo.Source.OUTPUT);
            TensorMetadata tensorMetadata = metadata.subgraphMetadata(0).outputTensorMetadata(i3);
            ModelVerifier.verifyTensorMetadata(tensorMetadata, i3, TensorInfo.Source.OUTPUT);
            if (outputNameSet.contains(tensorMetadata.name())) {
                throw new ModelParsingException(ModelParsingException.ErrorType.PARAM_NAME_CONFLICT, "More than one tensor has same name: " + tensorMetadata.name());
            }
            outputNameSet.add(tensorMetadata.name());
        }
    }

    private static void verifyTensorMetadata(TensorMetadata tensorMetadata, int index, TensorInfo.Source source) throws ModelParsingException {
        if (tensorMetadata.name() == null) {
            throw new ModelParsingException(ModelParsingException.ErrorType.INVALID_PARAM_NAME, String.format("%s tensor %d doesn't have valid name", source == TensorInfo.Source.INPUT ? "Input" : "Output", index));
        }
    }

    private static void verifyDataType(byte dataType, int index, TensorInfo.Source source) throws ModelParsingException {
        if (TensorInfo.DataType.fromByte(dataType) == null) {
            throw new ModelParsingException(ModelParsingException.ErrorType.UNSUPPORTED_DATA_TYPE, String.format("Datatype of %s tensor %d is not supported", source == TensorInfo.Source.INPUT ? "input" : "output", index));
        }
    }
}

