/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"processResources", "", "aapt", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "aaptConfig", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "rJar", "Ljava/io/File;", "logger", "Lcom/android/utils/ILogger;", "gradle"})
public final class Aapt2ProcessResourcesRunnableKt {
    /*
     * WARNING - void declaration
     */
    public static final void processResources(@NotNull Aapt2 aapt, @NotNull AaptPackageConfig aaptConfig, @Nullable File rJar, @NotNull ILogger logger) throws IOException, ProcessException {
        Intrinsics.checkParameterIsNotNull((Object)aapt, (String)"aapt");
        Intrinsics.checkParameterIsNotNull((Object)aaptConfig, (String)"aaptConfig");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            aapt.link(aaptConfig, logger);
        }
        catch (Aapt2Exception e) {
            throw (Throwable)e;
        }
        catch (Aapt2InternalException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new ProcessException("Failed to execute aapt", (Throwable)e);
        }
        File sourceOut = aaptConfig.getSourceOutputDir();
        if (sourceOut != null || rJar != null) {
            File mainRTxt;
            String mainPackageName = aaptConfig.getCustomPackageForR();
            if (mainPackageName == null) {
                mainPackageName = SymbolUtils.getPackageNameFromManifest((File)aaptConfig.getManifestFile());
            }
            SymbolTable mainSymbols = (mainRTxt = new File(aaptConfig.getSymbolOutputDir(), "R.txt")).isFile() ? SymbolIo.readFromAapt((File)mainRTxt, (String)mainPackageName) : SymbolTable.Companion.builder().tablePackage(mainPackageName).build();
            ImmutableList immutableList = new SymbolIo().loadDependenciesSymbolTables((Iterable)aaptConfig.getLibrarySymbolTableFiles());
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"SymbolIo().loadDependenc\u2026ymbolTableFiles\n        )");
            List depSymbolTables = (List)immutableList;
            boolean finalIds = aaptConfig.getUseFinalIds();
            if (rJar != null) {
                void $this$mapTo$iv$iv;
                boolean nonTransitiveRClass;
                File localSymbolsFile = aaptConfig.getLocalSymbolTableFile();
                boolean bl = nonTransitiveRClass = localSymbolsFile != null;
                if (nonTransitiveRClass) {
                    File file = localSymbolsFile;
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    SymbolTable localSymbols = SymbolIo.readRDef((Path)file.toPath()).rename(mainSymbols.getTablePackage());
                    depSymbolTables = CollectionsKt.plus((Collection)depSymbolTables, (Object)localSymbols);
                }
                Iterable $this$map$iv = depSymbolTables;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void t;
                    SymbolTable symbolTable = (SymbolTable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    SymbolTable symbolTable2 = mainSymbols;
                    Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable2, (String)"mainSymbols");
                    SymbolTable symbolTable3 = t.withValuesFrom(symbolTable2);
                    collection.add(symbolTable3);
                }
                depSymbolTables = (List)destination$iv$iv;
                if (!nonTransitiveRClass) {
                    depSymbolTables = CollectionsKt.plus((Collection)depSymbolTables, (Object)mainSymbols);
                }
                Iterable iterable2 = depSymbolTables;
                Path path = rJar.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"rJar.toPath()");
                BytecodeRClassWriterKt.exportToCompiledJava((Iterable)iterable2, (Path)path, (boolean)finalIds);
            } else {
                Collection collection = depSymbolTables;
                File file = sourceOut;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                RGeneration.generateRForLibraries((SymbolTable)mainSymbols, (Collection)collection, (File)file, (boolean)finalIds);
            }
        }
    }
}

