/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.OptionalCompilationStep;
import com.android.ide.common.blame.MessageReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.OptionalLibrary;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope {
    private final Project project;
    private final DataBindingBuilder dataBindingBuilder;
    private BaseExtension extension;
    private final Provider<SdkComponentsBuildService> sdkComponents;
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final Set<OptionalCompilationStep> optionalCompilationSteps;
    private final MessageReceiver messageReceiver;
    private final SoftwareComponentFactory componentFactory;
    private final String createdBy;
    private final DslServices dslServices;
    private Configuration lintChecks;
    private Configuration lintPublish;
    private Configuration androidJarConfig;
    private final ArtifactsImpl globalArtifacts;
    private Provider<List<RegularFile>> bootClasspath = null;

    public GlobalScope(Project project2, String createdBy, DslServices dslServices, Provider<SdkComponentsBuildService> sdkComponents, ToolingModelBuilderRegistry toolingRegistry, MessageReceiver messageReceiver, SoftwareComponentFactory componentFactory) {
        this.project = (Project)Preconditions.checkNotNull((Object)project2);
        this.createdBy = createdBy;
        this.dslServices = (DslServices)Preconditions.checkNotNull((Object)dslServices);
        this.sdkComponents = sdkComponents;
        this.toolingRegistry = (ToolingModelBuilderRegistry)Preconditions.checkNotNull((Object)toolingRegistry);
        this.optionalCompilationSteps = (Set)Preconditions.checkNotNull(dslServices.getProjectOptions().getOptionalCompilationSteps());
        this.messageReceiver = messageReceiver;
        this.componentFactory = componentFactory;
        this.globalArtifacts = new ArtifactsImpl(project2, "global");
        this.lintChecks = project2.getConfigurations().detachedConfiguration(new Dependency[0]);
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(SyncOptions.getErrorFormatMode(dslServices.getProjectOptions()) == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE);
    }

    public void setExtension(BaseExtension extension) {
        this.extension = (BaseExtension)Preconditions.checkNotNull((Object)extension);
    }

    public Project getProject() {
        return this.project;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public String getProjectBaseName() {
        BasePluginConvention convention = (BasePluginConvention)Preconditions.checkNotNull((Object)this.project.getConvention().findPlugin(BasePluginConvention.class));
        return convention.getArchivesBaseName();
    }

    public Provider<SdkComponentsBuildService> getSdkComponents() {
        return this.sdkComponents;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    public File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    public File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    public File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    public File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    public File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    public File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    public File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    public File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    public ProjectOptions getProjectOptions() {
        return this.dslServices.getProjectOptions();
    }

    public void setLintChecks(Configuration lintChecks) {
        this.lintChecks = lintChecks;
    }

    public void setLintPublish(Configuration lintPublish) {
        this.lintPublish = lintPublish;
    }

    public void setAndroidJarConfig(Configuration androidJarConfig) {
        this.androidJarConfig = androidJarConfig;
    }

    public FileCollection getMockableJarArtifact() {
        return this.getMockableJarArtifact(this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues());
    }

    public FileCollection getMockableJarArtifact(boolean returnDefaultValues) {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-mockable-jar").attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)returnDefaultValues);
        return this.androidJarConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPlatformAttrs() {
        Preconditions.checkNotNull((Object)this.androidJarConfig);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)"android-platform-attr");
        return this.androidJarConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    @Deprecated
    public DslServices getDslServices() {
        return this.dslServices;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public FileCollection getLocalCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintChecks.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public FileCollection getPublishedCustomLintChecks() {
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
        return this.lintPublish.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(attributes2);
        }).getArtifacts().getArtifactFiles();
    }

    public ArtifactsImpl getGlobalArtifacts() {
        return this.globalArtifacts;
    }

    public boolean hasDynamicFeatures() {
        BaseExtension extension = this.getExtension();
        if (extension instanceof BaseAppModuleExtension) {
            return !((BaseAppModuleExtension)extension).getDynamicFeatures().isEmpty();
        }
        return false;
    }

    public Provider<List<RegularFile>> getBootClasspath() {
        if (this.bootClasspath == null) {
            this.bootClasspath = this.project.provider(() -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)this.getFilteredBootClasspath().get());
                if (this.extension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                    builder.add(((SdkComponentsBuildService)this.getSdkComponents().get()).getCoreLambdaStubsProvider().get());
                }
                return builder.build();
            });
        }
        return this.bootClasspath;
    }

    public Provider<List<RegularFile>> getFilteredBootClasspath() {
        return BootClasspathBuilder.INSTANCE.computeClasspath(this.project, this.getDslServices().getIssueReporter(), (Provider<List<File>>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getTargetBootClasspathProvider), (Provider<AndroidVersion>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getTargetAndroidVersionProvider), (Provider<List<OptionalLibrary>>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getAdditionalLibrariesProvider), (Provider<List<OptionalLibrary>>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getOptionalLibrariesProvider), (Provider<File>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getAnnotationsJarProvider), false, (List<LibraryRequest>)ImmutableList.copyOf(this.getExtension().getLibraryRequests()));
    }

    public FileCollection getFullBootClasspath() {
        return this.project.files(new Object[]{BootClasspathBuilder.INSTANCE.computeClasspath(this.project, this.getDslServices().getIssueReporter(), (Provider<List<File>>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getTargetBootClasspathProvider), (Provider<AndroidVersion>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getTargetAndroidVersionProvider), (Provider<List<OptionalLibrary>>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getAdditionalLibrariesProvider), (Provider<List<OptionalLibrary>>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getOptionalLibrariesProvider), (Provider<File>)this.getSdkComponents().flatMap(SdkComponentsBuildService::getAnnotationsJarProvider), true, (List<LibraryRequest>)ImmutableList.of()).get()});
    }

    public SoftwareComponentFactory getComponentFactory() {
        return this.componentFactory;
    }
}

