/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.dsl.DefaultConfig;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.VariantBuilder;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\t2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\n:\u0001'B\u0015\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00028\u0003H\u0004\u00a2\u0006\u0002\u0010&R&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00130\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00170\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00028\u00030\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/variant/AbstractVariantInputManager;", "DefaultConfigT", "Lcom/android/build/api/dsl/DefaultConfig;", "BuildTypeT", "Lcom/android/build/api/dsl/BuildType;", "ProductFlavorT", "Lcom/android/build/api/dsl/ProductFlavor;", "SigningConfigT", "Lcom/android/build/api/dsl/SigningConfig;", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "Lcom/android/build/gradle/internal/plugins/DslContainerProvider;", "variantType", "Lcom/android/builder/core/VariantType;", "sourceSetManager", "Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "(Lcom/android/builder/core/VariantType;Lcom/android/build/gradle/internal/dependency/SourceSetManager;)V", "buildTypes", "", "", "Lcom/android/build/gradle/internal/BuildTypeData;", "getBuildTypes", "()Ljava/util/Map;", "productFlavors", "Lcom/android/build/gradle/internal/ProductFlavorData;", "getProductFlavors", "signingConfigs", "getSigningConfigs", "getSourceSetManager", "()Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "addBuildType", "", "buildType", "(Lcom/android/build/api/dsl/BuildType;)V", "addProductFlavor", "productFlavor", "(Lcom/android/build/api/dsl/ProductFlavor;)V", "addSigningConfig", "signingConfig", "(Lcom/android/build/api/dsl/SigningConfig;)V", "Companion", "gradle"})
public abstract class AbstractVariantInputManager<DefaultConfigT extends DefaultConfig, BuildTypeT extends com.android.build.api.dsl.BuildType, ProductFlavorT extends ProductFlavor, SigningConfigT extends SigningConfig>
implements VariantInputModel<DefaultConfigT, BuildTypeT, ProductFlavorT, SigningConfigT>,
DslContainerProvider<DefaultConfigT, BuildTypeT, ProductFlavorT, SigningConfigT> {
    @NotNull
    private final Map<String, BuildTypeData<BuildTypeT>> buildTypes;
    @NotNull
    private final Map<String, ProductFlavorData<ProductFlavorT>> productFlavors;
    @NotNull
    private final Map<String, SigningConfigT> signingConfigs;
    private final VariantType variantType;
    @NotNull
    private final SourceSetManager sourceSetManager;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Map<String, BuildTypeData<BuildTypeT>> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    @NotNull
    public Map<String, ProductFlavorData<ProductFlavorT>> getProductFlavors() {
        return this.productFlavors;
    }

    @Override
    @NotNull
    public Map<String, SigningConfigT> getSigningConfigs() {
        return this.signingConfigs;
    }

    protected final void addSigningConfig(@NotNull SigningConfigT signingConfig) {
        Intrinsics.checkParameterIsNotNull(signingConfig, (String)"signingConfig");
        Map<String, SigningConfigT> map = this.getSigningConfigs();
        String string = signingConfig.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"signingConfig.name");
        map.put(string, signingConfig);
    }

    protected final void addBuildType(@NotNull BuildTypeT buildType) {
        DefaultAndroidSourceSet defaultAndroidSourceSet;
        DefaultAndroidSourceSet androidTestSourceSet;
        DefaultAndroidSourceSet defaultAndroidSourceSet2;
        String name2;
        Intrinsics.checkParameterIsNotNull(buildType, (String)"buildType");
        String string = name2 = buildType.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        AbstractVariantInputManager.Companion.checkName(string, "BuildType");
        if (this.getProductFlavors().containsKey(name2)) {
            throw (Throwable)new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        if (buildType instanceof BuildType) {
            if (this.variantType.isDynamicFeature()) {
                ((BuildType)buildType).init();
            } else {
                Object object = this.getSigningConfigContainer().findByName("debug");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.SigningConfig");
                }
                ((BuildType)buildType).init((com.android.build.gradle.internal.dsl.SigningConfig)object);
            }
        } else {
            throw (Throwable)new RuntimeException("Unexpected instance of BuildTypeT");
        }
        if (this.variantType.getHasTestComponents()) {
            AndroidSourceSet androidSourceSet = this.getSourceSetManager().setUpTestSourceSet(VariantBuilder.Companion.computeSourceSetName(((BuildType)buildType).getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            if (androidSourceSet == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceSet");
            }
            defaultAndroidSourceSet2 = (DefaultAndroidSourceSet)androidSourceSet;
        } else {
            defaultAndroidSourceSet2 = androidTestSourceSet = null;
        }
        if (this.variantType.getHasTestComponents()) {
            AndroidSourceSet androidSourceSet = this.getSourceSetManager().setUpTestSourceSet(VariantBuilder.Companion.computeSourceSetName(((BuildType)buildType).getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
            if (androidSourceSet == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceSet");
            }
            defaultAndroidSourceSet = (DefaultAndroidSourceSet)androidSourceSet;
        } else {
            defaultAndroidSourceSet = null;
        }
        DefaultAndroidSourceSet unitTestSourceSet = defaultAndroidSourceSet;
        AndroidSourceSet androidSourceSet = SourceSetManager.setUpSourceSet$default(this.getSourceSetManager(), ((BuildType)buildType).getName(), false, 2, null);
        if (androidSourceSet == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceSet");
        }
        this.getBuildTypes().put(name2, new BuildTypeData<BuildTypeT>(buildType, (DefaultAndroidSourceSet)androidSourceSet, androidTestSourceSet, unitTestSourceSet));
    }

    protected final void addProductFlavor(@NotNull ProductFlavorT productFlavor) {
        Intrinsics.checkParameterIsNotNull(productFlavor, (String)"productFlavor");
        String name2 = productFlavor.getName();
        AbstractVariantInputManager.Companion.checkName(name2, "ProductFlavor");
        if (this.getBuildTypes().containsKey(name2)) {
            throw (Throwable)new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        AndroidSourceSet androidSourceSet = SourceSetManager.setUpSourceSet$default(this.getSourceSetManager(), productFlavor.getName(), false, 2, null);
        if (androidSourceSet == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceSet");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)androidSourceSet;
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantType.getHasTestComponents()) {
            AndroidSourceSet androidSourceSet2 = this.getSourceSetManager().setUpTestSourceSet(VariantBuilder.Companion.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            if (androidSourceSet2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceSet");
            }
            androidTestSourceSet = (DefaultAndroidSourceSet)androidSourceSet2;
            AndroidSourceSet androidSourceSet3 = this.getSourceSetManager().setUpTestSourceSet(VariantBuilder.Companion.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
            if (androidSourceSet3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceSet");
            }
            unitTestSourceSet = (DefaultAndroidSourceSet)androidSourceSet3;
        }
        ProductFlavorData<ProductFlavorT> productFlavorData = new ProductFlavorData<ProductFlavorT>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.getProductFlavors().put(productFlavor.getName(), productFlavorData);
    }

    @Override
    @NotNull
    public SourceSetManager getSourceSetManager() {
        return this.sourceSetManager;
    }

    public AbstractVariantInputManager(@NotNull VariantType variantType, @NotNull SourceSetManager sourceSetManager) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)variantType, (String)"variantType");
        Intrinsics.checkParameterIsNotNull((Object)sourceSetManager, (String)"sourceSetManager");
        this.variantType = variantType;
        this.sourceSetManager = sourceSetManager;
        AbstractVariantInputManager abstractVariantInputManager = this;
        boolean bl = false;
        abstractVariantInputManager.buildTypes = map = (Map)new LinkedHashMap();
        abstractVariantInputManager = this;
        bl = false;
        abstractVariantInputManager.productFlavors = map = (Map)new LinkedHashMap();
        abstractVariantInputManager = this;
        bl = false;
        abstractVariantInputManager.signingConfigs = map = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractVariantInputManager$Companion;", "", "()V", "checkName", "", "name", "", "displayName", "checkPrefix", "prefix", "gradle"})
    public static final class Companion {
        private final void checkName(String name2, String displayName) {
            this.checkPrefix(name2, displayName, "androidTest");
            this.checkPrefix(name2, displayName, "test");
            if (Intrinsics.areEqual((Object)"lint", (Object)name2)) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%1$s names cannot be %2$s";
                Object[] objectArray = new Object[]{displayName, "lint"};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string = string3;
                throw (Throwable)new RuntimeException(string4);
            }
        }

        private final void checkPrefix(String name2, String displayName, String prefix) {
            if (StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%1$s names cannot start with '%2$s'";
                Object[] objectArray = new Object[]{displayName, prefix};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string = string3;
                throw (Throwable)new RuntimeException(string4);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

