/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use LazyManifestProvider instead")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/android/builder/core/VariantAttributesProvider;", "", "mergedFlavor", "Lcom/android/builder/model/ProductFlavor;", "buildType", "Lcom/android/builder/model/BuildType;", "isTestVariant", "", "manifestSupplier", "Lcom/android/builder/core/ManifestAttributeSupplier;", "manifestFile", "Ljava/io/File;", "fullName", "", "(Lcom/android/builder/model/ProductFlavor;Lcom/android/builder/model/BuildType;ZLcom/android/builder/core/ManifestAttributeSupplier;Ljava/io/File;Ljava/lang/String;)V", "idOverride", "getIdOverride", "()Ljava/lang/String;", "packageName", "getPackageName", "split", "getSplit", "getApplicationId", "testedPackage", "getOriginalApplicationId", "getTestApplicationId", "gradle"})
public final class VariantAttributesProvider {
    private final ProductFlavor mergedFlavor;
    private final BuildType buildType;
    private final boolean isTestVariant;
    private final ManifestAttributeSupplier manifestSupplier;
    private final File manifestFile;
    private final String fullName;

    @Nullable
    public final String getIdOverride() {
        String idName = this.mergedFlavor.getApplicationId();
        String idSuffix = AbstractProductFlavor.Companion.mergeApplicationIdSuffix(this.buildType.getApplicationIdSuffix(), this.mergedFlavor.getApplicationIdSuffix());
        CharSequence charSequence = idSuffix;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            String string = idName;
            if (string == null) {
                string = this.getPackageName();
            }
            idName = string;
            idName = idSuffix.charAt(0) == '.' ? idName + idSuffix : idName + '.' + idSuffix;
        }
        return idName;
    }

    @NotNull
    public final String getPackageName() {
        Preconditions.checkState((!this.isTestVariant ? 1 : 0) != 0);
        String string = this.manifestSupplier.getPackage();
        if (string == null) {
            throw (Throwable)new RuntimeException("Cannot read packageName from " + this.manifestFile.getAbsolutePath());
        }
        return string;
    }

    @Nullable
    public final String getSplit() {
        return this.manifestSupplier.getSplit();
    }

    @NotNull
    public final String getApplicationId(@NotNull String testedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        String id = null;
        if (this.isTestVariant) {
            id = this.mergedFlavor.getTestApplicationId();
            if (id == null) {
                id = testedPackage + ".test";
            } else if (Intrinsics.areEqual((Object)id, (Object)testedPackage)) {
                throw (Throwable)new RuntimeException("Application and test application id cannot be the same: both are " + id + " for " + this.fullName);
            }
        } else {
            String string = this.getIdOverride();
            if (string == null) {
                string = this.getPackageName();
            }
            id = string;
        }
        return id;
    }

    @NotNull
    public final String getOriginalApplicationId(@NotNull String testedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        return this.isTestVariant ? this.getApplicationId(testedPackage) : this.getPackageName();
    }

    @NotNull
    public final String getTestApplicationId(@NotNull String testedPackage) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        Preconditions.checkState((boolean)this.isTestVariant);
        if (!Strings.isNullOrEmpty((String)this.mergedFlavor.getTestApplicationId())) {
            string = this.mergedFlavor.getTestApplicationId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            string = this.getApplicationId(testedPackage);
        }
        return string;
    }

    public VariantAttributesProvider(@NotNull ProductFlavor mergedFlavor, @NotNull BuildType buildType, boolean isTestVariant, @NotNull ManifestAttributeSupplier manifestSupplier, @NotNull File manifestFile, @NotNull String fullName) {
        Intrinsics.checkParameterIsNotNull((Object)mergedFlavor, (String)"mergedFlavor");
        Intrinsics.checkParameterIsNotNull((Object)buildType, (String)"buildType");
        Intrinsics.checkParameterIsNotNull((Object)manifestSupplier, (String)"manifestSupplier");
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
        this.mergedFlavor = mergedFlavor;
        this.buildType = buildType;
        this.isTestVariant = isTestVariant;
        this.manifestSupplier = manifestSupplier;
        this.manifestFile = manifestFile;
        this.fullName = fullName;
    }
}

